/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ysld;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.geotools.api.style.ChannelSelection;
import org.geotools.api.style.SelectedChannelType;

public enum Band {
    GRAY("gray"){

        @Override
        public SelectedChannelType getFrom(ChannelSelection sel) {
            return sel.getGrayChannel();
        }

        @Override
        public void setTo(ChannelSelection sel, SelectedChannelType chan) {
            sel.setGrayChannel(chan);
        }
    }
    ,
    RED("red"){

        @Override
        public SelectedChannelType getFrom(ChannelSelection sel) {
            return Optional.ofNullable(sel.getRGBChannels()).map(a -> a[0]).orElse(null);
        }

        @Override
        public void setTo(ChannelSelection sel, SelectedChannelType chan) {
            SelectedChannelType[] channels = sel.getRGBChannels();
            channels[0] = chan;
            sel.setRGBChannels(channels);
        }
    }
    ,
    GREEN("green"){

        @Override
        public SelectedChannelType getFrom(ChannelSelection sel) {
            return Optional.ofNullable(sel.getRGBChannels()).map(a -> a[1]).orElse(null);
        }

        @Override
        public void setTo(ChannelSelection sel, SelectedChannelType chan) {
            SelectedChannelType[] channels = sel.getRGBChannels();
            channels[1] = chan;
            sel.setRGBChannels(channels);
        }
    }
    ,
    BLUE("blue"){

        @Override
        public SelectedChannelType getFrom(ChannelSelection sel) {
            return Optional.ofNullable(sel.getRGBChannels()).map(a -> a[2]).orElse(null);
        }

        @Override
        public void setTo(ChannelSelection sel, SelectedChannelType chan) {
            SelectedChannelType[] channels = sel.getRGBChannels();
            channels[2] = chan;
            sel.setRGBChannels(channels);
        }
    };

    public static final List<Band> RGB;
    public final String key;

    public abstract SelectedChannelType getFrom(ChannelSelection var1);

    public abstract void setTo(ChannelSelection var1, SelectedChannelType var2);

    private Band(String key) {
        this.key = key;
    }

    static {
        RGB = Collections.unmodifiableList(Arrays.asList(RED, GREEN, BLUE));
    }
}

