/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ysld.parse;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.geotools.api.data.Parameter;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.style.FeatureTypeStyle;
import org.geotools.filter.FunctionFactory;
import org.geotools.ysld.ProcessUtil;
import org.geotools.ysld.YamlMap;
import org.geotools.ysld.YamlObject;
import org.geotools.ysld.parse.Factory;
import org.geotools.ysld.parse.Util;
import org.geotools.ysld.parse.YamlParseContext;
import org.geotools.ysld.parse.YsldParseHandler;

public class TransformHandler
extends YsldParseHandler {
    FeatureTypeStyle featureStyle;
    int processes = 0;
    FunctionFactory functionFactory = ProcessUtil.loadProcessFunctionFactory();

    protected TransformHandler(FeatureTypeStyle featureStyle, Factory factory) {
        super(factory);
        this.featureStyle = featureStyle;
    }

    @Override
    public void handle(YamlObject<?> obj, YamlParseContext context) {
        if (this.functionFactory == null) {
            LOG.warning("Unable to load process factory, ignoring transform, ensure process modules installed");
            return;
        }
        YamlMap map = obj.map();
        Function function = this.process(map);
        this.featureStyle.setTransformation((Expression)function);
    }

    Expression envVar(String name) {
        return this.factory.filter.function("env", new Expression[]{this.factory.filter.literal((Object)name)});
    }

    private Function process(YamlMap map) {
        YamlMap params;
        ++this.processes;
        String name = map.str("name");
        if (name == null) {
            throw new IllegalArgumentException("transform must specify a name");
        }
        String input = map.str("input");
        Name qName = ProcessUtil.processName(name);
        Map<String, Parameter<?>> processInfo = ProcessUtil.loadProcessInfo(qName);
        if (processInfo == null) {
            throw new IllegalArgumentException("No such process: " + name);
        }
        boolean wmsParams = ProcessUtil.hasWMSParams(processInfo);
        ArrayList<Function> processArgs = new ArrayList<Function>();
        Function outputBBOX = null;
        Function outputWidth = null;
        Function outputHeight = null;
        if (wmsParams) {
            outputBBOX = this.paramExpression("outputBBOX", Collections.singletonList(this.envVar("wms_bbox")));
            outputWidth = this.paramExpression("outputWidth", Collections.singletonList(this.envVar("wms_width")));
            outputHeight = this.paramExpression("outputHeight", Collections.singletonList(this.envVar("wms_height")));
        }
        if ((params = map.map("params")) != null) {
            block10: for (Map.Entry e : ((Map)params.raw()).entrySet()) {
                String key = (String)e.getKey();
                Object val = e.getValue();
                ArrayList<Expression> valueArgs = new ArrayList<Expression>();
                Parameter<?> p = processInfo.get(key);
                if (p != null) {
                    Expression expr;
                    if (val instanceof String && (expr = Util.expression((String)val, true, this.factory)) != null) {
                        valueArgs.add(expr);
                    }
                    if (valueArgs.isEmpty()) {
                        this.convertAndAdd(val, p, valueArgs);
                    }
                } else {
                    LOG.warning(String.format("unknown transform parameter: %s", key));
                }
                if (valueArgs.isEmpty()) {
                    valueArgs.add((Expression)this.factory.filter.literal(val));
                }
                switch (key) {
                    case "outputBBOX": {
                        outputBBOX = this.paramExpression(key, valueArgs);
                        continue block10;
                    }
                    case "outputWidth": {
                        outputWidth = this.paramExpression(key, valueArgs);
                        continue block10;
                    }
                    case "outputHeight": {
                        outputHeight = this.paramExpression(key, valueArgs);
                        continue block10;
                    }
                }
                processArgs.add(this.paramExpression(key, valueArgs));
            }
        }
        if (input == null && this.processes == 1) {
            input = "data";
        }
        if (input != null) {
            processArgs.add(this.paramExpression(input, Collections.emptyList()));
        }
        if (outputBBOX != null) {
            processArgs.add(outputBBOX);
        }
        if (outputWidth != null) {
            processArgs.add(outputWidth);
        }
        if (outputHeight != null) {
            processArgs.add(outputHeight);
        }
        Function function = this.functionFactory.function(ProcessUtil.processName(name), processArgs, null);
        return function;
    }

    private Function paramExpression(String name, List<Expression> valueArgs) {
        ArrayList<Object> paramArgs = new ArrayList<Object>(valueArgs.size() + 1);
        paramArgs.add(this.factory.filter.literal((Object)name));
        paramArgs.addAll(valueArgs);
        return this.factory.filter.function("parameter", paramArgs.toArray(new Expression[paramArgs.size()]));
    }

    void convertAndAdd(Object val, Parameter<?> p, List<Expression> valueArgs) {
        if (p.getMaxOccurs() > 1 && val instanceof Collection) {
            for (Object o : (Collection)val) {
                valueArgs.add((Expression)this.factory.filter.literal(o));
            }
        } else if (val instanceof Map) {
            YamlMap map = YamlMap.create((Map)val).map();
            valueArgs.add((Expression)this.process(map));
        } else {
            valueArgs.add((Expression)this.factory.filter.literal(val));
        }
    }
}

