/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.db2;

import java.io.IOException;
import java.io.Writer;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.filter.ExcludeFilter;
import org.geotools.api.filter.IncludeFilter;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.filter.spatial.Beyond;
import org.geotools.api.filter.spatial.BinarySpatialOperator;
import org.geotools.api.filter.spatial.Contains;
import org.geotools.api.filter.spatial.Crosses;
import org.geotools.api.filter.spatial.DWithin;
import org.geotools.api.filter.spatial.Disjoint;
import org.geotools.api.filter.spatial.DistanceBufferOperator;
import org.geotools.api.filter.spatial.Equals;
import org.geotools.api.filter.spatial.Intersects;
import org.geotools.api.filter.spatial.Overlaps;
import org.geotools.api.filter.spatial.Touches;
import org.geotools.api.filter.spatial.Within;
import org.geotools.api.filter.temporal.After;
import org.geotools.api.filter.temporal.Before;
import org.geotools.api.filter.temporal.Begins;
import org.geotools.api.filter.temporal.BegunBy;
import org.geotools.api.filter.temporal.During;
import org.geotools.api.filter.temporal.EndedBy;
import org.geotools.api.filter.temporal.Ends;
import org.geotools.api.filter.temporal.TEquals;
import org.geotools.api.filter.temporal.TOverlaps;
import org.geotools.filter.FilterCapabilities;
import org.geotools.filter.function.FilterFunction_strConcat;
import org.geotools.filter.function.FilterFunction_strEndsWith;
import org.geotools.filter.function.FilterFunction_strEqualsIgnoreCase;
import org.geotools.filter.function.FilterFunction_strIndexOf;
import org.geotools.filter.function.FilterFunction_strLength;
import org.geotools.filter.function.FilterFunction_strReplace;
import org.geotools.filter.function.FilterFunction_strStartsWith;
import org.geotools.filter.function.FilterFunction_strSubstring;
import org.geotools.filter.function.FilterFunction_strSubstringStart;
import org.geotools.filter.function.FilterFunction_strToLowerCase;
import org.geotools.filter.function.FilterFunction_strToUpperCase;
import org.geotools.filter.function.FilterFunction_strTrim;
import org.geotools.filter.function.FilterFunction_strTrim2;
import org.geotools.filter.function.math.FilterFunction_abs;
import org.geotools.filter.function.math.FilterFunction_abs_2;
import org.geotools.filter.function.math.FilterFunction_abs_3;
import org.geotools.filter.function.math.FilterFunction_abs_4;
import org.geotools.filter.function.math.FilterFunction_ceil;
import org.geotools.filter.function.math.FilterFunction_floor;
import org.geotools.jdbc.PreparedFilterToSQL;
import org.geotools.jdbc.PreparedStatementSQLDialect;
import org.geotools.jdbc.SQLDialect;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKTWriter;

public class DB2FilterToSQL
extends PreparedFilterToSQL {
    private static Logger LOGGER = Logging.getLogger(DB2FilterToSQL.class);
    private static WKTWriter wktWriter = new WKTWriter();
    private static final Map<String, Double> UNITS_MAP = Map.ofEntries(Map.entry("kilometers", 1000.0), Map.entry("kilometer", 1000.0), Map.entry("meters", 1.0), Map.entry("meter", 1.0), Map.entry("mm", 0.001), Map.entry("millimeter", 0.001), Map.entry("mi", 1609.344), Map.entry("statute miles", 1609.344), Map.entry("miles", 1609.344), Map.entry("mile", 1609.344), Map.entry("nautical miles", 1852.0), Map.entry("NM", 1852.0), Map.entry("feet", 0.3048), Map.entry("ft", 0.3048), Map.entry("in", 0.0254));
    boolean functionEncodingEnabled = false;
    private static HashMap<Class<?>, String> DB2_SPATIAL_PREDICATES = new HashMap();
    private String selectivityClause = null;
    private boolean looseBBOXEnabled = false;

    public DB2FilterToSQL(PreparedStatementSQLDialect dialect) {
        super(dialect);
        DB2_SPATIAL_PREDICATES.put(BBOX.class, "EnvelopesIntersect");
        DB2_SPATIAL_PREDICATES.put(Contains.class, "ST_Contains");
        DB2_SPATIAL_PREDICATES.put(Crosses.class, "ST_Crosses");
        DB2_SPATIAL_PREDICATES.put(Disjoint.class, "ST_Disjoint");
        DB2_SPATIAL_PREDICATES.put(Equals.class, "ST_Equals");
        DB2_SPATIAL_PREDICATES.put(Intersects.class, "ST_Intersects");
        DB2_SPATIAL_PREDICATES.put(Overlaps.class, "ST_Overlaps");
        DB2_SPATIAL_PREDICATES.put(Touches.class, "ST_Touches");
        DB2_SPATIAL_PREDICATES.put(Within.class, "ST_Within");
        DB2_SPATIAL_PREDICATES.put(DWithin.class, "ST_Distance");
        DB2_SPATIAL_PREDICATES.put(Beyond.class, "ST_Distance");
    }

    public DB2FilterToSQL(Writer out) {
        super(out);
        DB2_SPATIAL_PREDICATES.put(BBOX.class, "EnvelopesIntersect");
        DB2_SPATIAL_PREDICATES.put(Contains.class, "ST_Contains");
        DB2_SPATIAL_PREDICATES.put(Crosses.class, "ST_Crosses");
        DB2_SPATIAL_PREDICATES.put(Disjoint.class, "ST_Disjoint");
        DB2_SPATIAL_PREDICATES.put(Equals.class, "ST_Equals");
        DB2_SPATIAL_PREDICATES.put(Intersects.class, "ST_Intersects");
        DB2_SPATIAL_PREDICATES.put(Overlaps.class, "ST_Overlaps");
        DB2_SPATIAL_PREDICATES.put(Touches.class, "ST_Touches");
        DB2_SPATIAL_PREDICATES.put(Within.class, "ST_Within");
        DB2_SPATIAL_PREDICATES.put(DWithin.class, "ST_Distance");
        DB2_SPATIAL_PREDICATES.put(Beyond.class, "ST_Distance");
    }

    public HashMap<Class<?>, String> getPredicateMap() {
        return DB2_SPATIAL_PREDICATES;
    }

    public String db2Geom(Geometry geom) {
        String geomType = geom.getGeometryType();
        String g1 = geom.toText();
        String g2 = "db2gse.ST_" + geomType + "('" + g1 + "'," + this.getSRID() + ")";
        return g2;
    }

    protected FilterCapabilities createFilterCapabilities() {
        FilterCapabilities caps = new FilterCapabilities();
        caps.addAll(SQLDialect.BASE_DBMS_CAPABILITIES);
        caps.addType(BBOX.class);
        caps.addType(Contains.class);
        caps.addType(Crosses.class);
        caps.addType(Disjoint.class);
        caps.addType(Equals.class);
        caps.addType(Intersects.class);
        caps.addType(Overlaps.class);
        caps.addType(Touches.class);
        caps.addType(Within.class);
        caps.addType(DWithin.class);
        caps.addType(Beyond.class);
        caps.addType(After.class);
        caps.addType(Before.class);
        caps.addType(Begins.class);
        caps.addType(BegunBy.class);
        caps.addType(During.class);
        caps.addType(TOverlaps.class);
        caps.addType(Ends.class);
        caps.addType(EndedBy.class);
        caps.addType(TEquals.class);
        if (this.isFunctionEncodingEnabled()) {
            caps.addType(FilterFunction_strConcat.class);
            caps.addType(FilterFunction_strEndsWith.class);
            caps.addType(FilterFunction_strStartsWith.class);
            caps.addType(FilterFunction_strEqualsIgnoreCase.class);
            caps.addType(FilterFunction_strIndexOf.class);
            caps.addType(FilterFunction_strLength.class);
            caps.addType(FilterFunction_strToLowerCase.class);
            caps.addType(FilterFunction_strToUpperCase.class);
            caps.addType(FilterFunction_strReplace.class);
            caps.addType(FilterFunction_strSubstring.class);
            caps.addType(FilterFunction_strSubstringStart.class);
            caps.addType(FilterFunction_strTrim.class);
            caps.addType(FilterFunction_strTrim2.class);
            caps.addType(FilterFunction_abs.class);
            caps.addType(FilterFunction_abs_2.class);
            caps.addType(FilterFunction_abs_3.class);
            caps.addType(FilterFunction_abs_4.class);
            caps.addType(FilterFunction_ceil.class);
            caps.addType(FilterFunction_floor.class);
        }
        return caps;
    }

    public void setSelectivityClause(String string) {
        this.selectivityClause = string;
    }

    protected Object visitBinarySpatialOperator(BinarySpatialOperator filter, PropertyName property, Literal geometry, boolean swapped, Object extraData) {
        if (filter instanceof DistanceBufferOperator) {
            return this.visitDistanceSpatialOperator((DistanceBufferOperator)filter, property, geometry, swapped, extraData);
        }
        return this.visitBinarySpatialOperator(filter, (Expression)property, (Expression)geometry, swapped, extraData);
    }

    private boolean isValidUnit(String unit) {
        return UNITS_MAP.get(unit) != null;
    }

    private String toMeters(double distance, String unit) {
        Double conversion = UNITS_MAP.get(unit);
        if (conversion != null) {
            return String.valueOf(distance * conversion);
        }
        return String.valueOf(distance);
    }

    Object visitDistanceSpatialOperator(DistanceBufferOperator filter, PropertyName property, Literal geometry, boolean swapped, Object extraData) {
        try {
            String comparisonOperator = ") < ";
            if (filter instanceof DWithin && swapped || filter instanceof Beyond && !swapped) {
                comparisonOperator = ") > ";
            }
            this.out.write("db2gse.ST_Distance(");
            property.accept((ExpressionVisitor)this, extraData);
            this.out.write(",");
            geometry.accept((ExpressionVisitor)this, extraData);
            String distanceUnits = filter.getDistanceUnits();
            if (this.isValidUnit(distanceUnits)) {
                this.out.write(",'METER'");
            }
            this.out.write(comparisonOperator);
            this.out.write(this.toMeters(filter.getDistance(), filter.getDistanceUnits()));
            if (!this.isValidUnit(distanceUnits)) {
                this.addSelectivity();
            }
            return extraData;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected Object visitBinarySpatialOperator(BinarySpatialOperator filter, Expression e1, Expression e2, Object extraData) {
        return this.visitBinarySpatialOperator(filter, e1, e2, false, extraData);
    }

    protected Object visitBinarySpatialOperator(BinarySpatialOperator filter, Expression e1, Expression e2, boolean swapped, Object extraData) {
        String checkValue = "1";
        try {
            LOGGER.finer("Generating GeometryFilter WHERE clause for " + filter);
            if (filter instanceof Equals) {
                this.out.write("db2gse.ST_Equals");
            } else if (filter instanceof Disjoint && this.selectivityClause == null) {
                this.out.write("db2gse.ST_Disjoint");
            } else if (filter instanceof Disjoint && this.selectivityClause != null) {
                this.out.write("db2gse.ST_Intersects");
                checkValue = "0";
            } else if (filter instanceof Intersects || filter instanceof BBOX) {
                if (this.isLooseBBOXEnabled()) {
                    this.out.write("db2gse.EnvelopesIntersect");
                } else {
                    this.out.write("db2gse.ST_Intersects");
                }
            } else if (filter instanceof Crosses) {
                this.out.write("db2gse.ST_Crosses");
            } else if (filter instanceof Within) {
                if (swapped) {
                    this.out.write("db2gse.ST_Contains");
                } else {
                    this.out.write("db2gse.ST_Within");
                }
            } else if (filter instanceof Contains) {
                if (swapped) {
                    this.out.write("db2gse.ST_Within");
                } else {
                    this.out.write("db2gse.ST_Contains");
                }
            } else if (filter instanceof Overlaps) {
                this.out.write("db2gse.ST_Overlaps");
            } else if (filter instanceof Touches) {
                this.out.write("db2gse.ST_Touches");
            } else {
                throw new RuntimeException("Unsupported filter type " + filter.getClass());
            }
            this.out.write("(");
            e1.accept((ExpressionVisitor)this, extraData);
            this.out.write(", ");
            e2.accept((ExpressionVisitor)this, extraData);
            this.out.write(") = ");
            this.out.write(checkValue);
            this.out.write(" ");
            this.addSelectivity();
            LOGGER.fine(this.out.toString());
            return extraData;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void visitLiteralGeometry(Literal expression) throws IOException {
        String wktRepresentation = wktWriter.write((Geometry)expression.getValue());
        int spacePos = wktRepresentation.indexOf(" ");
        String geomType = wktRepresentation.substring(0, spacePos);
        this.out.write("db2gse.ST_" + geomType + "('" + wktRepresentation + "', " + this.getSRID() + ")");
    }

    protected void addSelectivity() throws IOException {
        if (this.selectivityClause != null) {
            this.out.write(" " + this.selectivityClause);
        }
    }

    public Object visit(ExcludeFilter filter, Object extraData) {
        try {
            this.out.write("1=0");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return extraData;
    }

    public Object visit(IncludeFilter filter, Object extraData) {
        try {
            this.out.write("1=1");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return extraData;
    }

    private Integer getSRID() {
        return this.getSRID(this.featureType.getGeometryDescriptor());
    }

    private Integer getSRID(GeometryDescriptor gDescr) {
        Integer result = null;
        if (gDescr != null) {
            result = (Integer)gDescr.getUserData().get("nativeSRID");
        }
        if (result == null) {
            result = this.currentSRID;
        }
        return result;
    }

    public boolean isLooseBBOXEnabled() {
        return this.looseBBOXEnabled;
    }

    public void setLooseBBOXEnabled(boolean looseBBOXEnabled) {
        this.looseBBOXEnabled = looseBBOXEnabled;
    }

    protected void writeLiteral(Object literal) throws IOException {
        if (literal instanceof java.util.Date) {
            this.out.write("'");
            if (literal instanceof Date) {
                SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
                this.out.write(DATE_FORMAT.format(literal));
            } else {
                SimpleDateFormat DATETIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                this.out.write(DATETIME_FORMAT.format(literal));
            }
            this.out.write("'");
        } else {
            super.writeLiteral(literal);
        }
    }

    public boolean isFunctionEncodingEnabled() {
        return this.functionEncodingEnabled;
    }

    public void setFunctionEncodingEnabled(boolean functionEncodingEnabled) {
        this.functionEncodingEnabled = functionEncodingEnabled;
    }

    public boolean visitFunction(Function function, Object extraData) throws IOException {
        if (function instanceof FilterFunction_strConcat) {
            Expression s1 = this.getParameter(function, 0, true);
            Expression s2 = this.getParameter(function, 1, true);
            this.out.write("(");
            s1.accept((ExpressionVisitor)this, String.class);
            this.out.write(" || ");
            s2.accept((ExpressionVisitor)this, String.class);
            this.out.write(")");
        } else if (function instanceof FilterFunction_strEndsWith) {
            Expression str = this.getParameter(function, 0, true);
            Expression end = this.getParameter(function, 1, true);
            this.out.write(" case when ");
            this.out.write("( right (");
            str.accept((ExpressionVisitor)this, String.class);
            this.out.write(",length( ");
            if (end instanceof Literal) {
                this.out.write(" cast (");
            }
            end.accept((ExpressionVisitor)this, String.class);
            if (end instanceof Literal) {
                this.out.write(" as  VARCHAR(32672))");
            }
            this.out.write("))=");
            end.accept((ExpressionVisitor)this, String.class);
            this.out.write(")");
            this.out.write("then 1 else 0 end ");
        } else if (function instanceof FilterFunction_strStartsWith) {
            Expression str = this.getParameter(function, 0, true);
            Expression start = this.getParameter(function, 1, true);
            this.out.write(" case when ");
            this.out.write("( left (");
            str.accept((ExpressionVisitor)this, String.class);
            this.out.write(",length( ");
            if (start instanceof Literal) {
                this.out.write(" cast (");
            }
            start.accept((ExpressionVisitor)this, String.class);
            if (start instanceof Literal) {
                this.out.write(" as  VARCHAR(32672))");
            }
            this.out.write("))=");
            start.accept((ExpressionVisitor)this, String.class);
            this.out.write(")");
            this.out.write("then 1 else 0 end ");
        } else if (function instanceof FilterFunction_strEqualsIgnoreCase) {
            Expression first = this.getParameter(function, 0, true);
            Expression second = this.getParameter(function, 1, true);
            this.out.write(" case when ");
            this.out.write("(lower(");
            first.accept((ExpressionVisitor)this, String.class);
            this.out.write(") = lower(");
            second.accept((ExpressionVisitor)this, String.class);
            this.out.write("))");
            this.out.write("then 1 else 0 end ");
        } else if (function instanceof FilterFunction_strIndexOf) {
            Expression first = this.getParameter(function, 0, true);
            Expression second = this.getParameter(function, 1, true);
            this.out.write("(locate(");
            second.accept((ExpressionVisitor)this, String.class);
            this.out.write(", ");
            first.accept((ExpressionVisitor)this, String.class);
            this.out.write(") - 1)");
        } else if (function instanceof FilterFunction_strSubstring) {
            Expression string = this.getParameter(function, 0, true);
            Expression start = this.getParameter(function, 1, true);
            Expression end = this.getParameter(function, 2, true);
            this.out.write("substr(");
            string.accept((ExpressionVisitor)this, String.class);
            this.out.write(", ");
            start.accept((ExpressionVisitor)this, Integer.class);
            this.out.write(" + 1, (");
            end.accept((ExpressionVisitor)this, Integer.class);
            this.out.write(" - ");
            start.accept((ExpressionVisitor)this, Integer.class);
            this.out.write("))");
        } else if (function instanceof FilterFunction_strSubstringStart) {
            Expression string = this.getParameter(function, 0, true);
            Expression start = this.getParameter(function, 1, true);
            this.out.write("substr(");
            string.accept((ExpressionVisitor)this, String.class);
            this.out.write(", ");
            start.accept((ExpressionVisitor)this, Integer.class);
            this.out.write(" + 1)");
        } else if (function instanceof FilterFunction_strTrim) {
            Expression string = this.getParameter(function, 0, true);
            this.out.write("trim(both ' ' from ");
            string.accept((ExpressionVisitor)this, String.class);
            this.out.write(")");
        } else if (function instanceof FilterFunction_strLength) {
            Expression string = this.getParameter(function, 0, true);
            this.out.write("length(");
            string.accept((ExpressionVisitor)this, String.class);
            this.out.write(")");
        } else if (function instanceof FilterFunction_strToLowerCase) {
            Expression string = this.getParameter(function, 0, true);
            this.out.write("lower(");
            string.accept((ExpressionVisitor)this, String.class);
            this.out.write(")");
        } else if (function instanceof FilterFunction_strToUpperCase) {
            Expression string = this.getParameter(function, 0, true);
            this.out.write("upper(");
            string.accept((ExpressionVisitor)this, String.class);
            this.out.write(")");
        } else if (function instanceof FilterFunction_abs || function instanceof FilterFunction_abs_2 || function instanceof FilterFunction_abs_3 || function instanceof FilterFunction_abs_4) {
            Expression string = this.getParameter(function, 0, true);
            this.out.write("CAST (");
            this.out.write("abs(");
            string.accept((ExpressionVisitor)this, String.class);
            this.out.write(")");
            this.out.write(" AS ");
            String db2Type = null;
            if (function instanceof FilterFunction_abs) {
                db2Type = "SMALLINT";
            }
            if (function instanceof FilterFunction_abs_2) {
                db2Type = "INT";
            }
            if (function instanceof FilterFunction_abs_3) {
                db2Type = "FLOAT";
            }
            if (function instanceof FilterFunction_abs_4) {
                db2Type = "DOUBLE";
            }
            this.out.write(db2Type);
            this.out.write(")");
        } else {
            return false;
        }
        return true;
    }

    public Object visit(Function function, Object extraData) throws RuntimeException {
        try {
            this.encodingFunction = false;
            boolean encoded = this.visitFunction(function, extraData);
            if (encoded) {
                return extraData;
            }
            return super.visit(function, extraData);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

