/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.h2;

import geodb.GeoDB;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import org.geotools.geometry.jts.Geometries;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.SQLDialect;
import org.geotools.referencing.CRS;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKTWriter;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class H2Dialect
extends SQLDialect {
    public static String H2_SPATIAL_INDEX = "org.geotools.data.h2.spatialIndex";

    public H2Dialect(JDBCDataStore dataStore) {
        super(dataStore);
    }

    public String getNameEscape() {
        return "\"";
    }

    public void initializeConnection(Connection cx) throws SQLException {
        GeoDB.InitGeoDB((Connection)cx);
    }

    public boolean includeTable(String schemaName, String tableName, Connection cx) throws SQLException {
        if ("_GEODB".equals(tableName) || tableName.endsWith("_HATBOX")) {
            return false;
        }
        return !"GEOMETRY_COLUMNS".equalsIgnoreCase(tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> getMapping(ResultSet columnMetaData, Connection cx) throws SQLException {
        Geometries g;
        String typeName = columnMetaData.getString("TYPE_NAME");
        if ("UUID".equalsIgnoreCase(typeName)) {
            return UUID.class;
        }
        if ("BLOB".equalsIgnoreCase(typeName) || "VARBINARY".equalsIgnoreCase(typeName)) {
            String schemaName = columnMetaData.getString("TABLE_SCHEM");
            String tableName = columnMetaData.getString("TABLE_NAME");
            String columnName = columnMetaData.getString("COLUMN_NAME");
            StringBuffer sql = new StringBuffer("SELECT type FROM geometry_columns WHERE ");
            if (schemaName != null) {
                sql.append("f_table_schema = '").append(schemaName).append("'").append(" AND ");
            }
            sql.append("f_table_name = '").append(tableName).append("' AND ");
            sql.append("f_geometry_column = '").append(columnName).append("'");
            Statement st = cx.createStatement();
            try {
                LOGGER.fine(sql.toString());
                ResultSet rs = st.executeQuery(sql.toString());
                try {
                    if (rs.next()) {
                        String type = rs.getString(1);
                        Geometries g2 = Geometries.getForName((String)type);
                        if (g2 != null) {
                            Class clazz = g2.getBinding();
                            return clazz;
                        }
                        LOGGER.warning("Geometry type " + type + " not supported.");
                    }
                }
                finally {
                    this.dataStore.closeSafe(rs);
                }
            }
            finally {
                this.dataStore.closeSafe(st);
            }
            return byte[].class;
        }
        String remark = columnMetaData.getString("REMARKS");
        if (remark != null && (g = Geometries.getForName((String)remark)) != null) {
            return g.getBinding();
        }
        return null;
    }

    public void encodePostColumnCreateTable(AttributeDescriptor att, StringBuffer sql) {
        Class binding;
        if (att instanceof GeometryDescriptor && this.isConcreteGeometry(binding = att.getType().getBinding())) {
            sql.append(" COMMENT '").append(binding.getSimpleName().toUpperCase()).append("'");
        }
    }

    public void registerSqlTypeToClassMappings(Map<Integer, Class<?>> mappings) {
        super.registerSqlTypeToClassMappings(mappings);
        mappings.remove(2004);
    }

    public void registerClassToSqlMappings(Map<Class<?>, Integer> mappings) {
        super.registerClassToSqlMappings(mappings);
        mappings.put(Geometry.class, 2004);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCreateTable(String schemaName, SimpleFeatureType featureType, Connection cx) throws SQLException {
        Statement st = cx.createStatement();
        try {
            String tableName = featureType.getTypeName();
            schemaName = schemaName != null ? schemaName : "PUBLIC";
            for (PropertyDescriptor ad : featureType.getDescriptors()) {
                if (!(ad instanceof GeometryDescriptor)) continue;
                GeometryDescriptor gd = (GeometryDescriptor)ad;
                Class binding = ad.getType().getBinding();
                String propertyName = ad.getName().getLocalPart();
                int epsg = -1;
                try {
                    CoordinateReferenceSystem crs = gd.getCoordinateReferenceSystem();
                    if (crs != null) {
                        Integer code = CRS.lookupEpsgCode((CoordinateReferenceSystem)crs, (boolean)true);
                        epsg = code != null ? code : -1;
                    } else {
                        LOGGER.warning("Column " + gd.getLocalName() + " has no crs");
                    }
                }
                catch (FactoryException e) {
                    LOGGER.log(Level.FINER, "Unable to look epsg code", e);
                }
                StringBuffer sql = new StringBuffer();
                sql.append("CALL AddGeometryColumn(");
                sql.append("'").append(schemaName).append("'");
                sql.append(", '").append(tableName).append("'");
                sql.append(", '").append(gd.getLocalName()).append("'");
                sql.append(", ").append(epsg);
                sql.append(", '").append(Geometries.getForBinding((Class)binding).getName()).append("'");
                sql.append(", ").append(2);
                sql.append(")");
                LOGGER.fine(sql.toString());
                st.execute(sql.toString());
                if (epsg == -1) continue;
                sql = new StringBuffer();
                sql.append("CALL CreateSpatialIndex(");
                if (schemaName == null) {
                    sql.append("NULL");
                } else {
                    sql.append("'").append(schemaName).append("'");
                }
                sql.append(",'").append(tableName).append("'");
                sql.append(",'").append(propertyName).append("'");
                sql.append(",'").append(epsg).append("')");
                LOGGER.fine(sql.toString());
                st.execute(sql.toString());
            }
        }
        finally {
            this.dataStore.closeSafe(st);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCreateFeatureType(SimpleFeatureType featureType, DatabaseMetaData metadata, String schemaName, Connection cx) throws SQLException {
        if (featureType.getGeometryDescriptor() == null) {
            return;
        }
        String idxTableName = featureType.getTypeName() + "_HATBOX";
        ResultSet rs = metadata.getTables(null, this.dataStore.escapeNamePattern(metadata, schemaName), this.dataStore.escapeNamePattern(metadata, idxTableName), new String[]{"TABLE"});
        try {
            if (rs.next()) {
                featureType.getGeometryDescriptor().getUserData().put(H2_SPATIAL_INDEX, idxTableName);
            }
        }
        finally {
            this.dataStore.closeSafe(rs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preDropTable(String schemaName, SimpleFeatureType featureType, Connection cx) throws SQLException {
        String tableName = featureType.getTypeName();
        Statement st = cx.createStatement();
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("CALL DropSpatialIndex(");
            if (schemaName == null) {
                sql.append("NULL");
            } else {
                sql.append("'").append(schemaName).append("'");
            }
            sql.append(",'").append(tableName).append("')");
            LOGGER.fine(sql.toString());
            try {
                st.execute(sql.toString());
            }
            catch (SQLException e) {
                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            }
            sql = new StringBuffer();
            sql.append("CALL DropGeometryColumns(");
            if (schemaName == null) {
                sql.append("NULL");
            } else {
                sql.append("'").append(schemaName).append("'");
            }
            sql.append(",'").append(tableName).append("')");
            LOGGER.fine(sql.toString());
            st.execute(sql.toString());
        }
        finally {
            this.dataStore.closeSafe(st);
        }
    }

    boolean isConcreteGeometry(Class binding) {
        return Point.class.isAssignableFrom(binding) || LineString.class.isAssignableFrom(binding) || Polygon.class.isAssignableFrom(binding) || MultiPoint.class.isAssignableFrom(binding) || MultiLineString.class.isAssignableFrom(binding) || MultiPolygon.class.isAssignableFrom(binding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getGeometrySRID(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        int srid = GeoDB.GetSRID((Connection)cx, (String)schemaName, (String)tableName);
        if (srid > -1) {
            return srid;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ST_SRID(");
        this.encodeColumnName(null, columnName, sql);
        sql.append(") ");
        sql.append("FROM ");
        if (schemaName != null) {
            this.encodeTableName(schemaName, sql);
            sql.append(".");
        }
        this.encodeSchemaName(tableName, sql);
        sql.append(" WHERE ");
        this.encodeColumnName(null, columnName, sql);
        sql.append(" is not null LIMIT 1");
        this.dataStore.getLogger().fine(sql.toString());
        Statement st = cx.createStatement();
        try {
            ResultSet rs;
            block10: {
                Integer n;
                rs = st.executeQuery(sql.toString());
                try {
                    if (!rs.next()) break block10;
                    n = rs.getInt(1);
                }
                catch (Throwable throwable) {
                    this.dataStore.closeSafe(rs);
                    throw throwable;
                }
                this.dataStore.closeSafe(rs);
                return n;
            }
            Integer n = null;
            this.dataStore.closeSafe(rs);
            return n;
        }
        finally {
            this.dataStore.closeSafe(st);
        }
    }

    public void encodeGeometryEnvelope(String tableName, String geometryColumn, StringBuffer sql) {
        sql.append("ST_Envelope(");
        this.encodeColumnName(null, geometryColumn, sql);
        sql.append(")");
    }

    public Envelope decodeGeometryEnvelope(ResultSet rs, int column, Connection cx) throws SQLException, IOException {
        return (Envelope)rs.getObject(column);
    }

    public void encodeGeometryValue(Geometry value, int srid, StringBuffer sql) throws IOException {
        if (value == null || value.isEmpty()) {
            sql.append("ST_GeomFromText ('");
            sql.append(new WKTWriter().write(value));
            sql.append("',");
            sql.append(srid);
            sql.append(")");
        } else {
            sql.append("NULL");
        }
    }

    public Geometry decodeGeometryValue(GeometryDescriptor descriptor, ResultSet rs, String column, GeometryFactory factory, Connection cx, Hints hints) throws IOException, SQLException {
        byte[] bytes = rs.getBytes(column);
        if (bytes == null) {
            return null;
        }
        try {
            return new WKBReader(factory).read(bytes);
        }
        catch (ParseException e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    public void encodePrimaryKey(String column, StringBuffer sql) {
        this.encodeColumnName(null, column, sql);
        sql.append(" int AUTO_INCREMENT(1) PRIMARY KEY");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSequenceForColumn(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        String sequenceName = tableName + "_" + columnName + "_SEQUENCE";
        sequenceName = sequenceName.toUpperCase();
        Statement st = cx.createStatement();
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT * FROM INFORMATION_SCHEMA.SEQUENCES ");
            sql.append("WHERE SEQUENCE_NAME = '").append(sequenceName).append("'");
            this.dataStore.getLogger().fine(sql.toString());
            ResultSet rs = st.executeQuery(sql.toString());
            try {
                if (rs.next()) {
                    String string = sequenceName;
                    return string;
                }
            }
            finally {
                this.dataStore.closeSafe(rs);
            }
        }
        finally {
            this.dataStore.closeSafe(st);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getNextSequenceValue(String schemaName, String sequenceName, Connection cx) throws SQLException {
        Statement st = cx.createStatement();
        try {
            Integer n;
            String sql = "SELECT " + this.encodeNextSequenceValue(schemaName, sequenceName);
            this.dataStore.getLogger().fine(sql);
            ResultSet rs = st.executeQuery(sql);
            try {
                if (!rs.next()) {
                    throw new SQLException("Could not find a next value for sequence");
                }
                n = rs.getInt(1);
            }
            catch (Throwable throwable) {
                this.dataStore.closeSafe(rs);
                throw throwable;
            }
            this.dataStore.closeSafe(rs);
            return n;
        }
        finally {
            this.dataStore.closeSafe(st);
        }
    }

    public String encodeNextSequenceValue(String schemaName, String sequenceName) {
        return "NEXTVAL('" + sequenceName + "')";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getNextAutoGeneratedValue(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        Statement st = cx.createStatement();
        try {
            Integer n;
            String sequence = null;
            ResultSet rs = st.executeQuery("SELECT b.COLUMN_DEFAULT  FROM INFORMATION_SCHEMA.INDEXES A, INFORMATION_SCHEMA.COLUMNS B WHERE a.TABLE_NAME = b.TABLE_NAME  AND a.COLUMN_NAME = b.COLUMN_NAME  AND a.TABLE_NAME = '" + tableName + "'  AND a.COLUMN_NAME = '" + columnName + "'  AND a.PRIMARY_KEY = TRUE");
            try {
                if (!rs.next()) {
                    throw new SQLException("Could not grab the next auto generated value");
                }
                String string = rs.getString(1);
                sequence = string.substring(string.indexOf("SYSTEM_SEQUENCE"), string.length() - 1);
            }
            finally {
                this.dataStore.closeSafe(rs);
            }
            try {
                rs = schemaName != null ? st.executeQuery("SELECT CURRVAL('" + schemaName + "','" + sequence + "')") : st.executeQuery("SELECT CURRVAL('" + sequence + "')");
                rs.next();
                int value = rs.getInt(1);
                n = value + 1;
            }
            catch (Throwable throwable) {
                this.dataStore.closeSafe(rs);
                throw throwable;
            }
            this.dataStore.closeSafe(rs);
            return n;
        }
        finally {
            this.dataStore.closeSafe(st);
        }
    }

    public boolean isLimitOffsetSupported() {
        return true;
    }

    public void applyLimitOffset(StringBuffer sql, int limit, int offset) {
        if (limit >= 0 && limit < Integer.MAX_VALUE) {
            sql.append(" LIMIT " + limit);
            if (offset > 0) {
                sql.append(" OFFSET " + offset);
            }
        } else if (offset > 0) {
            sql.append(" LIMIT 2147483647");
            sql.append(" OFFSET " + offset);
        }
    }

    protected boolean supportsSchemaForIndex() {
        return true;
    }

    public void registerSqlTypeToSqlTypeNameOverrides(Map<Integer, String> overrides) {
        overrides.put(2004, "BYTEA");
    }
}

