/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.hana;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.hana.HanaConnectionParameters;
import org.geotools.data.hana.HanaDialect;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.JDBCDataStoreFactory;
import org.geotools.jdbc.SQLDialect;

public class HanaDataStoreFactory
extends JDBCDataStoreFactory {
    public static final DataAccessFactory.Param DBTYPE = new DataAccessFactory.Param("dbtype", String.class, "Type", true, (Object)"hana", Collections.singletonMap("level", "program"));
    public static final DataAccessFactory.Param PORT = new DataAccessFactory.Param("port", Integer.class, "Port", false);
    public static final DataAccessFactory.Param INSTANCE = new DataAccessFactory.Param("instance", Integer.class, "Instance Number", false);
    public static final DataAccessFactory.Param USE_SSL = new DataAccessFactory.Param("use ssl", Boolean.class, "Use SSL", false);
    public static final DataAccessFactory.Param ENCODE_FUNCTIONS = new DataAccessFactory.Param("encode functions", Boolean.class, "Set to true to have a set of filter functions be translated directly in SQL. Due to differences in the type systems the result might not be the same as evaluating them in memory, including the SQL failing with errors while the in memory version works fine. However this allows to push more of the filter into the database, increasing performance.", false, (Object)Boolean.FALSE, Collections.singletonMap("level", "advanced"));
    private static final String DESCRIPTION = "SAP HANA";
    private static final String DRIVER_CLASS_NAME = "com.sap.db.jdbc.Driver";

    public String getDescription() {
        return DESCRIPTION;
    }

    protected String getDatabaseID() {
        return (String)HanaDataStoreFactory.DBTYPE.sample;
    }

    protected String getDriverClassName() {
        return DRIVER_CLASS_NAME;
    }

    protected SQLDialect createSQLDialect(JDBCDataStore dataStore) {
        return new HanaDialect(dataStore);
    }

    protected String getValidationQuery() {
        return "SELECT 1 FROM DUMMY";
    }

    protected void setupParameters(Map parameters) {
        super.setupParameters(parameters);
        parameters.put(HanaDataStoreFactory.DBTYPE.key, DBTYPE);
        parameters.put(HanaDataStoreFactory.PORT.key, PORT);
        parameters.put(HanaDataStoreFactory.INSTANCE.key, INSTANCE);
        parameters.put(HanaDataStoreFactory.USE_SSL.key, USE_SSL);
        parameters.put(HanaDataStoreFactory.ENCODE_FUNCTIONS.key, ENCODE_FUNCTIONS);
    }

    protected String getJDBCUrl(Map params) throws IOException {
        String host = (String)HOST.lookUp(params);
        Integer port = (Integer)PORT.lookUp(params);
        Integer instance = (Integer)INSTANCE.lookUp(params);
        String database = (String)DATABASE.lookUp(params);
        Boolean useSsl = (Boolean)USE_SSL.lookUp(params);
        HashMap<String, String> options = new HashMap<String, String>();
        if (useSsl != null && useSsl.booleanValue()) {
            options.put("encrypt", "true");
        }
        if (port != null && port != 0) {
            return HanaConnectionParameters.forPort(host, port, options).buildUrl();
        }
        if (instance == null) {
            throw new IOException("Either a port or an instance number must be given in the connection properties");
        }
        if (database != null && !database.isEmpty()) {
            return HanaConnectionParameters.forMultiContainer(host, instance, database, options).buildUrl();
        }
        return HanaConnectionParameters.forSingleContainer(host, instance, options).buildUrl();
    }

    protected JDBCDataStore createDataStoreInternal(JDBCDataStore dataStore, Map params) throws IOException {
        HanaDialect dialect = (HanaDialect)dataStore.getSQLDialect();
        Boolean encodeFunctions = (Boolean)ENCODE_FUNCTIONS.lookUp(params);
        dialect.setFunctionEncodingEnabled(encodeFunctions != null && encodeFunctions != false);
        return dataStore;
    }
}

