/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.hana;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import org.geotools.data.hana.HanaDimensionFinder;
import org.geotools.data.hana.HanaUtil;
import org.geotools.data.hana.HanaVersion;
import org.geotools.data.hana.wkb.HanaWKBWriter;
import org.geotools.data.hana.wkb.HanaWKBWriterException;
import org.geotools.filter.FilterCapabilities;
import org.geotools.filter.function.FilterFunction_strConcat;
import org.geotools.filter.function.FilterFunction_strEndsWith;
import org.geotools.filter.function.FilterFunction_strEqualsIgnoreCase;
import org.geotools.filter.function.FilterFunction_strIndexOf;
import org.geotools.filter.function.FilterFunction_strLength;
import org.geotools.filter.function.FilterFunction_strStartsWith;
import org.geotools.filter.function.FilterFunction_strSubstring;
import org.geotools.filter.function.FilterFunction_strSubstringStart;
import org.geotools.filter.function.FilterFunction_strToLowerCase;
import org.geotools.filter.function.FilterFunction_strToUpperCase;
import org.geotools.filter.function.FilterFunction_strTrim;
import org.geotools.filter.function.math.FilterFunction_abs;
import org.geotools.filter.function.math.FilterFunction_abs_2;
import org.geotools.filter.function.math.FilterFunction_abs_3;
import org.geotools.filter.function.math.FilterFunction_abs_4;
import org.geotools.filter.function.math.FilterFunction_ceil;
import org.geotools.filter.function.math.FilterFunction_floor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.jdbc.PreparedFilterToSQL;
import org.geotools.jdbc.PreparedStatementSQLDialect;
import org.geotools.jdbc.SQLDialect;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.BBOX3D;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.DistanceBufferOperator;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;
import org.opengis.filter.temporal.After;
import org.opengis.filter.temporal.Before;
import org.opengis.filter.temporal.Begins;
import org.opengis.filter.temporal.BegunBy;
import org.opengis.filter.temporal.During;
import org.opengis.filter.temporal.EndedBy;
import org.opengis.filter.temporal.Ends;
import org.opengis.filter.temporal.TEquals;
import org.opengis.filter.temporal.TOverlaps;
import org.opengis.geometry.BoundingBox;
import org.opengis.geometry.BoundingBox3D;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.SingleCRS;

public class HanaFilterToSQL
extends PreparedFilterToSQL {
    private static final Map<String, Double> UNITS_MAP = new HashMap<String, Double>();
    private boolean functionEncodingEnabled;
    private HanaVersion hanaVersion;
    private static final int FLAT_OFFSET = 1000000000;
    private static final char[] HEXDIGITS;

    public HanaFilterToSQL(PreparedStatementSQLDialect dialect, boolean functionEncodingEnabled, HanaVersion hanaVersion) {
        super(dialect);
        this.functionEncodingEnabled = functionEncodingEnabled;
        this.hanaVersion = hanaVersion;
    }

    protected FilterCapabilities createFilterCapabilities() {
        FilterCapabilities caps = new FilterCapabilities();
        caps.addAll(SQLDialect.BASE_DBMS_CAPABILITIES);
        caps.addType(BBOX.class);
        caps.addType(Contains.class);
        caps.addType(Crosses.class);
        caps.addType(Disjoint.class);
        caps.addType(Equals.class);
        caps.addType(Intersects.class);
        caps.addType(Overlaps.class);
        caps.addType(Touches.class);
        caps.addType(Within.class);
        caps.addType(DWithin.class);
        caps.addType(Beyond.class);
        caps.addType(After.class);
        caps.addType(Before.class);
        caps.addType(Begins.class);
        caps.addType(BegunBy.class);
        caps.addType(During.class);
        caps.addType(TOverlaps.class);
        caps.addType(Ends.class);
        caps.addType(EndedBy.class);
        caps.addType(TEquals.class);
        if (this.functionEncodingEnabled) {
            caps.addType(FilterFunction_strConcat.class);
            caps.addType(FilterFunction_strEndsWith.class);
            caps.addType(FilterFunction_strStartsWith.class);
            caps.addType(FilterFunction_strEqualsIgnoreCase.class);
            caps.addType(FilterFunction_strIndexOf.class);
            caps.addType(FilterFunction_strLength.class);
            caps.addType(FilterFunction_strToLowerCase.class);
            caps.addType(FilterFunction_strToUpperCase.class);
            caps.addType(FilterFunction_strSubstring.class);
            caps.addType(FilterFunction_strSubstringStart.class);
            caps.addType(FilterFunction_strTrim.class);
            caps.addType(FilterFunction_abs.class);
            caps.addType(FilterFunction_abs_2.class);
            caps.addType(FilterFunction_abs_3.class);
            caps.addType(FilterFunction_abs_4.class);
            caps.addType(FilterFunction_ceil.class);
            caps.addType(FilterFunction_floor.class);
        }
        return caps;
    }

    protected Object visitBinarySpatialOperator(BinarySpatialOperator filter, PropertyName property, Literal geometry, boolean swapped, Object extraData) {
        if (filter instanceof DistanceBufferOperator) {
            return this.visitDistanceSpatialOperator((DistanceBufferOperator)filter, property, geometry, swapped, extraData);
        }
        if (filter instanceof BBOX) {
            return this.visitBBOXSpatialOperator((BBOX)filter, property, geometry, extraData);
        }
        return this.visitBinarySpatialOperator(filter, (Expression)property, (Expression)geometry, swapped, extraData);
    }

    protected Object visitBinarySpatialOperator(BinarySpatialOperator filter, Expression e1, Expression e2, Object extraData) {
        return this.visitBinarySpatialOperator(filter, e1, e2, false, extraData);
    }

    protected void visitLiteralGeometry(Literal expression) throws IOException {
        Geometry geom = (Geometry)this.evaluateLiteral(expression, Geometry.class);
        this.visitGeometry(geom);
    }

    private Object visitDistanceSpatialOperator(DistanceBufferOperator filter, PropertyName property, Literal geometry, boolean swapped, Object extraData) {
        if (!(filter instanceof DWithin) && !(filter instanceof Beyond)) {
            throw new IllegalArgumentException("Unsupported filter type " + filter.getClass());
        }
        try {
            property.accept((ExpressionVisitor)this, extraData);
            this.out.write(".ST_WithinDistance(");
            geometry.accept((ExpressionVisitor)this, extraData);
            this.out.write(", ");
            String unit = filter.getDistanceUnits();
            if (UNITS_MAP.containsKey(unit)) {
                double distInMeters = filter.getDistance() * UNITS_MAP.get(unit);
                this.out.write(Double.toString(distInMeters));
                this.out.write(", 'meter'");
            } else {
                this.out.write(Double.toString(filter.getDistance()));
                this.out.write(", '");
                this.out.write(filter.getDistanceUnits());
                this.out.write("'");
            }
            this.out.write(")");
            if (filter instanceof DWithin != swapped) {
                this.out.write(" = 1");
            } else {
                this.out.write(" = 0");
            }
            return extraData;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object visitBBOXSpatialOperator(BBOX filter, PropertyName property, Literal geometry, Object extraData) {
        try {
            property.accept((ExpressionVisitor)this, extraData);
            if (this.hanaVersion.getVersion() > 1) {
                BoundingBox bbox = this.clamp(filter.getBounds(), 0.0);
                this.writeIntersectsRectArguments("ST_IntersectsRectPlanar", bbox);
            } else {
                CoordinateReferenceSystem hcrs = this.getHorizontalCRS(filter.getBounds());
                if (hcrs instanceof GeographicCRS && this.currentSRID != null && this.currentSRID <= 1000000000) {
                    this.currentSRID = this.currentSRID + 1000000000;
                    try {
                        String function = "ST_SRID(" + Integer.toString(this.currentSRID) + ").ST_IntersectsRect";
                        BoundingBox bbox = this.clamp(filter.getBounds(), 0.5);
                        this.writeIntersectsRectArguments(function, bbox);
                    }
                    finally {
                        this.currentSRID = this.currentSRID - 1000000000;
                    }
                } else {
                    BoundingBox bbox = filter.getBounds();
                    this.writeIntersectsRectArguments("ST_IntersectsRect", bbox);
                }
            }
            if (filter instanceof BBOX3D) {
                BBOX3D filter3d = (BBOX3D)filter;
                BoundingBox3D bbox3d = filter3d.getBounds();
                double minz = bbox3d.getMinZ();
                double maxz = bbox3d.getMaxZ();
                this.out.write(" AND ");
                property.accept((ExpressionVisitor)this, extraData);
                this.out.write(".ST_ZMin() <= ");
                this.out.write(Double.toString(maxz));
                this.out.write(" AND ");
                property.accept((ExpressionVisitor)this, extraData);
                this.out.write(".ST_ZMax() >= ");
                this.out.write(Double.toString(minz));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return extraData;
    }

    private CoordinateReferenceSystem getHorizontalCRS(BoundingBox bbox) {
        CoordinateReferenceSystem crs = bbox.getCoordinateReferenceSystem();
        SingleCRS hcrs = null;
        if (crs != null) {
            hcrs = CRS.getHorizontalCRS((CoordinateReferenceSystem)crs);
        }
        return hcrs;
    }

    private void writeIntersectsRectArguments(String function, BoundingBox bbox) throws IOException {
        this.out.write(46);
        this.out.write(function);
        this.out.write("(");
        Coordinate ll = new Coordinate(bbox.getMinX(), bbox.getMinY());
        Coordinate ur = new Coordinate(bbox.getMaxX(), bbox.getMaxY());
        GeometryFactory factory = new GeometryFactory();
        this.visitGeometry((Geometry)factory.createPoint(ll));
        this.out.write(", ");
        this.visitGeometry((Geometry)factory.createPoint(ur));
        this.out.write(") = 1");
    }

    private BoundingBox clamp(BoundingBox bounds, double allowedExcessFactor) {
        CoordinateReferenceSystem crs = bounds.getCoordinateReferenceSystem();
        if (crs == null) {
            return bounds;
        }
        SingleCRS hcrs = CRS.getHorizontalCRS((CoordinateReferenceSystem)crs);
        if (!(hcrs instanceof GeographicCRS)) {
            return bounds;
        }
        GeographicCRS gcrs = (GeographicCRS)hcrs;
        Unit u1 = gcrs.getCoordinateSystem().getAxis(0).getUnit();
        Unit su1 = u1.getSystemUnit();
        UnitConverter uc1 = su1.getConverterTo(u1);
        double minx = uc1.convert(-Math.PI);
        double maxx = uc1.convert(Math.PI);
        double spanx = maxx - minx;
        minx -= allowedExcessFactor * spanx;
        maxx += allowedExcessFactor * spanx;
        Unit u2 = hcrs.getCoordinateSystem().getAxis(1).getUnit();
        Unit su2 = u2.getSystemUnit();
        UnitConverter uc2 = su2.getConverterTo(u2);
        double miny = uc2.convert(-1.5707963267948966);
        double maxy = uc2.convert(1.5707963267948966);
        double spany = maxy - miny;
        double x1 = Math.min(maxx, Math.max(minx, bounds.getMinX()));
        double y1 = Math.min(maxy += allowedExcessFactor * spany, Math.max(miny -= allowedExcessFactor * spany, bounds.getMinY()));
        double x2 = Math.max(minx, Math.min(maxx, bounds.getMaxX()));
        double y2 = Math.max(miny, Math.min(maxy, bounds.getMaxY()));
        return new ReferencedEnvelope(x1, x2, y1, y2, crs);
    }

    private Object visitBinarySpatialOperator(BinarySpatialOperator filter, Expression e1, Expression e2, boolean swapped, Object extraData) {
        try {
            e1.accept((ExpressionVisitor)this, extraData);
            this.out.write(46);
            if (filter instanceof Equals) {
                this.out.write("ST_Equals");
            } else if (filter instanceof Disjoint) {
                this.out.write("ST_Disjoint");
            } else if (filter instanceof Intersects) {
                this.out.write("ST_Intersects");
            } else if (filter instanceof Crosses) {
                this.out.write("ST_Crosses");
            } else if (filter instanceof Within) {
                if (swapped) {
                    this.out.write("ST_Contains");
                } else {
                    this.out.write("ST_Within");
                }
            } else if (filter instanceof Contains) {
                if (swapped) {
                    this.out.write("ST_Within");
                } else {
                    this.out.write("ST_Contains");
                }
            } else if (filter instanceof Overlaps) {
                this.out.write("ST_Overlaps");
            } else if (filter instanceof Touches) {
                this.out.write("ST_Touches");
            } else {
                throw new IllegalArgumentException("Unsupported filter type " + filter.getClass());
            }
            this.out.write(40);
            e2.accept((ExpressionVisitor)this, extraData);
            this.out.write(") = 1");
            return extraData;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void visitGeometry(Geometry geom) throws IOException {
        byte[] wkb;
        if (geom == null) {
            this.out.write("NULL");
            return;
        }
        int dimension = HanaDimensionFinder.findDimension(geom);
        try {
            wkb = HanaWKBWriter.write(geom, dimension);
        }
        catch (HanaWKBWriterException e) {
            throw new IOException(e);
        }
        this.out.write("ST_GeomFromWKB('");
        this.out.write(this.encodeAsHex(wkb));
        if (this.currentSRID == null && this.currentGeometry != null) {
            this.out.write("', ");
            this.out.write(HanaUtil.encodeIdentifier(this.currentGeometry.getLocalName()));
            this.out.write(".ST_SRID())");
        } else {
            this.out.write("', " + this.currentSRID + ")");
        }
    }

    private char[] encodeAsHex(byte[] data) {
        int l = data.length;
        char[] ret = new char[2 * l];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            ret[j++] = HEXDIGITS[(0xF0 & data[i]) >>> 4];
            ret[j++] = HEXDIGITS[0xF & data[i]];
        }
        return ret;
    }

    public Object visit(Function function, Object extraData) throws RuntimeException {
        this.encodingFunction = true;
        try {
            boolean encoded = this.visitFunction(function, extraData);
            if (encoded) {
                Object object = extraData;
                return object;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.encodingFunction = false;
        }
        return super.visit(function, extraData);
    }

    private boolean visitFunction(Function function, Object extraData) throws IOException {
        if (function instanceof FilterFunction_strConcat) {
            Expression s1 = this.getParameter(function, 0, true);
            Expression s2 = this.getParameter(function, 1, true);
            this.out.write("(");
            s1.accept((ExpressionVisitor)this, String.class);
            this.out.write(" || ");
            s2.accept((ExpressionVisitor)this, String.class);
            this.out.write(")");
            return true;
        }
        if (function instanceof FilterFunction_strEndsWith) {
            Expression str = this.getParameter(function, 0, true);
            Expression end = this.getParameter(function, 1, true);
            this.out.write("CASE WHEN (RIGHT(");
            str.accept((ExpressionVisitor)this, String.class);
            this.out.write(", LENGTH(");
            end.accept((ExpressionVisitor)this, String.class);
            this.out.write(")) = ");
            end.accept((ExpressionVisitor)this, String.class);
            this.out.write(") THEN 1 ELSE 0 END");
            return true;
        }
        if (function instanceof FilterFunction_strStartsWith) {
            Expression str = this.getParameter(function, 0, true);
            Expression start = this.getParameter(function, 1, true);
            this.out.write("CASE WHEN (LEFT(");
            str.accept((ExpressionVisitor)this, String.class);
            this.out.write(", LENGTH(");
            start.accept((ExpressionVisitor)this, String.class);
            this.out.write(")) = ");
            start.accept((ExpressionVisitor)this, String.class);
            this.out.write(") THEN 1 ELSE 0 END");
            return true;
        }
        if (function instanceof FilterFunction_strEqualsIgnoreCase) {
            Expression first = this.getParameter(function, 0, true);
            Expression second = this.getParameter(function, 1, true);
            this.out.write("CASE WHEN (LOWER(");
            first.accept((ExpressionVisitor)this, String.class);
            this.out.write(") = LOWER(");
            second.accept((ExpressionVisitor)this, String.class);
            this.out.write(")) THEN 1 ELSE 0 END");
            return true;
        }
        if (function instanceof FilterFunction_strIndexOf) {
            Expression string = this.getParameter(function, 0, true);
            Expression substr = this.getParameter(function, 1, true);
            this.out.write("(LOCATE(");
            string.accept((ExpressionVisitor)this, String.class);
            this.out.write(", ");
            substr.accept((ExpressionVisitor)this, String.class);
            this.out.write(") - 1)");
            return true;
        }
        if (function instanceof FilterFunction_strLength) {
            Expression string = this.getParameter(function, 0, true);
            this.out.write("LENGTH(");
            string.accept((ExpressionVisitor)this, String.class);
            this.out.write(")");
            return true;
        }
        if (function instanceof FilterFunction_strToLowerCase) {
            Expression string = this.getParameter(function, 0, true);
            this.out.write("LOWER(");
            string.accept((ExpressionVisitor)this, String.class);
            this.out.write(")");
            return true;
        }
        if (function instanceof FilterFunction_strToUpperCase) {
            Expression string = this.getParameter(function, 0, true);
            this.out.write("UPPER(");
            string.accept((ExpressionVisitor)this, String.class);
            this.out.write(")");
            return true;
        }
        if (function instanceof FilterFunction_strSubstring) {
            Expression string = this.getParameter(function, 0, true);
            Expression begIdx = this.getParameter(function, 1, true);
            Expression endIdx = this.getParameter(function, 2, true);
            this.out.write("SUBSTRING(");
            string.accept((ExpressionVisitor)this, String.class);
            this.out.write(", ");
            begIdx.accept((ExpressionVisitor)this, Integer.class);
            this.out.write(" + 1, (");
            endIdx.accept((ExpressionVisitor)this, Integer.class);
            this.out.write(") - (");
            begIdx.accept((ExpressionVisitor)this, Integer.class);
            this.out.write("))");
            return true;
        }
        if (function instanceof FilterFunction_strSubstringStart) {
            Expression string = this.getParameter(function, 0, true);
            Expression begIdx = this.getParameter(function, 1, true);
            this.out.write("SUBSTRING(");
            string.accept((ExpressionVisitor)this, String.class);
            this.out.write(", ");
            begIdx.accept((ExpressionVisitor)this, Integer.class);
            this.out.write(" + 1)");
            return true;
        }
        if (function instanceof FilterFunction_strTrim) {
            Expression string = this.getParameter(function, 0, true);
            this.out.write("TRIM(' ' || CHAR(9) || CHAR(10) || CHAR(13) FROM (");
            string.accept((ExpressionVisitor)this, String.class);
            this.out.write("))");
            return true;
        }
        if (function instanceof FilterFunction_abs || function instanceof FilterFunction_abs_2 || function instanceof FilterFunction_abs_3 || function instanceof FilterFunction_abs_4) {
            Expression string = this.getParameter(function, 0, true);
            this.out.write("CAST (");
            this.out.write("ABS(");
            string.accept((ExpressionVisitor)this, String.class);
            this.out.write(")");
            this.out.write(" AS ");
            String dataType = null;
            if (function instanceof FilterFunction_abs) {
                dataType = "SMALLINT";
            }
            if (function instanceof FilterFunction_abs_2) {
                dataType = "INT";
            }
            if (function instanceof FilterFunction_abs_3) {
                dataType = "FLOAT";
            }
            if (function instanceof FilterFunction_abs_4) {
                dataType = "DOUBLE";
            }
            this.out.write(dataType);
            this.out.write(")");
            return true;
        }
        if (function instanceof FilterFunction_ceil) {
            Expression number = this.getParameter(function, 0, true);
            this.out.write("CEIL(");
            number.accept((ExpressionVisitor)this, Number.class);
            this.out.write(")");
            return true;
        }
        if (function instanceof FilterFunction_floor) {
            Expression number = this.getParameter(function, 0, true);
            this.out.write("FLOOR(");
            number.accept((ExpressionVisitor)this, Number.class);
            this.out.write(")");
            return true;
        }
        return false;
    }

    static {
        UNITS_MAP.put("kilometers", 1000.0);
        UNITS_MAP.put("kilometer", 1000.0);
        UNITS_MAP.put("km", 1000.0);
        UNITS_MAP.put("meters", 1.0);
        UNITS_MAP.put("meter", 1.0);
        UNITS_MAP.put("m", 1.0);
        UNITS_MAP.put("millimeter", 0.001);
        UNITS_MAP.put("mm", 0.001);
        UNITS_MAP.put("statute miles", 1609.344);
        UNITS_MAP.put("miles", 1609.344);
        UNITS_MAP.put("mile", 1609.344);
        UNITS_MAP.put("mi", 1609.344);
        UNITS_MAP.put("nautical miles", 1852.0);
        UNITS_MAP.put("NM", 1852.0);
        UNITS_MAP.put("nm", 1852.0);
        UNITS_MAP.put("feet", 0.3048);
        UNITS_MAP.put("ft", 0.3048);
        UNITS_MAP.put("in", 0.0254);
        HEXDIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    }
}

