/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.hana.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.geotools.data.hana.metadata.CsvReader;
import org.geotools.data.hana.metadata.Srs;

class SrsReader {
    private CsvReader csvReader;

    public SrsReader(InputStream is) {
        this.csvReader = new CsvReader(is);
    }

    public Srs readNextSrs() throws IOException {
        Srs.Type type;
        List<String> entries = this.csvReader.readNextRow();
        if (entries == null) {
            return null;
        }
        if (entries.size() != 16) {
            throw new RuntimeException("SRS-CSV is malformed");
        }
        String name = entries.get(0);
        int srid = Integer.parseInt(entries.get(1));
        String organization = entries.get(2);
        int organizationId = Integer.parseInt(entries.get(3));
        String wkt = entries.get(4);
        String proj4 = entries.get(5);
        String linearUom = entries.get(6);
        String angularUom = entries.get(7);
        String stype = entries.get(8);
        if ("projected".equals(stype)) {
            type = Srs.Type.PROJECTED;
        } else if ("geographic".equals(stype)) {
            type = Srs.Type.GEOGRAPHIC;
        } else if ("flat".equals(stype)) {
            type = Srs.Type.FLAT;
        } else {
            throw new RuntimeException("SRS-CSV is malformed");
        }
        Double majorAxis = "null".equals(entries.get(9)) ? null : Double.valueOf(Double.parseDouble(entries.get(9)));
        Double minorAxis = "null".equals(entries.get(10)) ? null : Double.valueOf(Double.parseDouble(entries.get(10)));
        Double invFlattening = "null".equals(entries.get(11)) ? null : Double.valueOf(Double.parseDouble(entries.get(11)));
        double minx = Double.parseDouble(entries.get(12));
        double maxx = Double.parseDouble(entries.get(13));
        double miny = Double.parseDouble(entries.get(14));
        double maxy = Double.parseDouble(entries.get(15));
        return new Srs(name, srid, organization, organizationId, wkt, proj4, linearUom, angularUom, type, majorAxis, minorAxis, invFlattening, minx, maxx, miny, maxy);
    }
}

