/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.hana.wkb;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.MessageFormat;
import org.geotools.data.hana.wkb.GeometryType;
import org.geotools.data.hana.wkb.HanaWKBWriterException;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class HanaWKBWriter {
    private static final int HEADER_SIZE = 5;
    private static final int COUNT_SIZE = 4;
    private static final int COORD_SIZE = 8;
    private static final byte NDR = 1;
    private static final int DIM_OFFSET = 1000;

    public static byte[] write(Geometry geometry, int dimension) throws HanaWKBWriterException {
        if (geometry == null) {
            return null;
        }
        int size = HanaWKBWriter.computeSize(geometry, dimension);
        ByteBuffer buffer = ByteBuffer.allocate(size);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        HanaWKBWriter.write(geometry, dimension, buffer);
        return buffer.array();
    }

    private static int computeSize(Geometry geometry, int dimension) throws HanaWKBWriterException {
        if (geometry instanceof Point) {
            return HanaWKBWriter.computeSize((Point)geometry, dimension);
        }
        if (geometry instanceof LineString) {
            return HanaWKBWriter.computeSize((LineString)geometry, dimension);
        }
        if (geometry instanceof Polygon) {
            return HanaWKBWriter.computeSize((Polygon)geometry, dimension);
        }
        if (geometry instanceof MultiPoint) {
            return HanaWKBWriter.computeSize((MultiPoint)geometry, dimension);
        }
        if (geometry instanceof MultiLineString) {
            return HanaWKBWriter.computeSize((MultiLineString)geometry, dimension);
        }
        if (geometry instanceof MultiPolygon) {
            return HanaWKBWriter.computeSize((MultiPolygon)geometry, dimension);
        }
        if (geometry instanceof GeometryCollection) {
            return HanaWKBWriter.computeSize((GeometryCollection)geometry, dimension);
        }
        throw new HanaWKBWriterException(MessageFormat.format("Unsupported geometry type {0}", geometry.getGeometryType()));
    }

    private static int computeSize(Point point, int dimension) {
        return 5 + dimension * 8;
    }

    private static int computeSize(LineString lineString, int dimension) {
        return 9 + lineString.getNumPoints() * dimension * 8;
    }

    private static int computeSize(Polygon polygon, int dimension) {
        int size = 9;
        LinearRing shell = polygon.getExteriorRing();
        if (shell == null || shell.getNumPoints() == 0) {
            return size;
        }
        int pointSize = dimension * 8;
        size += 4 + shell.getNumPoints() * pointSize;
        int numHoles = polygon.getNumInteriorRing();
        for (int i = 0; i < numHoles; ++i) {
            size += 4 + polygon.getInteriorRingN(i).getNumPoints() * pointSize;
        }
        return size;
    }

    private static int computeSize(MultiPoint multiPoint, int dimension) {
        return 9 + multiPoint.getNumPoints() * (5 + dimension * 8);
    }

    private static int computeSize(MultiLineString multiLineString, int dimension) {
        int size = 9;
        for (int i = 0; i < multiLineString.getNumGeometries(); ++i) {
            size += HanaWKBWriter.computeSize((LineString)multiLineString.getGeometryN(i), dimension);
        }
        return size;
    }

    private static int computeSize(MultiPolygon multiPolygon, int dimension) {
        int size = 9;
        for (int i = 0; i < multiPolygon.getNumGeometries(); ++i) {
            size += HanaWKBWriter.computeSize((Polygon)multiPolygon.getGeometryN(i), dimension);
        }
        return size;
    }

    private static int computeSize(GeometryCollection geometryCollection, int dimension) throws HanaWKBWriterException {
        int size = 9;
        for (int i = 0; i < geometryCollection.getNumGeometries(); ++i) {
            size += HanaWKBWriter.computeSize(geometryCollection.getGeometryN(i), dimension);
        }
        return size;
    }

    private static void write(Geometry geometry, int dimension, ByteBuffer buffer) throws HanaWKBWriterException {
        if (geometry instanceof Point) {
            HanaWKBWriter.write((Point)geometry, dimension, buffer);
        } else if (geometry instanceof LineString) {
            HanaWKBWriter.write((LineString)geometry, dimension, buffer);
        } else if (geometry instanceof Polygon) {
            HanaWKBWriter.write((Polygon)geometry, dimension, buffer);
        } else if (geometry instanceof MultiPoint) {
            HanaWKBWriter.write((MultiPoint)geometry, dimension, buffer);
        } else if (geometry instanceof MultiLineString) {
            HanaWKBWriter.write((MultiLineString)geometry, dimension, buffer);
        } else if (geometry instanceof MultiPolygon) {
            HanaWKBWriter.write((MultiPolygon)geometry, dimension, buffer);
        } else if (geometry instanceof GeometryCollection) {
            HanaWKBWriter.write((GeometryCollection)geometry, dimension, buffer);
        } else {
            throw new HanaWKBWriterException(MessageFormat.format("Unsupported geometry type {0}", geometry.getGeometryType()));
        }
    }

    private static void write(Point point, int dimension, ByteBuffer buffer) {
        HanaWKBWriter.writeHeader(GeometryType.POINT, dimension, buffer);
        Coordinate coord = point.getCoordinate();
        if (coord != null) {
            buffer.putDouble(coord.x);
            buffer.putDouble(coord.y);
            if (dimension >= 3) {
                buffer.putDouble(coord.getZ());
            }
        } else {
            for (int i = 0; i < dimension; ++i) {
                buffer.putDouble(Double.NaN);
            }
        }
    }

    private static void write(LineString lineString, int dimension, ByteBuffer buffer) {
        HanaWKBWriter.writeHeader(GeometryType.LINESTRING, dimension, buffer);
        HanaWKBWriter.write(lineString.getCoordinateSequence(), dimension, buffer);
    }

    private static void write(Polygon polygon, int dimension, ByteBuffer buffer) {
        HanaWKBWriter.writeHeader(GeometryType.POLYGON, dimension, buffer);
        LinearRing shell = polygon.getExteriorRing();
        if (shell == null || shell.getNumPoints() == 0) {
            buffer.putInt(0);
            return;
        }
        int numHoles = polygon.getNumInteriorRing();
        buffer.putInt(1 + numHoles);
        HanaWKBWriter.write(shell.getCoordinateSequence(), dimension, buffer);
        for (int i = 0; i < numHoles; ++i) {
            LinearRing hole = polygon.getInteriorRingN(i);
            HanaWKBWriter.write(hole.getCoordinateSequence(), dimension, buffer);
        }
    }

    private static void write(MultiPoint multiPoint, int dimension, ByteBuffer buffer) {
        HanaWKBWriter.writeHeader(GeometryType.MULTIPOINT, dimension, buffer);
        int numPoints = multiPoint.getNumPoints();
        buffer.putInt(numPoints);
        for (int i = 0; i < numPoints; ++i) {
            HanaWKBWriter.write((Point)multiPoint.getGeometryN(i), dimension, buffer);
        }
    }

    private static void write(MultiLineString multiLineString, int dimension, ByteBuffer buffer) {
        HanaWKBWriter.writeHeader(GeometryType.MULTILINESTRING, dimension, buffer);
        int numLineStrings = multiLineString.getNumGeometries();
        buffer.putInt(numLineStrings);
        for (int i = 0; i < numLineStrings; ++i) {
            HanaWKBWriter.write((LineString)multiLineString.getGeometryN(i), dimension, buffer);
        }
    }

    private static void write(MultiPolygon multiPolygon, int dimension, ByteBuffer buffer) {
        HanaWKBWriter.writeHeader(GeometryType.MULTIPOLYGON, dimension, buffer);
        int numPolygons = multiPolygon.getNumGeometries();
        buffer.putInt(numPolygons);
        for (int i = 0; i < numPolygons; ++i) {
            HanaWKBWriter.write((Polygon)multiPolygon.getGeometryN(i), dimension, buffer);
        }
    }

    private static void write(GeometryCollection geometryCollection, int dimension, ByteBuffer buffer) throws HanaWKBWriterException {
        HanaWKBWriter.writeHeader(GeometryType.GEOMETRYCOLLECTION, dimension, buffer);
        int numGeometries = geometryCollection.getNumGeometries();
        buffer.putInt(numGeometries);
        for (int i = 0; i < numGeometries; ++i) {
            HanaWKBWriter.write(geometryCollection.getGeometryN(i), dimension, buffer);
        }
    }

    private static void write(CoordinateSequence cs, int dimension, ByteBuffer buffer) {
        int numPoints = cs.size();
        buffer.putInt(numPoints);
        for (int i = 0; i < numPoints; ++i) {
            for (int j = 0; j < dimension; ++j) {
                buffer.putDouble(cs.getOrdinate(i, j));
            }
        }
    }

    private static void writeHeader(GeometryType geometryType, int dimension, ByteBuffer buffer) {
        buffer.put((byte)1);
        int typeCode = geometryType.getTypeCode();
        if (dimension == 3) {
            typeCode += 1000;
        }
        buffer.putInt(typeCode);
    }
}

