/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.hana.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.geotools.data.hana.metadata.CsvReader;
import org.geotools.data.hana.metadata.Uom;

class UomReader {
    private CsvReader csvReader;

    public UomReader(InputStream is) {
        this.csvReader = new CsvReader(is);
    }

    public Uom readNextUom() throws IOException {
        Uom.Type type;
        List<String> entries = this.csvReader.readNextRow();
        if (entries == null) {
            return null;
        }
        if (entries.size() != 3) {
            throw new RuntimeException("UOM-CSV is malformed");
        }
        String name = entries.get(0);
        String stype = entries.get(1);
        if ("linear".equals(stype)) {
            type = Uom.Type.LINEAR;
        } else if ("angular".equals(stype)) {
            type = Uom.Type.ANGULAR;
        } else {
            throw new RuntimeException("UOM-CSV is malformed");
        }
        double factor = Double.parseDouble(entries.get(2));
        return new Uom(name, type, factor);
    }
}

