/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.hana;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.geotools.api.data.DataAccessFactory;
import org.geotools.data.hana.HanaConnectionParameters;
import org.geotools.data.hana.HanaDialect;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.JDBCDataStoreFactory;
import org.geotools.jdbc.SQLDialect;

public class HanaDataStoreFactory
extends JDBCDataStoreFactory {
    private static final String DATABASE_ID = "hana";
    public static final DataAccessFactory.Param DBTYPE = new DataAccessFactory.Param("dbtype", String.class, "Type", true, (Object)"hana", Collections.singletonMap("level", "program"));
    public static final DataAccessFactory.Param PORT = new DataAccessFactory.Param("port", Integer.class, "Port to connect to. If omitted, you have to specify an instance.", false);
    public static final DataAccessFactory.Param INSTANCE = new DataAccessFactory.Param("instance", Integer.class, "Instance Number. Leave empty if you have specified a port.", false);
    public static final DataAccessFactory.Param DATABASE = new DataAccessFactory.Param("database", String.class, "Database. Leave empty if you have specified a port or if you want to connect in single database mode. Use SYSTEMDB for the system database. ", false);
    public static final DataAccessFactory.Param USE_SSL = new DataAccessFactory.Param("use ssl", Boolean.class, "Use SSL", false);
    public static final DataAccessFactory.Param ENCODE_FUNCTIONS = new DataAccessFactory.Param("encode functions", Boolean.class, "Set to true to have a set of filter functions be translated directly in SQL. Due to differences in the type systems the result might not be the same as evaluating them in memory, including the SQL failing with errors while the in memory version works fine. However this allows to push more of the filter into the database, increasing performance.", false, (Object)Boolean.FALSE, Collections.singletonMap("level", "advanced"));
    public static final DataAccessFactory.Param DISABLE_SIMPLIFY = new DataAccessFactory.Param("disable simplification", Boolean.class, "Certain operations like map rendering can request geometry simplification from the database. Setting this option to true will prevent geometry simplifcation by the database.", false, (Object)Boolean.FALSE);
    public static final DataAccessFactory.Param SELECT_HINTS = new DataAccessFactory.Param("SELECT Hints", String.class, "Comma-separated list of hints that will be applied to SELECT queries, e.g. ESTIMATION_SAMPLES(0), NO_HASH_JOIN", false, null, Collections.singletonMap("isLargeText", Boolean.TRUE));
    public static final DataAccessFactory.Param ESTIMATED_EXTENTS = new DataAccessFactory.Param("Estimated extents", Boolean.class, "Use cached data to quickly get an estimate of the data bounds", false, (Object)Boolean.FALSE);
    private static final String DESCRIPTION = "SAP HANA";
    private static final String DRIVER_CLASS_NAME = "com.sap.db.jdbc.Driver";

    public String getDescription() {
        return DESCRIPTION;
    }

    protected String getDatabaseID() {
        return DATABASE_ID;
    }

    protected String getDriverClassName() {
        return DRIVER_CLASS_NAME;
    }

    protected SQLDialect createSQLDialect(JDBCDataStore dataStore) {
        return new HanaDialect(dataStore);
    }

    protected String getValidationQuery() {
        return "SELECT 1 FROM DUMMY";
    }

    protected void setupParameters(Map<String, Object> parameters) {
        LinkedHashMap<String, DataAccessFactory.Param> parentParams = new LinkedHashMap<String, DataAccessFactory.Param>();
        super.setupParameters(parentParams);
        parentParams.put(HanaDataStoreFactory.DBTYPE.key, DBTYPE);
        parentParams.put(HanaDataStoreFactory.PORT.key, PORT);
        parentParams.put(HanaDataStoreFactory.DATABASE.key, DATABASE);
        for (Map.Entry param : parentParams.entrySet()) {
            parameters.put((String)param.getKey(), param.getValue());
            if (HanaDataStoreFactory.PORT.key.equals(param.getKey())) {
                parameters.put(HanaDataStoreFactory.INSTANCE.key, INSTANCE);
            }
            if (HanaDataStoreFactory.DATABASE.key.equals(param.getKey())) {
                parameters.put(HanaDataStoreFactory.USE_SSL.key, USE_SSL);
            }
            if (!HanaDataStoreFactory.EXPOSE_PK.key.equals(param.getKey())) continue;
            parameters.put(HanaDataStoreFactory.ENCODE_FUNCTIONS.key, ENCODE_FUNCTIONS);
            parameters.put(HanaDataStoreFactory.DISABLE_SIMPLIFY.key, DISABLE_SIMPLIFY);
            parameters.put(HanaDataStoreFactory.ESTIMATED_EXTENTS.key, ESTIMATED_EXTENTS);
            parameters.put(HanaDataStoreFactory.SELECT_HINTS.key, SELECT_HINTS);
        }
    }

    protected String getJDBCUrl(Map<String, ?> params) throws IOException {
        String host = (String)HOST.lookUp(params);
        Integer port = (Integer)PORT.lookUp(params);
        Integer instance = (Integer)INSTANCE.lookUp(params);
        String database = (String)DATABASE.lookUp(params);
        Boolean useSsl = (Boolean)USE_SSL.lookUp(params);
        HashMap<String, String> options = new HashMap<String, String>();
        if (useSsl != null && useSsl.booleanValue()) {
            options.put("encrypt", "true");
        }
        if (port != null && port != 0) {
            return HanaConnectionParameters.forPort(host, port, options).buildUrl();
        }
        if (instance == null) {
            throw new IOException("Either a port or an instance number must be given in the connection properties");
        }
        if (database != null && !database.isEmpty()) {
            return HanaConnectionParameters.forMultiContainer(host, instance, database, options).buildUrl();
        }
        return HanaConnectionParameters.forSingleContainer(host, instance, options).buildUrl();
    }

    protected JDBCDataStore createDataStoreInternal(JDBCDataStore dataStore, Map<String, ?> params) throws IOException {
        HanaDialect dialect = (HanaDialect)dataStore.getSQLDialect();
        Boolean encodeFunctions = (Boolean)ENCODE_FUNCTIONS.lookUp(params);
        dialect.setFunctionEncodingEnabled(encodeFunctions != null && encodeFunctions != false);
        Boolean disableSimplify = (Boolean)DISABLE_SIMPLIFY.lookUp(params);
        dialect.setSimplifyDisabled(disableSimplify != null && disableSimplify != false);
        String selectHints = (String)SELECT_HINTS.lookUp(params);
        dialect.setSelectHints(selectHints);
        Boolean estimated = (Boolean)ESTIMATED_EXTENTS.lookUp(params);
        dialect.setEstimatedExtentsEnabled(estimated != null && estimated != false);
        return dataStore;
    }
}

