/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.hana;

import java.util.Objects;

class HanaCloudVersion
implements Comparable<HanaCloudVersion> {
    public static final HanaCloudVersion INVALID_VERSION = new HanaCloudVersion(0, 0, 0);
    private int year;
    private int week;
    private int patch;

    public HanaCloudVersion(String versionString) {
        String[] components = versionString.replace('-', '.').split("\\.");
        if (components.length < 3) {
            throw new IllegalArgumentException("Invalid HANA Cloud version string " + versionString);
        }
        try {
            this.year = Integer.parseInt(components[0]);
            this.week = Integer.parseInt(components[1]);
            this.patch = Integer.parseInt(components[2]);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid HANA Cloud version string " + versionString);
        }
    }

    public HanaCloudVersion(int year, int week, int patch) {
        this.year = year;
        this.week = week;
        this.patch = patch;
    }

    public int getYear() {
        return this.year;
    }

    public int getWeek() {
        return this.week;
    }

    public int getPatch() {
        return this.patch;
    }

    @Override
    public int compareTo(HanaCloudVersion that) {
        if (that == null) {
            throw new NullPointerException();
        }
        if (this.year != that.year) {
            return Integer.compare(this.year, that.year);
        }
        if (this.week != that.week) {
            return Integer.compare(this.week, that.week);
        }
        if (this.patch != that.patch) {
            return Integer.compare(this.patch, that.patch);
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HanaCloudVersion that = (HanaCloudVersion)o;
        return this.year == that.year && this.week == that.week && this.patch == that.patch;
    }

    public int hashCode() {
        return Objects.hash(this.year, this.week, this.patch);
    }
}

