/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.hana;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.geotools.api.data.Query;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.crs.GeographicCRS;
import org.geotools.api.referencing.crs.SingleCRS;
import org.geotools.data.hana.HanaCloudVersion;
import org.geotools.data.hana.HanaDimensionFinder;
import org.geotools.data.hana.HanaFilterToSQL;
import org.geotools.data.hana.HanaUtil;
import org.geotools.data.hana.HanaVersion;
import org.geotools.data.hana.wkb.HanaWKBParser;
import org.geotools.data.hana.wkb.HanaWKBParserException;
import org.geotools.data.hana.wkb.HanaWKBWriter;
import org.geotools.data.hana.wkb.HanaWKBWriterException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.PreparedFilterToSQL;
import org.geotools.jdbc.PreparedStatementSQLDialect;
import org.geotools.referencing.CRS;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class HanaDialect
extends PreparedStatementSQLDialect {
    private static final String HANA_UUID = "8E468249703240F0ACDE78162124A62F";
    private static final String SEQUENCE_SUFFIX = "_SEQ_8E468249703240F0ACDE78162124A62F";
    private static final String METADATA_TABLE_NAME = "METADATA_8E468249703240F0ACDE78162124A62F";
    private static final Map<String, Class<?>> TYPE_NAME_TO_CLASS = new HashMap();
    private static final int GEOMETRY_TYPE_CODE = 29812;
    private static final Map<Integer, Class<?>> SQL_TYPE_TO_CLASS;
    private static final Map<Class<?>, Integer> CLASS_TO_SQL_TYPE;
    private static final Map<Integer, String> SQL_TYPE_TO_SQL_TYPE_NAME;
    private static final String GEOMETRY_TYPE_NAME = "ST_Geometry";
    private boolean functionEncodingEnabled;
    private boolean simplifyDisabled;
    private String selectHints;
    private HanaVersion hanaVersion;
    private HanaCloudVersion cloudVersion;
    private SchemaCache currentSchemaCache = new SchemaCache();
    private boolean estimatedExtentsEnabled = false;

    public HanaDialect(JDBCDataStore dataStore) {
        super(dataStore);
    }

    public boolean isEstimatedExtentsEnabled() {
        return this.estimatedExtentsEnabled;
    }

    public void setEstimatedExtentsEnabled(boolean estimatedExtentsEnabled) {
        this.estimatedExtentsEnabled = estimatedExtentsEnabled;
    }

    public void setFunctionEncodingEnabled(boolean enabled) {
        this.functionEncodingEnabled = enabled;
    }

    public void setSimplifyDisabled(boolean disabled) {
        this.simplifyDisabled = disabled;
    }

    public void setSelectHints(String selectHints) {
        this.selectHints = selectHints;
    }

    public void initializeConnection(Connection cx) throws SQLException {
        super.initializeConnection(cx);
        if (this.hanaVersion == null) {
            this.hanaVersion = new HanaVersion(cx.getMetaData().getDatabaseProductVersion());
            if (this.hanaVersion.getVersion() == 1 && this.hanaVersion.getRevision() < 120) {
                throw new SQLException("Only HANA 2 and HANA 1 SPS 12 and later are supported");
            }
            this.cloudVersion = this.queryCloudVersion(cx);
        }
    }

    public boolean includeTable(String schemaName, String tableName, Connection cx) throws SQLException {
        if (METADATA_TABLE_NAME.equals(tableName)) {
            return false;
        }
        if (this.dataStore.getDatabaseSchema() != null) {
            return true;
        }
        String currentSchema = this.currentSchemaCache.getSchema(cx);
        return currentSchema.equals(schemaName);
    }

    public void registerSqlTypeNameToClassMappings(Map<String, Class<?>> mappings) {
        super.registerSqlTypeNameToClassMappings(mappings);
        mappings.putAll(TYPE_NAME_TO_CLASS);
    }

    public void registerSqlTypeToClassMappings(Map<Integer, Class<?>> mappings) {
        super.registerSqlTypeToClassMappings(mappings);
        mappings.putAll(SQL_TYPE_TO_CLASS);
    }

    public void registerClassToSqlMappings(Map<Class<?>, Integer> mappings) {
        super.registerClassToSqlMappings(mappings);
        mappings.putAll(CLASS_TO_SQL_TYPE);
    }

    public void registerSqlTypeToSqlTypeNameOverrides(Map<Integer, String> overrides) {
        super.registerSqlTypeToSqlTypeNameOverrides(overrides);
        overrides.putAll(SQL_TYPE_TO_SQL_TYPE_NAME);
    }

    public String getGeometryTypeName(Integer type) {
        return GEOMETRY_TYPE_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer getGeometrySRIDFromView(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        int srid;
        ResultSet rs;
        PreparedStatement ps;
        block9: {
            block8: {
                block7: {
                    Integer n;
                    ps = null;
                    rs = null;
                    try {
                        if (schemaName != null) {
                            ps = cx.prepareStatement("SELECT SRS_ID FROM PUBLIC.ST_GEOMETRY_COLUMNS WHERE SCHEMA_NAME = ? AND TABLE_NAME = ? AND COLUMN_NAME = ?");
                            ps.setString(1, schemaName);
                            ps.setString(2, tableName);
                            ps.setString(3, columnName);
                        } else {
                            ps = cx.prepareStatement("SELECT SRS_ID FROM PUBLIC.ST_GEOMETRY_COLUMNS WHERE SCHEMA_NAME = CURRENT_SCHEMA AND TABLE_NAME = ? AND COLUMN_NAME = ?");
                            ps.setString(1, tableName);
                            ps.setString(2, columnName);
                        }
                        rs = ps.executeQuery();
                        if (rs.next()) break block7;
                        n = null;
                    }
                    catch (Throwable throwable) {
                        this.dataStore.closeSafe(rs);
                        this.dataStore.closeSafe((Statement)ps);
                        throw throwable;
                    }
                    this.dataStore.closeSafe(rs);
                    this.dataStore.closeSafe((Statement)ps);
                    return n;
                }
                srid = rs.getInt(1);
                if (!rs.wasNull()) break block8;
                Integer n = null;
                this.dataStore.closeSafe(rs);
                this.dataStore.closeSafe((Statement)ps);
                return n;
            }
            if (!rs.next()) break block9;
            Integer n = null;
            this.dataStore.closeSafe(rs);
            this.dataStore.closeSafe((Statement)ps);
            return n;
        }
        Integer n = srid;
        this.dataStore.closeSafe(rs);
        this.dataStore.closeSafe((Statement)ps);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer getGeometrySRIDViaSelect(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        ResultSet rs;
        PreparedStatement ps;
        block3: {
            Integer n;
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT ");
            this.encodeIdentifiers(sql, columnName);
            sql.append(".ST_SRID() FROM ");
            this.encodeIdentifiers(sql, schemaName, tableName);
            sql.append(" WHERE ");
            this.encodeIdentifiers(sql, columnName);
            sql.append(" IS NOT NULL LIMIT 1");
            ps = null;
            rs = null;
            try {
                ps = cx.prepareStatement(sql.toString());
                rs = ps.executeQuery();
                if (!rs.next()) break block3;
                n = rs.getInt(1);
            }
            catch (Throwable throwable) {
                this.dataStore.closeSafe(rs);
                this.dataStore.closeSafe((Statement)ps);
                throw throwable;
            }
            this.dataStore.closeSafe(rs);
            this.dataStore.closeSafe((Statement)ps);
            return n;
        }
        Integer n = null;
        this.dataStore.closeSafe(rs);
        this.dataStore.closeSafe((Statement)ps);
        return n;
    }

    public Integer getGeometrySRID(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        Integer srid = this.getGeometrySRIDFromView(schemaName, tableName, columnName, cx);
        if (srid == null) {
            srid = this.getGeometrySRIDViaSelect(schemaName, tableName, columnName, cx);
        }
        return srid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getGeometryDimension(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        ResultSet rs;
        PreparedStatement ps;
        StringBuffer sql;
        if (this.tableExists(schemaName, METADATA_TABLE_NAME, cx)) {
            block7: {
                int n;
                sql = new StringBuffer();
                sql.append("SELECT DIMENSION FROM ");
                this.encodeIdentifiers(sql, schemaName, METADATA_TABLE_NAME);
                sql.append(" WHERE TABLE_NAME = ? AND COLUMN_NAME = ?");
                ps = null;
                rs = null;
                try {
                    ps = cx.prepareStatement(sql.toString());
                    ps.setString(1, tableName);
                    ps.setString(2, columnName);
                    rs = ps.executeQuery();
                    if (!rs.next()) break block7;
                    n = rs.getInt(1);
                }
                catch (Throwable throwable) {
                    this.dataStore.closeSafe(rs);
                    this.dataStore.closeSafe((Statement)ps);
                    throw throwable;
                }
                this.dataStore.closeSafe(rs);
                this.dataStore.closeSafe((Statement)ps);
                return n;
            }
            this.dataStore.closeSafe(rs);
            this.dataStore.closeSafe((Statement)ps);
        }
        sql = new StringBuffer();
        sql.append("SELECT ");
        this.encodeIdentifiers(sql, columnName);
        sql.append(".ST_CoordDim() FROM ");
        this.encodeIdentifiers(sql, schemaName, tableName);
        sql.append(" WHERE ");
        this.encodeIdentifiers(sql, columnName);
        sql.append(" IS NOT NULL LIMIT 1");
        ps = null;
        rs = null;
        try {
            ps = cx.prepareStatement(sql.toString());
            rs = ps.executeQuery();
            if (rs.next()) {
                int n = rs.getInt(1);
                return n;
            }
        }
        finally {
            this.dataStore.closeSafe(rs);
            this.dataStore.closeSafe((Statement)ps);
        }
        return 2;
    }

    /*
     * Exception decompiling
     */
    public CoordinateReferenceSystem createCRS(int srid, Connection cx) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<ReferencedEnvelope> getOptimizedBounds(String schema, SimpleFeatureType featureType, Connection cx) throws SQLException, IOException {
        ResultSet rs;
        PreparedStatement ps;
        ArrayList<ReferencedEnvelope> result;
        block13: {
            List<ReferencedEnvelope> list;
            block12: {
                if (!this.isEstimatedExtentsEnabled()) {
                    return super.getOptimizedBounds(schema, featureType, cx);
                }
                if (!this.isExtentEstimationAvailable()) {
                    LOGGER.log(Level.WARNING, "Could not use fast extent estimation. This feature is available starting with HANA Cloud QRC1/2024 and HANA 2 SPS 08.");
                    return null;
                }
                String tableName = featureType.getTypeName();
                if (this.dataStore.getVirtualTables().get(tableName) != null) {
                    return null;
                }
                result = new ArrayList<ReferencedEnvelope>();
                ps = null;
                rs = null;
                schema = this.resolveSchema(schema, cx);
                try {
                    for (AttributeDescriptor att : featureType.getAttributeDescriptors()) {
                        if (!(att instanceof GeometryDescriptor)) continue;
                        StringBuffer sql = new StringBuffer();
                        sql.append("SELECT MIN_X, MAX_X, MIN_Y, MAX_Y FROM SYS.M_ST_GEOMETRY_COLUMNS WHERE SCHEMA_NAME=? AND TABLE_NAME=? AND COLUMN_NAME=?");
                        ps = cx.prepareStatement(sql.toString());
                        ps.setString(1, schema);
                        ps.setString(2, tableName);
                        ps.setString(3, att.getName().getLocalPart());
                        rs = ps.executeQuery();
                        if (rs.next()) {
                            double xMin = rs.getDouble(1);
                            double xMax = rs.getDouble(2);
                            double yMin = rs.getDouble(3);
                            double yMax = rs.getDouble(4);
                            if (rs.wasNull()) {
                                list = null;
                                this.dataStore.closeSafe(rs);
                                break block12;
                            }
                            result.add(new ReferencedEnvelope(xMin, xMax, yMin, yMax, (CoordinateReferenceSystem)CRS.getHorizontalCRS((CoordinateReferenceSystem)featureType.getCoordinateReferenceSystem())));
                        }
                        rs.close();
                        ps.close();
                    }
                    this.dataStore.closeSafe(rs);
                    break block13;
                }
                catch (SQLException e) {
                    LOGGER.log(Level.WARNING, "Fast Extent Estimation failed!", e);
                    List<ReferencedEnvelope> list2 = null;
                    return list2;
                }
            }
            this.dataStore.closeSafe((Statement)ps);
            return list;
        }
        this.dataStore.closeSafe(ps);
        if (!result.isEmpty()) return result;
        return null;
        finally {
            this.dataStore.closeSafe(rs);
            this.dataStore.closeSafe(ps);
        }
    }

    public void encodeGeometryEnvelope(String tableName, String geometryColumn, StringBuffer sql) {
        sql.append("MIN(");
        this.encodeIdentifiers(sql, geometryColumn);
        sql.append(".ST_XMin())");
        sql.append(" || ':' || ");
        sql.append("MIN(");
        this.encodeIdentifiers(sql, geometryColumn);
        sql.append(".ST_YMin())");
        sql.append(" || ':' || ");
        sql.append("MAX(");
        this.encodeIdentifiers(sql, geometryColumn);
        sql.append(".ST_XMax())");
        sql.append(" || ':' || ");
        sql.append("MAX(");
        this.encodeIdentifiers(sql, geometryColumn);
        sql.append(".ST_YMax())");
    }

    public Envelope decodeGeometryEnvelope(ResultSet rs, int column, Connection cx) throws SQLException, IOException {
        String senvelope = rs.getString(column);
        if (senvelope == null) {
            return new Envelope();
        }
        String[] comps = senvelope.split(":");
        assert (comps.length == 4);
        double x1 = Double.parseDouble(comps[0]);
        double y1 = Double.parseDouble(comps[1]);
        double x2 = Double.parseDouble(comps[2]);
        double y2 = Double.parseDouble(comps[3]);
        return new Envelope(x1, x2, y1, y2);
    }

    public void encodeGeometryColumn(GeometryDescriptor gatt, String prefix, int srid, Hints hints, StringBuffer sql) {
        this.encodeColumnName(prefix, gatt.getLocalName(), sql);
        sql.append(".ST_AsBinary()");
    }

    public void encodeGeometryColumnSimplified(GeometryDescriptor gatt, String prefix, int srid, StringBuffer sql, Double distance) {
        this.encodeColumnName(prefix, gatt.getLocalName(), sql);
        if (distance != null && distance >= 0.0 && !this.simplifyDisabled && this.isPlanarCRS(gatt.getCoordinateReferenceSystem())) {
            sql.append(".ST_Simplify(");
            sql.append(distance.toString());
            sql.append(")");
        }
        sql.append(".ST_AsBinary()");
    }

    private boolean isPlanarCRS(CoordinateReferenceSystem crs) {
        if (crs == null) {
            return false;
        }
        SingleCRS hcrs = CRS.getHorizontalCRS((CoordinateReferenceSystem)crs);
        if (hcrs == null) {
            return false;
        }
        return !(hcrs instanceof GeographicCRS);
    }

    public Geometry decodeGeometryValue(GeometryDescriptor descriptor, ResultSet rs, String column, GeometryFactory factory, Connection cx, Hints hints) throws IOException, SQLException {
        try {
            return this.parseWkb(rs.getBytes(column), factory);
        }
        catch (HanaWKBParserException e) {
            throw new IOException(e);
        }
    }

    public Geometry decodeGeometryValue(GeometryDescriptor descriptor, ResultSet rs, int column, GeometryFactory factory, Connection cx, Hints hints) throws IOException, SQLException {
        try {
            return this.parseWkb(rs.getBytes(column), factory);
        }
        catch (HanaWKBParserException e) {
            throw new IOException(e);
        }
    }

    private Geometry parseWkb(byte[] wkb, GeometryFactory factory) throws HanaWKBParserException {
        if (wkb == null) {
            return null;
        }
        HanaWKBParser parser = new HanaWKBParser(factory);
        return parser.parse(wkb);
    }

    public void encodePrimaryKey(String column, StringBuffer sql) {
        this.encodeColumnName(null, column, sql);
        sql.append(" INTEGER PRIMARY KEY");
    }

    public void encodeCreateTable(StringBuffer sql) {
        sql.append("CREATE COLUMN TABLE ");
    }

    public void encodePostColumnCreateTable(AttributeDescriptor att, StringBuffer sql) {
        if (att instanceof GeometryDescriptor) {
            GeometryDescriptor gd = (GeometryDescriptor)att;
            Integer srid = (Integer)gd.getUserData().get("nativeSRID");
            if (srid == null) {
                srid = this.getSridFromCRS(gd);
            }
            if (srid == null) {
                return;
            }
            int index = sql.lastIndexOf(GEOMETRY_TYPE_NAME);
            if (index < 0) {
                throw new AssertionError();
            }
            String sridConstraint = "(" + Integer.toString(srid) + ")";
            sql.insert(index + GEOMETRY_TYPE_NAME.length(), sridConstraint);
        }
    }

    private Integer getSridFromCRS(GeometryDescriptor gd) {
        if (gd.getCoordinateReferenceSystem() == null) {
            return null;
        }
        try {
            SingleCRS hcrs;
            CoordinateReferenceSystem crs = gd.getCoordinateReferenceSystem();
            Integer srid = CRS.lookupEpsgCode((CoordinateReferenceSystem)crs, (boolean)true);
            if (srid != null && (hcrs = CRS.getHorizontalCRS((CoordinateReferenceSystem)crs)) instanceof GeographicCRS) {
                srid = srid + 1000000000;
            }
            return srid;
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Error looking up the epsg code for metadata insertion", e);
            return null;
        }
    }

    public void postCreateTable(String schemaName, SimpleFeatureType featureType, Connection cx) throws SQLException, IOException {
        this.registerMetadata(schemaName, featureType, cx);
        this.createSequences(schemaName, featureType, cx);
    }

    private void registerMetadata(String schemaName, SimpleFeatureType featureType, Connection cx) throws SQLException {
        String tableName = featureType.getName().getLocalPart();
        for (AttributeDescriptor att : featureType.getAttributeDescriptors()) {
            if (!(att instanceof GeometryDescriptor)) continue;
            GeometryDescriptor gd = (GeometryDescriptor)att;
            this.registerMetadata(schemaName, tableName, gd, cx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerMetadata(String schemaName, String tableName, GeometryDescriptor gd, Connection cx) throws SQLException {
        int dimensions = 2;
        Integer dimHint = (Integer)gd.getUserData().get(Hints.COORDINATE_DIMENSION);
        if (dimHint != null) {
            dimensions = dimHint;
        }
        if (!this.tableExists(schemaName, METADATA_TABLE_NAME, cx)) {
            this.createMetadataTable(schemaName, cx);
        }
        String columnName = gd.getLocalName();
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ");
        this.encodeIdentifiers(sql, schemaName, METADATA_TABLE_NAME);
        sql.append(" VALUES(?, ?, ?)");
        PreparedStatement ps = cx.prepareStatement(sql.toString());
        try {
            ps.setString(1, tableName);
            ps.setString(2, columnName);
            ps.setInt(3, dimensions);
            ps.executeUpdate();
        }
        finally {
            this.dataStore.closeSafe((Statement)ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createMetadataTable(String schemaName, Connection cx) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE COLUMN TABLE ");
        this.encodeIdentifiers(sql, schemaName, METADATA_TABLE_NAME);
        sql.append(" (TABLE_NAME NVARCHAR(256), COLUMN_NAME NVARCHAR(256), DIMENSION INT, PRIMARY KEY (TABLE_NAME, COLUMN_NAME))");
        Statement stmt = cx.createStatement();
        try {
            stmt.execute(sql.toString());
        }
        finally {
            this.dataStore.closeSafe(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSequences(String schemaName, SimpleFeatureType featureType, Connection cx) throws SQLException {
        schemaName = this.resolveSchema(schemaName, cx);
        String tableName = featureType.getTypeName();
        List<String> pkColumns = this.getPrimaryKeys(schemaName, tableName, cx);
        for (String pkColumn : pkColumns) {
            String sequenceName = this.getSequenceName(tableName, pkColumn);
            StringBuffer sql = new StringBuffer();
            sql.append("CREATE SEQUENCE ");
            this.encodeIdentifiers(sql, schemaName, sequenceName);
            sql.append(" MINVALUE 0");
            Statement stmt = null;
            try {
                stmt = cx.createStatement();
                stmt.execute(sql.toString());
            }
            finally {
                this.dataStore.closeSafe(stmt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preDropTable(String schemaName, SimpleFeatureType featureType, Connection cx) throws SQLException {
        schemaName = this.resolveSchema(schemaName, cx);
        String tableName = featureType.getTypeName();
        List<String> pkColumns = this.getPrimaryKeys(schemaName, tableName, cx);
        for (String pkColumn : pkColumns) {
            String sequenceName = this.getSequenceName(tableName, pkColumn);
            StringBuffer sql = new StringBuffer();
            sql.append("DROP SEQUENCE ");
            this.encodeIdentifiers(sql, schemaName, sequenceName);
            Statement stmt = null;
            try {
                stmt = cx.createStatement();
                stmt.execute(sql.toString());
            }
            finally {
                this.dataStore.closeSafe(stmt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postDropTable(String schemaName, SimpleFeatureType featureType, Connection cx) throws SQLException {
        if (!this.tableExists(schemaName, METADATA_TABLE_NAME, cx)) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("DELETE FROM ");
        this.encodeIdentifiers(sql, schemaName, METADATA_TABLE_NAME);
        sql.append(" WHERE TABLE_NAME = ?");
        PreparedStatement ps = cx.prepareStatement(sql.toString());
        try {
            ps.setString(1, featureType.getTypeName());
            ps.executeUpdate();
        }
        finally {
            this.dataStore.closeSafe((Statement)ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getPrimaryKeys(String schemaName, String tableName, Connection cx) throws SQLException {
        DatabaseMetaData dbmd = cx.getMetaData();
        ArrayList<String> pkColumns = new ArrayList<String>();
        ResultSet rs = null;
        try {
            rs = dbmd.getPrimaryKeys(null, schemaName, tableName);
            while (rs.next()) {
                pkColumns.add(rs.getString(4));
            }
        }
        finally {
            this.dataStore.closeSafe(rs);
        }
        return pkColumns;
    }

    public boolean lookupGeneratedValuesPostInsert() {
        return false;
    }

    public Object getNextAutoGeneratedValue(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        String sequenceName = this.getSequenceForColumn(schemaName, tableName, columnName, cx);
        return this.getNextSequenceValue(schemaName, sequenceName, cx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSequenceForColumn(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        String string;
        String sequenceName = this.getSequenceName(tableName, columnName);
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            if (schemaName == null) {
                ps = cx.prepareStatement("SELECT COUNT(*) FROM PUBLIC.SEQUENCES WHERE SCHEMA_NAME = CURRENT_SCHEMA AND SEQUENCE_NAME = ?");
                ps.setString(1, sequenceName);
            } else {
                ps = cx.prepareStatement("SELECT COUNT(*) FROM PUBLIC.SEQUENCES WHERE SCHEMA_NAME = ? AND SEQUENCE_NAME = ?");
                ps.setString(1, schemaName);
                ps.setString(2, sequenceName);
            }
            rs = ps.executeQuery();
            if (!rs.next()) {
                throw new AssertionError();
            }
            int count = rs.getInt(1);
            string = count == 1 ? sequenceName : null;
        }
        catch (Throwable throwable) {
            this.dataStore.closeSafe(rs);
            this.dataStore.closeSafe((Statement)ps);
            throw throwable;
        }
        this.dataStore.closeSafe(rs);
        this.dataStore.closeSafe((Statement)ps);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getNextSequenceValue(String schemaName, String sequenceName, Connection cx) throws SQLException {
        Integer n;
        String sql = "SELECT " + this.encodeNextSequenceValue(schemaName, sequenceName) + " FROM DUMMY";
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = cx.createStatement();
            rs = stmt.executeQuery(sql);
            if (!rs.next()) {
                throw new AssertionError();
            }
            n = rs.getInt(1);
        }
        catch (Throwable throwable) {
            this.dataStore.closeSafe(rs);
            this.dataStore.closeSafe(stmt);
            throw throwable;
        }
        this.dataStore.closeSafe(rs);
        this.dataStore.closeSafe(stmt);
        return n;
    }

    public String encodeNextSequenceValue(String schemaName, String sequenceName) {
        StringBuffer sql = new StringBuffer();
        this.encodeIdentifiers(sql, schemaName, sequenceName);
        sql.append(".NEXTVAL");
        return sql.toString();
    }

    private String getSequenceName(String tableName, String columnName) {
        return tableName + "_" + columnName + SEQUENCE_SUFFIX;
    }

    public boolean isLimitOffsetSupported() {
        return true;
    }

    public void applyLimitOffset(StringBuffer sql, int limit, int offset) {
        sql.append(" LIMIT ");
        sql.append(limit);
        sql.append(" OFFSET ");
        sql.append(offset);
    }

    protected void addSupportedHints(Set<Hints.Key> hints) {
        if (!this.simplifyDisabled && (this.hanaVersion.getVersion() > 2 || this.hanaVersion.getVersion() == 2 && this.hanaVersion.getRevision() >= 40)) {
            hints.add(Hints.GEOMETRY_SIMPLIFICATION);
        }
    }

    public int getDefaultVarcharSize() {
        return 255;
    }

    protected boolean supportsSchemaForIndex() {
        return true;
    }

    public void handleSelectHints(StringBuffer sql, SimpleFeatureType featureType, Query query) {
        if (this.selectHints == null || this.selectHints.trim().isEmpty()) {
            return;
        }
        sql.append(" WITH HINT( ");
        sql.append(this.selectHints);
        sql.append(" )");
    }

    public boolean applyHintsOnVirtualTables() {
        return true;
    }

    public String[] getDesiredTablesType() {
        return new String[]{"TABLE", "OLAP VIEW", "JOIN VIEW", "VIEW", "CALC VIEW", "SYNONYM"};
    }

    public void prepareGeometryValue(Class<? extends Geometry> gClass, int dimension, int srid, Class binding, StringBuffer sql) {
        sql.append("ST_GeomFromWKB(?, ");
        sql.append(srid);
        sql.append(")");
    }

    public void setGeometryValue(Geometry g, int dimension, int srid, Class binding, PreparedStatement ps, int column) throws SQLException {
        if (g != null) {
            dimension = Math.min(dimension, HanaDimensionFinder.findDimension(g));
            try {
                byte[] wkb = HanaWKBWriter.write(g, dimension);
                ps.setBytes(column, wkb);
            }
            catch (HanaWKBWriterException e) {
                throw new SQLException(e);
            }
        } else {
            ps.setNull(column, 2004);
        }
    }

    public void setValue(Object value, Class<?> binding, AttributeDescriptor att, PreparedStatement ps, int column, Connection cx) throws SQLException {
        if (value == null) {
            super.setValue(value, binding, att, ps, column, cx);
            return;
        }
        Integer sqlType = this.dataStore.getMapping(binding, att);
        switch (sqlType) {
            case 92: {
                Time time = Time.valueOf(((Time)this.convert(value, Time.class)).toString());
                ps.setTime(column, time);
                break;
            }
            default: {
                super.setValue(value, binding, att, ps, column, cx);
            }
        }
    }

    public PreparedFilterToSQL createPreparedFilterToSQL() {
        return new HanaFilterToSQL(this, this.functionEncodingEnabled, this.hanaVersion);
    }

    private String resolveSchema(String schemaName, Connection cx) throws SQLException, AssertionError {
        if (schemaName == null) {
            schemaName = this.getCurrentSchema(cx);
        }
        return schemaName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCurrentSchema(Connection cx) throws SQLException {
        String schemaName;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = cx.createStatement();
            rs = stmt.executeQuery("SELECT CURRENT_SCHEMA FROM DUMMY");
            if (!rs.next()) {
                throw new AssertionError();
            }
            schemaName = rs.getString(1);
        }
        catch (Throwable throwable) {
            this.dataStore.closeSafe(rs);
            this.dataStore.closeSafe(stmt);
            throw throwable;
        }
        this.dataStore.closeSafe(rs);
        this.dataStore.closeSafe(stmt);
        return schemaName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tableExists(String schemaName, String tableName, Connection cx) throws SQLException {
        boolean bl;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            if (schemaName == null) {
                ps = cx.prepareStatement("SELECT COUNT(*) FROM PUBLIC.TABLES WHERE SCHEMA_NAME = CURRENT_SCHEMA AND TABLE_NAME = ?");
                ps.setString(1, tableName);
            } else {
                ps = cx.prepareStatement("SELECT COUNT(*) FROM PUBLIC.TABLES WHERE SCHEMA_NAME = ? AND TABLE_NAME = ?");
                ps.setString(1, schemaName);
                ps.setString(2, tableName);
            }
            rs = ps.executeQuery();
            if (!rs.next()) {
                throw new AssertionError();
            }
            int count = rs.getInt(1);
            bl = count == 1;
        }
        catch (Throwable throwable) {
            this.dataStore.closeSafe(rs);
            this.dataStore.closeSafe((Statement)ps);
            throw throwable;
        }
        this.dataStore.closeSafe(rs);
        this.dataStore.closeSafe((Statement)ps);
        return bl;
    }

    private void encodeIdentifiers(StringBuffer sb, String ... ids) {
        boolean first = true;
        for (String id : ids) {
            if (id == null) continue;
            if (first) {
                first = false;
            } else {
                sb.append('.');
            }
            sb.append(HanaUtil.encodeIdentifier(id));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HanaCloudVersion queryCloudVersion(Connection cx) throws SQLException {
        HanaCloudVersion hanaCloudVersion;
        if (this.hanaVersion.getVersion() < 4) {
            return HanaCloudVersion.INVALID_VERSION;
        }
        Statement st = null;
        ResultSet rs = null;
        try {
            st = cx.createStatement();
            rs = st.executeQuery("SELECT CLOUD_VERSION FROM SYS.M_DATABASE");
            if (!rs.next()) {
                throw new RuntimeException("Unable to determine HANA Cloud Version.");
            }
            String cloudVersion = rs.getString(1);
            hanaCloudVersion = new HanaCloudVersion(cloudVersion);
        }
        catch (Throwable throwable) {
            this.dataStore.closeSafe(rs);
            this.dataStore.closeSafe(st);
            throw throwable;
        }
        this.dataStore.closeSafe(rs);
        this.dataStore.closeSafe(st);
        return hanaCloudVersion;
    }

    private boolean isExtentEstimationAvailable() {
        switch (this.hanaVersion.getVersion()) {
            case 2: {
                return this.hanaVersion.compareTo(new HanaVersion(2, 0, 80, 0L)) >= 0;
            }
            case 4: {
                return this.cloudVersion.compareTo(new HanaCloudVersion(2024, 2, 0)) >= 0;
            }
        }
        return false;
    }

    static {
        TYPE_NAME_TO_CLASS.put("TINYINT", Short.class);
        TYPE_NAME_TO_CLASS.put("SMALLINT", Short.class);
        TYPE_NAME_TO_CLASS.put("INTEGER", Integer.class);
        TYPE_NAME_TO_CLASS.put("BIGINT", Long.class);
        TYPE_NAME_TO_CLASS.put("DECIMAL", BigDecimal.class);
        TYPE_NAME_TO_CLASS.put("REAL", Float.class);
        TYPE_NAME_TO_CLASS.put("DOUBLE", Double.class);
        TYPE_NAME_TO_CLASS.put("CHAR", String.class);
        TYPE_NAME_TO_CLASS.put("VARCHAR", String.class);
        TYPE_NAME_TO_CLASS.put("BINARY", byte[].class);
        TYPE_NAME_TO_CLASS.put("VARBINARY", byte[].class);
        TYPE_NAME_TO_CLASS.put("DATE", Date.class);
        TYPE_NAME_TO_CLASS.put("TIME", Time.class);
        TYPE_NAME_TO_CLASS.put("TIMESTAMP", Timestamp.class);
        TYPE_NAME_TO_CLASS.put("CLOB", String.class);
        TYPE_NAME_TO_CLASS.put("BLOB", byte[].class);
        TYPE_NAME_TO_CLASS.put("NCHAR", String.class);
        TYPE_NAME_TO_CLASS.put("NVARCHAR", String.class);
        TYPE_NAME_TO_CLASS.put("ALPHANUM", String.class);
        TYPE_NAME_TO_CLASS.put("NCLOB", String.class);
        TYPE_NAME_TO_CLASS.put("SMALLDECIMAL", BigDecimal.class);
        TYPE_NAME_TO_CLASS.put("TEXT", String.class);
        TYPE_NAME_TO_CLASS.put("BINTEXT", byte[].class);
        TYPE_NAME_TO_CLASS.put("SHORTTEXT", String.class);
        TYPE_NAME_TO_CLASS.put("SECONDDATE", Timestamp.class);
        TYPE_NAME_TO_CLASS.put("ST_POINT", Point.class);
        TYPE_NAME_TO_CLASS.put("ST_GEOMETRY", Geometry.class);
        TYPE_NAME_TO_CLASS.put("BOOLEAN", Boolean.class);
        SQL_TYPE_TO_CLASS = new HashMap();
        SQL_TYPE_TO_CLASS.put(-4, byte[].class);
        SQL_TYPE_TO_CLASS.put(-8, String.class);
        SQL_TYPE_TO_CLASS.put(-10, String.class);
        SQL_TYPE_TO_CLASS.put(3000, BigDecimal.class);
        SQL_TYPE_TO_CLASS.put(29812, Geometry.class);
        CLASS_TO_SQL_TYPE = new HashMap();
        CLASS_TO_SQL_TYPE.put(Geometry.class, 29812);
        CLASS_TO_SQL_TYPE.put(Point.class, 29812);
        CLASS_TO_SQL_TYPE.put(LineString.class, 29812);
        CLASS_TO_SQL_TYPE.put(Polygon.class, 29812);
        CLASS_TO_SQL_TYPE.put(MultiPoint.class, 29812);
        CLASS_TO_SQL_TYPE.put(MultiLineString.class, 29812);
        CLASS_TO_SQL_TYPE.put(MultiPolygon.class, 29812);
        CLASS_TO_SQL_TYPE.put(GeometryCollection.class, 29812);
        SQL_TYPE_TO_SQL_TYPE_NAME = new HashMap<Integer, String>();
        SQL_TYPE_TO_SQL_TYPE_NAME.put(2005, "CLOB");
    }

    private class SchemaCache {
        private Connection cx;
        private String currentSchema;

        public String getSchema(Connection cx) throws SQLException {
            if (cx == this.cx) {
                return this.currentSchema;
            }
            this.currentSchema = HanaDialect.this.getCurrentSchema(cx);
            this.cx = cx;
            return this.currentSchema;
        }
    }
}

