/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.oracle;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.Transaction;
import org.geotools.data.oracle.OracleDialect;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.JDBCDataStoreFactory;
import org.geotools.jdbc.SQLDialect;

public class OracleNGDataStoreFactory
extends JDBCDataStoreFactory {
    private static final String JDBC_PATH = "jdbc:oracle:thin:@";
    public static final DataAccessFactory.Param DBTYPE = new DataAccessFactory.Param("dbtype", String.class, "Type", true, (Object)"oracle", Collections.singletonMap("level", "program"));
    public static final DataAccessFactory.Param PORT = new DataAccessFactory.Param("port", Integer.class, "Port", false, (Object)1521);
    public static final DataAccessFactory.Param HOST = new DataAccessFactory.Param("host", String.class, "Host", false, (Object)"localhost");
    public static final DataAccessFactory.Param DATABASE = new DataAccessFactory.Param("database", String.class, "Database", true);
    public static final DataAccessFactory.Param ESTIMATED_EXTENTS = new DataAccessFactory.Param("Estimated extends", Boolean.class, "Use the spatial index information to quickly get an estimate of the data bounds", false, (Object)Boolean.TRUE);
    public static final DataAccessFactory.Param LOOSEBBOX = new DataAccessFactory.Param("Loose bbox", Boolean.class, "Perform only primary filter on bbox", false, (Object)Boolean.TRUE);
    public static final DataAccessFactory.Param GEOMETRY_METADATA_TABLE = new DataAccessFactory.Param("Geometry metadata table", String.class, "The optional table containing geometry metadata (geometry type and srid). Can be expressed as 'schema.name' or just 'name'", false);
    public static final DataAccessFactory.Param METADATA_BBOX = new DataAccessFactory.Param("Metadata bbox", Boolean.class, "Get data bounds quickly from MDSYS.USER_SDO_GEOM_METADATA or MDSYS.ALL_SDO_GEOM_METADATA table", false, (Object)Boolean.FALSE);

    protected SQLDialect createSQLDialect(JDBCDataStore dataStore) {
        return new OracleDialect(dataStore);
    }

    protected String getDatabaseID() {
        return (String)OracleNGDataStoreFactory.DBTYPE.sample;
    }

    public String getDisplayName() {
        return "Oracle NG";
    }

    public String getDescription() {
        return "Oracle Database";
    }

    protected String getDriverClassName() {
        return "oracle.jdbc.OracleDriver";
    }

    protected boolean checkDBType(Map params) {
        if (super.checkDBType(params)) {
            try {
                Class.forName("org.geotools.data.oracle.OracleDataStoreFactory");
                return false;
            }
            catch (ClassNotFoundException e) {
                return true;
            }
        }
        return this.checkDBType(params, "Oracle");
    }

    protected JDBCDataStore createDataStoreInternal(JDBCDataStore dataStore, Map params) throws IOException {
        if (dataStore.getDatabaseSchema() != null) {
            dataStore.setDatabaseSchema(dataStore.getDatabaseSchema().toUpperCase());
        }
        OracleDialect dialect = (OracleDialect)dataStore.getSQLDialect();
        Boolean loose = (Boolean)LOOSEBBOX.lookUp(params);
        dialect.setLooseBBOXEnabled(loose == null || Boolean.TRUE.equals(loose));
        Boolean estimated = (Boolean)ESTIMATED_EXTENTS.lookUp(params);
        dialect.setEstimatedExtentsEnabled(estimated == null || Boolean.TRUE.equals(estimated));
        String metadataTable = (String)GEOMETRY_METADATA_TABLE.lookUp(params);
        dialect.setGeometryMetadataTable(metadataTable);
        Boolean metadateBbox = (Boolean)METADATA_BBOX.lookUp(params);
        dialect.setMetadataBboxEnabled(Boolean.TRUE.equals(metadateBbox));
        if (dataStore.getFetchSize() <= 0) {
            dataStore.setFetchSize(200);
        }
        Connection cx = dataStore.getConnection(Transaction.AUTO_COMMIT);
        try {
            dialect.unwrapConnection(cx);
            dialect.initVersion(cx);
        }
        catch (SQLException e) {
            throw new IOException("Unable to obtain Oracle Connection require for SDO Geometry access).Check connection pool implementation to unsure unwrap is available", e);
        }
        finally {
            dataStore.closeSafe(cx);
        }
        return dataStore;
    }

    protected String getJDBCUrl(Map params) throws IOException {
        String db = (String)DATABASE.lookUp(params);
        String host = (String)HOST.lookUp(params);
        Integer port = (Integer)PORT.lookUp(params);
        if (db.startsWith("(") || db.startsWith("ldap://")) {
            return JDBC_PATH + db;
        }
        if (db.startsWith("/") && host != null && port != null) {
            return "jdbc:oracle:thin:@//" + host + ":" + port + db;
        }
        if (host != null && port != null) {
            return JDBC_PATH + host + ":" + port + ":" + db;
        }
        throw new IOException("Unable to properly compose the JDBC URL string, some parameters as host and port may be null !");
    }

    protected void setupParameters(Map parameters) {
        super.setupParameters(parameters);
        parameters.put(OracleNGDataStoreFactory.LOOSEBBOX.key, LOOSEBBOX);
        parameters.put(OracleNGDataStoreFactory.ESTIMATED_EXTENTS.key, ESTIMATED_EXTENTS);
        parameters.put(OracleNGDataStoreFactory.MAX_OPEN_PREPARED_STATEMENTS.key, MAX_OPEN_PREPARED_STATEMENTS);
        parameters.put(OracleNGDataStoreFactory.PORT.key, PORT);
        parameters.put(OracleNGDataStoreFactory.HOST.key, HOST);
        parameters.put(OracleNGDataStoreFactory.DATABASE.key, DATABASE);
        parameters.put(OracleNGDataStoreFactory.DBTYPE.key, DBTYPE);
        parameters.put(OracleNGDataStoreFactory.GEOMETRY_METADATA_TABLE.key, GEOMETRY_METADATA_TABLE);
        parameters.put(OracleNGDataStoreFactory.METADATA_BBOX.key, METADATA_BBOX);
    }

    protected String getValidationQuery() {
        return "select 1 from dual";
    }
}

