/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.sqlserver.reader;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.geotools.data.sqlserver.reader.Figure;
import org.geotools.data.sqlserver.reader.Segment;
import org.geotools.data.sqlserver.reader.Shape;
import org.geotools.data.sqlserver.reader.SqlServerBinary;
import org.geotools.data.sqlserver.reader.SqlServerBinaryParseException;
import org.geotools.data.sqlserver.reader.Type;
import org.geotools.geometry.jts.CurvedGeometryFactory;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.ByteArrayInStream;
import org.locationtech.jts.io.ByteOrderDataInStream;
import org.locationtech.jts.io.InStream;
import org.locationtech.jts.io.ParseException;

public class SqlServerBinaryReader {
    private ByteOrderDataInStream dis = new ByteOrderDataInStream();
    private GeometryFactory gf;
    private CurvedGeometryFactory cgf;
    private SqlServerBinary binary;

    public SqlServerBinaryReader() {
        this(new GeometryFactory());
    }

    public SqlServerBinaryReader(GeometryFactory gf) {
        this.gf = gf;
        this.cgf = gf instanceof CurvedGeometryFactory ? (CurvedGeometryFactory)gf : new CurvedGeometryFactory(gf, Double.MAX_VALUE);
    }

    public Geometry read(byte[] bytes) throws IOException {
        this.binary = new SqlServerBinary();
        return this.read((InStream)new ByteArrayInStream(bytes));
    }

    public Geometry read(InStream is) throws IOException {
        try {
            this.parse(is);
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
        this.readCoordinateSequences();
        Type type = this.getTypeFromBinary();
        Geometry geometry = this.decode(0, type);
        geometry.setSRID(this.binary.getSrid());
        return geometry;
    }

    private Geometry decode(int shapeIndex, Type type) throws SqlServerBinaryParseException {
        switch (type) {
            case GEOMETRYCOLLECTION: {
                return this.decodeGeometryCollection(shapeIndex);
            }
            case POINT: {
                return this.decodePoint(shapeIndex);
            }
            case LINESTRING: {
                return this.decodeLinestring(shapeIndex);
            }
            case POLYGON: {
                return this.decodeCurvePolygon(shapeIndex);
            }
            case MULTILINESTRING: {
                return this.decodeMultiLinestring(shapeIndex);
            }
            case MULTIPOINT: {
                return this.decodeMultiPoint(shapeIndex);
            }
            case MULTIPOLYGON: {
                return this.decodeMultiPolygon(shapeIndex);
            }
            case CIRCULARSTRING: {
                return this.decodeCircularString(shapeIndex);
            }
            case COMPOUNDCURVE: {
                return this.decodeCompoundCurve(shapeIndex);
            }
            case CURVEPOLYGON: {
                return this.decodeCurvePolygon(shapeIndex);
            }
        }
        throw new SqlServerBinaryParseException("Geometry type unsupported " + String.valueOf((Object)type));
    }

    private Geometry decodeCurvePolygon(int shapeIndex) {
        Shape shape = this.binary.getShape(shapeIndex);
        int figureOffset = shape.getFigureOffset();
        int figureStopIndex = this.binary.getFigures().length - 1;
        if (shapeIndex + 1 < this.binary.getShapes().length) {
            Shape nextShape = this.binary.getShape(shapeIndex + 1);
            figureStopIndex = nextShape.getFigureOffset() - 1;
        }
        if (figureOffset <= -1) {
            return this.cgf.createPolygon(new Coordinate[0]);
        }
        LinearRing outerShell = null;
        LinearRing[] holes = new LinearRing[figureStopIndex - figureOffset];
        for (int i = figureOffset; i <= figureStopIndex; ++i) {
            LinearRing ring;
            Figure figure = this.binary.getFigure(i);
            CoordinateSequence[] sequences = this.binary.getSequence(i);
            if (sequences.length > 1) {
                List<Figure.SequenceType> sequenceTypes = figure.getSequenceTypes();
                ArrayList<LineString> components = new ArrayList<LineString>(sequences.length);
                for (int j = 0; j < sequences.length; ++j) {
                    CoordinateSequence sequence = sequences[j];
                    if (sequenceTypes.get(j) == Figure.SequenceType.CURVED) {
                        components.add(this.cgf.createCurvedGeometry(sequence));
                        continue;
                    }
                    components.add(this.cgf.createLineString(sequence));
                }
                ring = (LinearRing)this.cgf.createCurvedGeometry(components);
            } else {
                ring = figure.getAttribute() == 2 && this.binary.getVersion() == 2 ? (LinearRing)this.cgf.createCurvedGeometry(sequences[0]) : this.gf.createLinearRing(sequences[0]);
            }
            if (i == figureOffset) {
                outerShell = ring;
                continue;
            }
            holes[i - figureOffset - 1] = ring;
        }
        return this.cgf.createPolygon(outerShell, holes);
    }

    private Geometry decodeCircularString(int shapeIndex) {
        Shape shape = this.binary.getShape(shapeIndex);
        CoordinateSequence sequence = this.binary.getSequence(shape.getFigureOffset())[0];
        return this.cgf.createCircularString(sequence);
    }

    private Geometry decodeCompoundCurve(int shapeIndex) throws SqlServerBinaryParseException {
        Shape shape = this.binary.getShape(shapeIndex);
        Figure figure = this.binary.getFigure(shape.getFigureOffset());
        CoordinateSequence[] sequences = this.binary.getSequence(shape.getFigureOffset());
        List<Figure.SequenceType> sequenceTypes = figure.getSequenceTypes();
        ArrayList<LineString> components = new ArrayList<LineString>(sequences.length);
        for (int j = 0; j < sequences.length; ++j) {
            CoordinateSequence sequence = sequences[j];
            if (sequenceTypes.get(j) == Figure.SequenceType.CURVED) {
                components.add(this.cgf.createCurvedGeometry(sequence));
                continue;
            }
            components.add(this.cgf.createLineString(sequence));
        }
        return this.cgf.createCurvedGeometry(components);
    }

    private Geometry decodeMultiPolygon(int shapeIndex) {
        ArrayList<Geometry> polygons = new ArrayList<Geometry>();
        for (int i = shapeIndex; i < this.binary.getShapes().length; ++i) {
            if (this.binary.getShape(i).getParentOffset() != shapeIndex) continue;
            polygons.add(this.decodeCurvePolygon(i));
        }
        return this.cgf.createMultiPolygon(polygons.toArray(new Polygon[polygons.size()]));
    }

    private Geometry decodeMultiPoint(int shapeIndex) {
        ArrayList<Point> points = new ArrayList<Point>();
        for (int i = shapeIndex; i < this.binary.getShapes().length; ++i) {
            if (this.binary.getShape(i).getParentOffset() != shapeIndex) continue;
            points.add(this.gf.createPoint(this.binary.getSequence(this.binary.getShape(i).getFigureOffset())[0]));
        }
        return this.gf.createMultiPoint(points.toArray(new Point[points.size()]));
    }

    private Geometry decodeMultiLinestring(int shapeIndex) {
        ArrayList<LineString> linestrings = new ArrayList<LineString>();
        for (int i = shapeIndex; i < this.binary.getShapes().length; ++i) {
            if (this.binary.getShape(i).getParentOffset() != shapeIndex) continue;
            CoordinateSequence[] sequences = this.binary.getSequence(this.binary.getShape(i).getFigureOffset());
            linestrings.add(this.gf.createLineString(sequences[0]));
        }
        return this.gf.createMultiLineString(linestrings.toArray(new LineString[linestrings.size()]));
    }

    private Geometry decodeLinestring(int shapeIndex) {
        Shape shape = this.binary.getShape(shapeIndex);
        CoordinateSequence sequence = this.binary.getSequence(shape.getFigureOffset())[0];
        return this.gf.createLineString(sequence);
    }

    private Geometry decodePoint(int shapeIndex) {
        Coordinate coordinate;
        Shape shape = this.binary.getShapes()[shapeIndex];
        if (this.binary.isSinglePoint()) {
            coordinate = this.binary.getCoordinates()[0];
        } else if (shape.getParentOffset() != -1) {
            Figure figure = this.binary.getFigure(shape.getFigureOffset());
            coordinate = this.binary.getCoordinates()[figure.getPointOffset()];
        } else {
            coordinate = null;
        }
        return this.gf.createPoint(coordinate);
    }

    private Geometry decodeGeometryCollection(int shapeIndex) throws SqlServerBinaryParseException {
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        for (int i = shapeIndex + 1; i < this.binary.getShapes().length; ++i) {
            Shape subShape = this.binary.getShapes()[i];
            if (subShape.getParentOffset() != shapeIndex) continue;
            geometries.add(this.decode(i, subShape.getType()));
        }
        return this.cgf.createGeometryCollection(geometries.toArray(new Geometry[geometries.size()]));
    }

    private Type getTypeFromBinary() {
        if (this.binary.isSinglePoint()) {
            return Type.POINT;
        }
        if (this.binary.hasSingleLineSegment()) {
            return Type.LINESTRING;
        }
        return this.binary.getShapes()[0].getType();
    }

    private void readCoordinateSequences() {
        Figure[] figures = this.binary.getFigures();
        CoordinateSequence[][] sequences = new CoordinateSequence[figures.length][];
        CoordinateSequenceFactory csFactory = this.gf.getCoordinateSequenceFactory();
        int segmentIdx = 0;
        for (int i = 0; i < figures.length; ++i) {
            Figure figure = figures[i];
            int figurePointOffset = figure.getPointOffset();
            int nextPointOffset = figures.length >= i + 2 ? figures[i + 1].getPointOffset() : this.binary.getCoordinates().length;
            Coordinate[] coordinates = Arrays.copyOfRange(this.binary.getCoordinates(), figurePointOffset, nextPointOffset);
            int attribute = figure.getAttribute();
            if (this.binary.getVersion() == 1) {
                if (!(attribute != 0 && attribute != 2 || coordinates[0].equals((Object)coordinates[coordinates.length - 1]))) {
                    coordinates = Arrays.copyOf(coordinates, coordinates.length + 1);
                    coordinates[coordinates.length - 1] = coordinates[0];
                }
                sequences[i] = new CoordinateSequence[1];
                sequences[i][0] = csFactory.create(coordinates);
                continue;
            }
            if (this.binary.getVersion() != 2) continue;
            if (figure.getAttribute() == 3) {
                ArrayList<CoordinateSequence> figureSequences = new ArrayList<CoordinateSequence>();
                ArrayList<Figure.SequenceType> sequenceTypes = new ArrayList<Figure.SequenceType>();
                ArrayList<Coordinate> sequenceCoordinates = null;
                Segment[] segments = this.binary.getSegments();
                int c = 0;
                while (c < coordinates.length - 1) {
                    Segment segment;
                    if ((segment = segments[segmentIdx++]) == Segment.FIRST_ARC || segment == Segment.FIRST_LINE) {
                        if (sequenceCoordinates != null) {
                            if (c < coordinates.length - 1) {
                                sequenceCoordinates.add(coordinates[c]);
                            }
                            CoordinateSequence cs = csFactory.create(sequenceCoordinates.toArray(new Coordinate[sequenceCoordinates.size()]));
                            figureSequences.add(cs);
                        }
                        sequenceCoordinates = new ArrayList<Coordinate>();
                        sequenceTypes.add(segment == Segment.FIRST_ARC ? Figure.SequenceType.CURVED : Figure.SequenceType.STRAIGHT);
                    }
                    sequenceCoordinates.add(coordinates[c++]);
                    if (segment != Segment.FIRST_ARC && segment != Segment.ARC) continue;
                    sequenceCoordinates.add(coordinates[c++]);
                }
                if (sequenceCoordinates != null) {
                    sequenceCoordinates.add(coordinates[coordinates.length - 1]);
                    CoordinateSequence cs = csFactory.create(sequenceCoordinates.toArray(new Coordinate[sequenceCoordinates.size()]));
                    figureSequences.add(cs);
                }
                sequences[i] = figureSequences.toArray(new CoordinateSequence[figureSequences.size()]);
                figure.setSequenceTypes(sequenceTypes);
                continue;
            }
            sequences[i] = new CoordinateSequence[1];
            sequences[i][0] = csFactory.create(coordinates);
        }
        this.binary.setSequences(sequences);
    }

    private void parse(InStream is) throws IOException, ParseException {
        this.dis.setInStream(is);
        this.dis.setOrder(2);
        this.binary.setSrid(this.dis.readInt());
        byte version = this.dis.readByte();
        if (!(version == 1 | version == 2)) {
            throw new SqlServerBinaryParseException("Unsupported version (only supports version 1 and 2): " + version);
        }
        this.binary.setVersion(version);
        this.binary.setSerializationProperties(this.dis.readByte());
        this.readNumberOfPoints();
        this.readCoordinates();
        this.readZValues();
        this.readMValues();
        if (this.binary.isSinglePoint()) {
            this.binary.setFigures(new Figure[]{new Figure(1, 0)});
            this.binary.setShapes(new Shape[]{new Shape(-1, 0, 2)});
        } else if (this.binary.hasSingleLineSegment()) {
            this.binary.setFigures(new Figure[]{new Figure(1, 0)});
            this.binary.setShapes(new Shape[]{new Shape(-1, 0, 1)});
        } else {
            this.readFigures();
            this.readShapes();
            this.readSegments();
        }
    }

    private void readSegments() throws IOException, ParseException {
        if (this.binary.getVersion() > 1 && this.binary.hasSegments()) {
            int numberOfSegments = this.dis.readInt();
            Segment[] segments = new Segment[numberOfSegments];
            for (int i = 0; i < numberOfSegments; ++i) {
                segments[i] = Segment.findSegment(this.dis.readByte());
            }
            this.binary.setSegments(segments);
        }
    }

    private void readNumberOfPoints() throws IOException, ParseException {
        if (this.binary.isSinglePoint()) {
            this.binary.setNumberOfPoints(1);
        } else if (this.binary.hasSingleLineSegment()) {
            this.binary.setNumberOfPoints(2);
        } else {
            this.binary.setNumberOfPoints(this.dis.readInt());
        }
    }

    private void readCoordinates() throws IOException, ParseException {
        Coordinate[] coordinates = new Coordinate[this.binary.getNumberOfPoints()];
        for (int i = 0; i < this.binary.getNumberOfPoints(); ++i) {
            coordinates[i] = this.readCoordinate();
        }
        this.binary.setCoordinates(coordinates);
    }

    private void readShapes() throws IOException, ParseException {
        int numberOfShapes = this.dis.readInt();
        Shape[] shapesMetadata = new Shape[numberOfShapes];
        for (int i = 0; i < numberOfShapes; ++i) {
            int parentOffset = this.dis.readInt();
            int figureOffset = this.dis.readInt();
            byte shapeType = this.dis.readByte();
            shapesMetadata[i] = new Shape(parentOffset, figureOffset, shapeType);
        }
        this.binary.setShapes(shapesMetadata);
    }

    private void readFigures() throws IOException, ParseException {
        int numberOfFigures = this.dis.readInt();
        Figure[] figuresMetadata = new Figure[numberOfFigures];
        for (int i = 0; i < numberOfFigures; ++i) {
            byte figureAttribute = this.dis.readByte();
            int figurePointOffset = this.dis.readInt();
            figuresMetadata[i] = new Figure(figureAttribute, figurePointOffset);
        }
        this.binary.setFigures(figuresMetadata);
    }

    private void readMValues() throws IOException, ParseException {
        if (this.binary.hasM()) {
            for (int i = 0; i < this.binary.getNumberOfPoints(); ++i) {
                this.dis.readDouble();
            }
        }
    }

    private void readZValues() throws IOException, ParseException {
        if (this.binary.hasZ()) {
            for (int i = 0; i < this.binary.getNumberOfPoints(); ++i) {
                this.binary.getCoordinates()[i].setZ(this.dis.readDouble());
            }
        }
    }

    private Coordinate readCoordinate() throws IOException, ParseException {
        return new Coordinate(this.dis.readDouble(), this.dis.readDouble());
    }
}

