/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.sqlserver;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.geotools.api.data.Query;
import org.geotools.api.feature.FeatureVisitor;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.cs.CoordinateSystem;
import org.geotools.api.referencing.cs.CoordinateSystemAxis;
import org.geotools.data.jdbc.FilterToSQL;
import org.geotools.data.sqlserver.GeometryDimensionFinder;
import org.geotools.data.sqlserver.SQLServerFilterToSQL;
import org.geotools.data.sqlserver.SpatialIndexAttributeExtractor;
import org.geotools.data.sqlserver.reader.SqlServerBinaryReader;
import org.geotools.feature.visitor.StandardDeviationVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.geometry.jts.WKBReader;
import org.geotools.geometry.jts.WKTWriter2;
import org.geotools.jdbc.BasicSQLDialect;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.referencing.CRS;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryComponentFilter;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;

public class SQLServerDialect
extends BasicSQLDialect {
    private static final int DEFAULT_AXIS_MAX = 10000000;
    private static final int DEFAULT_AXIS_MIN = -10000000;
    static final String SPATIAL_INDEX_KEY = "SpatialIndex";
    static final Pattern FROM_PATTERN = Pattern.compile("(\\s+)(FROM)(\\s)+", 32);
    static final Pattern POSITIVE_NUMBER = Pattern.compile("[1-9][0-9]*");
    private String geometryMetadataTable;
    private Boolean useOffsetLimit = false;
    private Boolean useNativeSerialization = false;
    private Boolean forceSpatialIndexes = false;
    private boolean estimatedExtentsEnabled = false;
    private String tableHints;
    static final Map<String, Class> TYPE_TO_CLASS_MAP = Map.ofEntries(Map.entry("GEOMETRY", Geometry.class), Map.entry("GEOGRAPHY", Geometry.class), Map.entry("POINT", Point.class), Map.entry("POINTM", Point.class), Map.entry("LINESTRING", LineString.class), Map.entry("LINESTRINGM", LineString.class), Map.entry("POLYGON", Polygon.class), Map.entry("POLYGONM", Polygon.class), Map.entry("MULTIPOINT", MultiPoint.class), Map.entry("MULTIPOINTM", MultiPoint.class), Map.entry("MULTILINESTRING", MultiLineString.class), Map.entry("MULTILINESTRINGM", MultiLineString.class), Map.entry("MULTIPOLYGON", MultiPolygon.class), Map.entry("MULTIPOLYGONM", MultiPolygon.class), Map.entry("GEOMETRYCOLLECTION", GeometryCollection.class), Map.entry("GEOMETRYCOLLECTIONM", GeometryCollection.class));
    static final Map<Class, String> CLASS_TO_TYPE_MAP = Map.of(Geometry.class, "GEOMETRY", Point.class, "POINT", LineString.class, "LINESTRING", Polygon.class, "POLYGON", MultiPoint.class, "MULTIPOINT", MultiLineString.class, "MULTILINESTRING", MultiPolygon.class, "MULTIPOLYGON", GeometryCollection.class, "GEOMETRYCOLLECTION");

    public SQLServerDialect(JDBCDataStore dataStore) {
        super(dataStore);
    }

    public boolean includeTable(String schemaName, String tableName, Connection cx) throws SQLException {
        return !"INFORMATION_SCHEMA".equals(schemaName) && !"sys".equals(schemaName);
    }

    public String getGeometryTypeName(Integer type) {
        return "geometry";
    }

    public void registerClassToSqlMappings(Map<Class<?>, Integer> mappings) {
        super.registerClassToSqlMappings(mappings);
        mappings.put(Date.class, 93);
        mappings.put(Time.class, 93);
    }

    public void registerSqlTypeNameToClassMappings(Map<String, Class<?>> mappings) {
        super.registerSqlTypeNameToClassMappings(mappings);
        mappings.put("geometry", Geometry.class);
        mappings.put("uniqueidentifier", UUID.class);
        mappings.put("time", Time.class);
        mappings.put("date", Date.class);
        mappings.put("datetime", Timestamp.class);
        mappings.put("datetime2", Timestamp.class);
        mappings.put("datetimeoffset", OffsetDateTime.class);
    }

    public void registerSqlTypeToSqlTypeNameOverrides(Map<Integer, String> overrides) {
        super.registerSqlTypeToSqlTypeNameOverrides(overrides);
        overrides.put(12, "varchar");
        overrides.put(2004, "varbinary");
        overrides.put(2005, "text");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCreateTable(String schemaName, SimpleFeatureType featureType, Connection cx) throws SQLException, IOException {
        String tableName = featureType.getName().getLocalPart();
        Statement st = null;
        try {
            st = cx.createStatement();
            for (AttributeDescriptor att : featureType.getAttributeDescriptors()) {
                CoordinateReferenceSystem crs;
                CoordinateSystem cs;
                if (!(att instanceof GeometryDescriptor)) continue;
                GeometryDescriptor gd = (GeometryDescriptor)att;
                if (this.geometryMetadataTable != null) {
                    int srid = -1;
                    if (gd.getUserData().get("nativeSRID") != null) {
                        srid = (Integer)gd.getUserData().get("nativeSRID");
                    } else if (gd.getCoordinateReferenceSystem() != null) {
                        try {
                            Integer result = CRS.lookupEpsgCode((CoordinateReferenceSystem)gd.getCoordinateReferenceSystem(), (boolean)true);
                            if (result != null) {
                                srid = result;
                            }
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.FINE, "Error looking up the epsg code for metadata insertion, assuming -1", e);
                        }
                    }
                    int dimensions = 2;
                    String geomType = CLASS_TO_TYPE_MAP.get(gd.getType().getBinding());
                    if (geomType == null) {
                        geomType = "GEOMETRY";
                    }
                    StringBuilder sqlBuilder = new StringBuilder();
                    sqlBuilder.append("DELETE FROM ").append(this.geometryMetadataTable).append(" WHERE f_table_schema = '").append(schemaName).append("'").append(" AND f_table_name = '").append(tableName).append("'").append(" AND f_geometry_column = '").append(gd.getLocalName()).append("'");
                    LOGGER.fine(sqlBuilder.toString());
                    st.execute(sqlBuilder.toString());
                    sqlBuilder = new StringBuilder();
                    sqlBuilder.append("INSERT INTO ").append(this.geometryMetadataTable).append(" VALUES ('").append(schemaName).append("','").append(tableName).append("',").append("'").append(gd.getLocalName()).append("',").append(dimensions).append(",").append(srid).append(",").append("'").append(geomType).append("')");
                    LOGGER.fine(sqlBuilder.toString());
                    st.execute(sqlBuilder.toString());
                }
                Object bbox = null;
                if (gd.getCoordinateReferenceSystem() != null && (cs = (crs = gd.getCoordinateReferenceSystem()).getCoordinateSystem()).getDimension() == 2) {
                    CoordinateSystemAxis a0 = cs.getAxis(0);
                    CoordinateSystemAxis a1 = cs.getAxis(1);
                    bbox = "(";
                    bbox = (String)bbox + (Double.isInfinite(a0.getMinimumValue()) ? -1.0E7 : a0.getMinimumValue()) + ", ";
                    bbox = (String)bbox + (Double.isInfinite(a1.getMinimumValue()) ? -1.0E7 : a1.getMinimumValue()) + ", ";
                    bbox = (String)bbox + (Double.isInfinite(a0.getMaximumValue()) ? 1.0E7 : a0.getMaximumValue()) + ", ";
                    bbox = (String)bbox + (Double.isInfinite(a1.getMaximumValue()) ? 1.0E7 : a1.getMaximumValue());
                    bbox = (String)bbox + ")";
                }
                if (bbox == null) continue;
                StringBuffer sql = new StringBuffer("CREATE SPATIAL INDEX ");
                this.encodeTableName(featureType.getTypeName() + "_" + gd.getLocalName() + "_index", sql);
                sql.append(" ON ");
                this.encodeTableName(featureType.getTypeName(), sql);
                sql.append("(");
                this.encodeColumnName(null, gd.getLocalName(), sql);
                sql.append(")");
                sql.append(" WITH ( BOUNDING_BOX = ").append((String)bbox).append(")");
                LOGGER.fine(sql.toString());
                st.execute(sql.toString());
            }
            if (!cx.getAutoCommit()) {
                cx.commit();
            }
        }
        finally {
            this.dataStore.closeSafe(st);
        }
    }

    public Class<?> getMapping(ResultSet columnMetaData, Connection cx) throws SQLException {
        String typeName = columnMetaData.getString("TYPE_NAME");
        String gType = null;
        if (!"geometry".equalsIgnoreCase(typeName) || this.geometryMetadataTable == null) {
            return null;
        }
        gType = this.lookupGeometryType(columnMetaData, cx, this.geometryMetadataTable, "f_geometry_column");
        if (gType == null) {
            return Geometry.class;
        }
        Class<Geometry> geometryClass = TYPE_TO_CLASS_MAP.get(gType.toUpperCase());
        if (geometryClass == null) {
            geometryClass = Geometry.class;
        }
        return geometryClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String lookupGeometryType(ResultSet columnMetaData, Connection cx, String gTableName, String gColumnName) throws SQLException {
        ResultSet result;
        Statement statement;
        block7: {
            String string;
            block6: {
                String tableName = columnMetaData.getString("TABLE_NAME");
                String columnName = columnMetaData.getString("COLUMN_NAME");
                statement = null;
                result = null;
                try {
                    String schema = this.dataStore.getDatabaseSchema();
                    String sqlStatement = "SELECT TYPE FROM " + gTableName + " WHERE " + (String)(schema == null ? "" : "F_TABLE_SCHEMA = '" + this.dataStore.getDatabaseSchema() + "' AND ") + "F_TABLE_NAME = '" + tableName + "' AND " + gColumnName + " = '" + columnName + "'";
                    LOGGER.log(Level.FINE, "Geometry type check; {0} ", sqlStatement);
                    statement = cx.createStatement();
                    result = statement.executeQuery(sqlStatement);
                    if (result.next()) {
                        string = result.getString(1);
                        this.dataStore.closeSafe(result);
                        break block6;
                    }
                    this.dataStore.closeSafe(result);
                    break block7;
                }
                catch (SQLException e) {
                    String string2 = null;
                    return string2;
                }
            }
            this.dataStore.closeSafe(statement);
            return string;
        }
        this.dataStore.closeSafe(statement);
        return null;
        finally {
            this.dataStore.closeSafe(result);
            this.dataStore.closeSafe(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getGeometrySRIDfromMetadataTable(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        ResultSet result;
        Statement statement;
        block3: {
            Integer n;
            if (this.geometryMetadataTable == null) {
                return null;
            }
            statement = null;
            result = null;
            try {
                String schema = this.dataStore.getDatabaseSchema();
                String sql = "SELECT SRID FROM " + this.geometryMetadataTable + " WHERE " + (String)(schema == null ? "" : "F_TABLE_SCHEMA = '" + this.dataStore.getDatabaseSchema() + "' AND ") + "F_TABLE_NAME = '" + tableName + "' ";
                LOGGER.log(Level.FINE, "Geometry type check; {0} ", sql);
                statement = cx.createStatement();
                result = statement.executeQuery(sql);
                if (!result.next()) break block3;
                n = result.getInt(1);
            }
            catch (Throwable throwable) {
                this.dataStore.closeSafe(result);
                this.dataStore.closeSafe(statement);
                throw throwable;
            }
            this.dataStore.closeSafe(result);
            this.dataStore.closeSafe(statement);
            return n;
        }
        this.dataStore.closeSafe(result);
        this.dataStore.closeSafe(statement);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getGeometrySRID(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        Integer srid = this.getGeometrySRIDfromMetadataTable(schemaName, tableName, columnName, cx);
        if (srid != null) {
            return srid;
        }
        StringBuffer sql = new StringBuffer("SELECT TOP 1 ");
        this.encodeColumnName(null, columnName, sql);
        sql.append(".STSrid");
        sql.append(" FROM ");
        this.encodeTableName(schemaName, tableName, sql, true);
        sql.append(" WHERE ");
        this.encodeColumnName(null, columnName, sql);
        sql.append(" IS NOT NULL");
        this.dataStore.getLogger().fine(sql.toString());
        Statement st = cx.createStatement();
        try {
            ResultSet rs;
            block9: {
                Integer n;
                rs = st.executeQuery(sql.toString());
                try {
                    if (!rs.next()) break block9;
                    n = rs.getInt(1);
                }
                catch (Throwable throwable) {
                    this.dataStore.closeSafe(rs);
                    throw throwable;
                }
                this.dataStore.closeSafe(rs);
                return n;
            }
            Integer n = 0;
            this.dataStore.closeSafe(rs);
            return n;
        }
        finally {
            this.dataStore.closeSafe(st);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getGeometryDimensionFromMetadataTable(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        ResultSet result;
        Statement statement;
        block3: {
            Integer n;
            if (this.geometryMetadataTable == null) {
                return null;
            }
            statement = null;
            result = null;
            try {
                String schema = this.dataStore.getDatabaseSchema();
                String sql = "SELECT COORD_DIMENSION FROM " + this.geometryMetadataTable + " WHERE " + (String)(schema == null ? "" : "F_TABLE_SCHEMA = '" + this.dataStore.getDatabaseSchema() + "' AND ") + "F_TABLE_NAME = '" + tableName + "' ";
                LOGGER.log(Level.FINE, "Geometry dimension check; {0} ", sql);
                statement = cx.createStatement();
                result = statement.executeQuery(sql);
                if (!result.next()) break block3;
                n = result.getInt(1);
            }
            catch (Throwable throwable) {
                this.dataStore.closeSafe(result);
                this.dataStore.closeSafe(statement);
                throw throwable;
            }
            this.dataStore.closeSafe(result);
            this.dataStore.closeSafe(statement);
            return n;
        }
        this.dataStore.closeSafe(result);
        this.dataStore.closeSafe(statement);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getGeometryDimension(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        Integer dimension = this.getGeometryDimensionFromMetadataTable(schemaName, tableName, columnName, cx);
        if (dimension != null) {
            return dimension;
        }
        StringBuffer sql = new StringBuffer("SELECT TOP 1 ");
        this.encodeColumnName(null, columnName, sql);
        sql.append(".STPointN(1).Z");
        sql.append(" FROM ");
        this.encodeTableName(schemaName, tableName, sql, true);
        sql.append(" WHERE ");
        this.encodeColumnName(null, columnName, sql);
        sql.append(" IS NOT NULL");
        this.dataStore.getLogger().fine(sql.toString());
        Statement st = cx.createStatement();
        try {
            ResultSet rs;
            block9: {
                int n;
                rs = st.executeQuery(sql.toString());
                try {
                    if (!rs.next()) break block9;
                    Object z = rs.getObject(1);
                    n = z == null ? 2 : 3;
                }
                catch (Throwable throwable) {
                    this.dataStore.closeSafe(rs);
                    throw throwable;
                }
                this.dataStore.closeSafe(rs);
                return n;
            }
            int n = 2;
            this.dataStore.closeSafe(rs);
            return n;
        }
        finally {
            this.dataStore.closeSafe(st);
        }
    }

    public void encodeGeometryColumn(GeometryDescriptor gatt, String prefix, int srid, Hints hints, StringBuffer sql) {
        this.encodeColumnName(prefix, gatt.getLocalName(), sql);
        if (!this.useNativeSerialization.booleanValue()) {
            sql.append(".STAsBinary()");
        }
    }

    public void encodeGeometryValue(Geometry value, int dimension, int srid, StringBuffer sql) throws IOException {
        if (value == null) {
            sql.append("NULL");
            return;
        }
        GeometryDimensionFinder finder = new GeometryDimensionFinder();
        value.apply((GeometryComponentFilter)finder);
        WKTWriter2 writer = new WKTWriter2(finder.hasZ() ? 3 : 2);
        String wkt = writer.write(value);
        sql.append("geometry::STGeomFromText('").append(wkt).append("',").append(srid).append(")");
    }

    public Geometry decodeGeometryValue(GeometryDescriptor descriptor, ResultSet rs, String column, GeometryFactory factory, Connection cx, Hints hints) throws IOException, SQLException {
        byte[] bytes = rs.getBytes(column);
        if (bytes == null) {
            return null;
        }
        if (this.useNativeSerialization.booleanValue()) {
            try {
                return new SqlServerBinaryReader(factory).read(bytes);
            }
            catch (IOException e) {
                throw (IOException)new IOException().initCause(e);
            }
        }
        try {
            return new WKBReader(factory).read(bytes);
        }
        catch (ParseException e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    Geometry decodeGeometry(String s, GeometryFactory factory) throws IOException {
        if (s == null) {
            return null;
        }
        if (factory == null) {
            factory = new GeometryFactory();
        }
        String[] split = s.split(":");
        String srid = split[0];
        Geometry g = null;
        try {
            g = new WKTReader(factory).read(split[1]);
        }
        catch (ParseException e) {
            throw (IOException)new IOException().initCause(e);
        }
        if (srid != null && POSITIVE_NUMBER.matcher(srid).matches()) {
            CoordinateReferenceSystem crs;
            try {
                crs = CRS.decode((String)("EPSG:" + srid));
            }
            catch (Exception e) {
                throw (IOException)new IOException().initCause(e);
            }
            g.setUserData((Object)crs);
        }
        return g;
    }

    public void encodeGeometryEnvelope(String tableName, String geometryColumn, StringBuffer sql) {
        sql.append("CAST(");
        this.encodeColumnName(null, geometryColumn, sql);
        sql.append(".STSrid as VARCHAR)");
        sql.append(" + ':' + ");
        this.encodeColumnName(null, geometryColumn, sql);
        sql.append(".STEnvelope().ToString()");
    }

    public Envelope decodeGeometryEnvelope(ResultSet rs, int column, Connection cx) throws SQLException, IOException {
        String s = rs.getString(column);
        Geometry g = this.decodeGeometry(s, null);
        if (g == null) {
            return null;
        }
        return new ReferencedEnvelope(g.getEnvelopeInternal(), (CoordinateReferenceSystem)g.getUserData());
    }

    public FilterToSQL createFilterToSQL() {
        return new SQLServerFilterToSQL();
    }

    protected void encodeTableName(String schemaName, String tableName, StringBuffer sql, boolean escape) {
        if (schemaName != null) {
            if (escape) {
                this.encodeSchemaName(schemaName, sql);
            } else {
                sql.append(schemaName);
            }
            sql.append(".");
        }
        if (escape) {
            this.encodeTableName(tableName, sql);
        } else {
            sql.append(tableName);
        }
    }

    public boolean isLimitOffsetSupported() {
        return this.useOffsetLimit;
    }

    public void applyLimitOffset(StringBuffer sql, int limit, int offset) {
        if (offset == 0) {
            int idx = this.getAfterSelectInsertPoint(sql.toString());
            sql.insert(idx, " top " + limit);
        } else {
            CharSequence orderBy;
            int lastClosed = sql.lastIndexOf(")");
            int orderByIndex = sql.lastIndexOf("ORDER BY");
            if (orderByIndex > 0 && orderByIndex > lastClosed) {
                orderBy = sql.subSequence(orderByIndex, sql.length());
                sql.delete(orderByIndex, orderByIndex + orderBy.length());
            } else {
                orderBy = "ORDER BY CURRENT_TIMESTAMP";
            }
            Matcher fromMatcher = FROM_PATTERN.matcher(sql);
            fromMatcher.find();
            int fromStart = fromMatcher.start(2);
            sql.insert(fromStart - 1, ", ROW_NUMBER() OVER (" + orderBy + ") AS _GT_ROW_NUMBER ");
            sql.insert(0, "SELECT * FROM (");
            sql.append(") AS _GT_PAGING_SUBQUERY WHERE ");
            if (offset > 0) {
                sql.append("_GT_ROW_NUMBER > " + offset);
            }
            if (limit >= 0 && limit < Integer.MAX_VALUE) {
                int max = limit;
                if (offset > 0) {
                    max += offset;
                    sql.append(" AND ");
                }
                sql.append("_GT_ROW_NUMBER <= " + max);
            }
        }
    }

    int getAfterSelectInsertPoint(String sql) {
        int selectIndex = sql.toLowerCase().indexOf("select");
        int selectDistinctIndex = sql.toLowerCase().indexOf("select distinct");
        return selectIndex + (selectDistinctIndex == selectIndex ? 15 : 6);
    }

    public void encodeValue(Object value, Class type, StringBuffer sql) {
        if (byte[].class.equals((Object)type)) {
            byte[] b = (byte[])value;
            sql.append("0x");
            for (byte item : b) {
                sql.append(Integer.toString((item & 0xFF) + 256, 16).substring(1));
            }
        } else {
            super.encodeValue(value, type, sql);
        }
    }

    public String getGeometryMetadataTable() {
        return this.geometryMetadataTable;
    }

    public void setGeometryMetadataTable(String geometryMetadataTable) {
        this.geometryMetadataTable = geometryMetadataTable;
    }

    public void setUseOffSetLimit(Boolean useOffsetLimit) {
        this.useOffsetLimit = useOffsetLimit;
    }

    public void setUseNativeSerialization(Boolean useNativeSerialization) {
        this.useNativeSerialization = useNativeSerialization;
    }

    public void setForceSpatialIndexes(boolean forceSpatialIndexes) {
        this.forceSpatialIndexes = forceSpatialIndexes;
    }

    public void setTableHints(String tableHints) {
        this.tableHints = tableHints == null ? null : ((tableHints = tableHints.trim()).isEmpty() ? null : tableHints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropIndex(Connection cx, SimpleFeatureType schema, String databaseSchema, String indexName) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("DROP INDEX ");
        sql.append(this.escapeName(indexName));
        sql.append(" ON ");
        if (databaseSchema != null) {
            this.encodeSchemaName(databaseSchema, sql);
            sql.append(".");
        }
        sql.append(this.escapeName(schema.getTypeName()));
        Statement st = null;
        try {
            st = cx.createStatement();
            st.execute(sql.toString());
            if (!cx.getAutoCommit()) {
                cx.commit();
            }
        }
        finally {
            this.dataStore.closeSafe(st);
            this.dataStore.closeSafe(cx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCreateFeatureType(SimpleFeatureType featureType, DatabaseMetaData md, String databaseSchema, Connection cx) throws SQLException {
        String sql = "SELECT \n     index_name = ind.name,\n     column_name = col.name\nFROM \n     sys.indexes ind \nINNER JOIN \n     sys.index_columns ic ON  ind.object_id = ic.object_id and ind.index_id = ic.index_id \nINNER JOIN \n     sys.columns col ON ic.object_id = col.object_id and ic.column_id = col.column_id \nINNER JOIN \n     sys.tables t ON ind.object_id = t.object_id \nWHERE \n     ind.type_desc = 'SPATIAL'\n     and t.name = '" + featureType.getTypeName() + "'";
        ResultSet indexInfo = null;
        Statement st = null;
        HashMap<String, HashSet<String>> indexes = new HashMap<String, HashSet<String>>();
        try {
            st = cx.createStatement();
            indexInfo = st.executeQuery(sql);
            while (indexInfo.next()) {
                String indexName = indexInfo.getString("index_name");
                String columnName = indexInfo.getString("column_name");
                HashSet<String> indexColumns = (HashSet<String>)indexes.get(indexName);
                if (indexColumns == null) {
                    indexColumns = new HashSet<String>();
                    indexes.put(indexName, indexColumns);
                }
                indexColumns.add(columnName);
            }
        }
        finally {
            this.dataStore.closeSafe(st);
            this.dataStore.closeSafe(indexInfo);
        }
        for (Map.Entry entry : indexes.entrySet()) {
            String column;
            AttributeDescriptor descriptor;
            Set columns = (Set)entry.getValue();
            if (columns.size() != 1 || !((descriptor = featureType.getDescriptor(column = (String)columns.iterator().next())) instanceof GeometryDescriptor)) continue;
            descriptor.getUserData().put(SPATIAL_INDEX_KEY, entry.getKey());
        }
    }

    public void handleSelectHints(StringBuffer sql, SimpleFeatureType featureType, Query query) {
        if (!this.forceSpatialIndexes.booleanValue() && this.tableHints == null) {
            return;
        }
        String typeName = featureType.getTypeName();
        String schema = this.dataStore.getDatabaseSchema();
        String fromStatement = schema == null ? "FROM \"" + typeName + "\"" : "FROM \"" + schema + "\".\"" + typeName + "\"";
        int idx = sql.indexOf(fromStatement);
        if (idx > 0) {
            int base = idx + fromStatement.length();
            StringBuilder sb = new StringBuilder(" WITH(");
            Set<String> indexes = this.getSpatialIndexes(featureType, query);
            if (!indexes.isEmpty()) {
                sb.append("INDEX(");
                for (String indexName : indexes) {
                    sb.append("\"").append(indexName).append("\"").append(",");
                }
                sb.setLength(sb.length() - 1);
                sb.append(")");
            } else if (this.tableHints == null) {
                return;
            }
            if (!indexes.isEmpty() && this.tableHints != null) {
                sb.append(", ");
            }
            if (this.tableHints != null) {
                sb.append(this.tableHints);
            }
            sb.append(")");
            String tableHint = sb.toString();
            sql.insert(base, tableHint);
        }
    }

    private Set<String> getSpatialIndexes(SimpleFeatureType featureType, Query query) {
        if (!this.forceSpatialIndexes.booleanValue()) {
            return Collections.emptySet();
        }
        Filter filter = query.getFilter();
        if (filter == Filter.INCLUDE) {
            return Collections.emptySet();
        }
        SpatialIndexAttributeExtractor attributesExtractor = new SpatialIndexAttributeExtractor();
        filter.accept((FilterVisitor)attributesExtractor, null);
        Map<String, Integer> attributes = attributesExtractor.getSpatialProperties();
        if (attributes.isEmpty() || attributes.size() > 1) {
            return Collections.emptySet();
        }
        HashSet<String> indexes = new HashSet<String>();
        for (Map.Entry<String, Integer> attribute : attributes.entrySet()) {
            String indexName;
            AttributeDescriptor descriptor;
            if (attribute.getValue() > 1 || !((descriptor = featureType.getDescriptor(attribute.getKey())) instanceof GeometryDescriptor) || (indexName = (String)descriptor.getUserData().get(SPATIAL_INDEX_KEY)) == null) continue;
            indexes.add(indexName);
        }
        return indexes;
    }

    public boolean lookupGeneratedValuesPostInsert() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getLastAutoGeneratedValue(String schemaName, String tableName, String columnName, Connection cx, Statement st) throws SQLException {
        ResultSet rs = st.getGeneratedKeys();
        try {
            Object result = null;
            if (rs.next()) {
                result = rs.getObject(1);
            }
            Object object = result;
            return object;
        }
        finally {
            this.dataStore.closeSafe(rs);
        }
    }

    public void registerAggregateFunctions(Map<Class<? extends FeatureVisitor>, String> aggregates) {
        super.registerAggregateFunctions(aggregates);
        aggregates.put(StandardDeviationVisitor.class, "STDEVP");
    }

    public boolean canGroupOnGeometry() {
        return false;
    }

    public String encodeNextSequenceValue(String schemaName, String sequenceName) {
        return "NEXT VALUE FOR " + sequenceName;
    }

    public Object getNextSequenceValue(String schemaName, String sequenceName, Connection cx) throws SQLException {
        String sql = "SELECT " + this.encodeNextSequenceValue(schemaName, sequenceName);
        this.dataStore.getLogger().fine(sql);
        try (Statement st = cx.createStatement();){
            Object var7_9;
            block16: {
                ResultSet rs;
                block14: {
                    Long l;
                    block15: {
                        rs = st.executeQuery(sql);
                        try {
                            if (!rs.next()) break block14;
                            l = rs.getLong(1);
                            if (rs == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs.close();
                    }
                    return l;
                }
                var7_9 = null;
                if (rs == null) break block16;
                rs.close();
            }
            return var7_9;
        }
    }

    public List<ReferencedEnvelope> getOptimizedBounds(String schema, SimpleFeatureType featureType, Connection cx) throws SQLException {
        if (null != this.dataStore.getVirtualTables().get(featureType.getTypeName())) {
            return null;
        }
        if (!this.estimatedExtentsEnabled) {
            return null;
        }
        ArrayList<ReferencedEnvelope> result = new ArrayList<ReferencedEnvelope>();
        featureType.getAttributeDescriptors().stream().filter(attributeDescriptor -> attributeDescriptor instanceof GeometryDescriptor).forEach(attributeDescriptor -> {
            try {
                result.add(this.getIndexBounds(schema, featureType.getTypeName(), attributeDescriptor.getLocalName(), featureType.getGeometryDescriptor().getCoordinateReferenceSystem(), cx));
            }
            catch (SQLException e) {
                LOGGER.log(Level.WARNING, "Error while trying to get the optimized bounds for featuretype: " + featureType.getTypeName(), e);
                result.add(null);
            }
        });
        if (result.stream().allMatch(Objects::isNull)) {
            return null;
        }
        return result;
    }

    private ReferencedEnvelope getIndexBounds(String schema, String tableName, String columnName, CoordinateReferenceSystem crs, Connection cx) throws SQLException {
        StringBuffer sql = new StringBuffer("SELECT sit.bounding_box_xmin, sit.bounding_box_ymin, sit.bounding_box_xmax, sit.bounding_box_ymax FROM sys.indexes AS i INNER JOIN sys.index_columns AS ic ON i.object_id = ic.object_id AND i.index_id = ic.index_id INNER join sys.spatial_index_tessellations sit ON i.object_id = sit.object_id AND i.index_id = sit.index_id  WHERE i.[type] = 4 AND i.object_id = OBJECT_ID('");
        this.encodeTableName(schema, tableName, sql, true);
        sql.append("') AND ic.column_id = COLUMNPROPERTY(ic.object_id, '");
        sql.append(columnName).append("', 'COLUMNID');");
        LOGGER.log(Level.FINE, "Optimized bounds query: " + sql);
        try (Statement st = cx.createStatement();){
            ReferencedEnvelope referencedEnvelope;
            block20: {
                ResultSet rs;
                block18: {
                    ReferencedEnvelope referencedEnvelope2;
                    block19: {
                        block16: {
                            ReferencedEnvelope referencedEnvelope3;
                            block17: {
                                rs = st.executeQuery(sql.toString());
                                try {
                                    if (rs.next()) break block16;
                                    LOGGER.log(Level.INFO, "No spatial index found for table: " + tableName + ", column: " + columnName);
                                    referencedEnvelope3 = null;
                                    if (rs == null) break block17;
                                }
                                catch (Throwable throwable) {
                                    if (rs != null) {
                                        try {
                                            rs.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                rs.close();
                            }
                            return referencedEnvelope3;
                        }
                        if (null != rs.getObject(1) && null != rs.getObject(2) && null != rs.getObject(3) && null != rs.getObject(4)) break block18;
                        LOGGER.log(Level.INFO, "Spatial index bounds are null for table " + tableName + " column " + columnName);
                        referencedEnvelope2 = null;
                        if (rs == null) break block19;
                        rs.close();
                    }
                    return referencedEnvelope2;
                }
                referencedEnvelope = new ReferencedEnvelope(rs.getDouble(1), rs.getDouble(3), rs.getDouble(2), rs.getDouble(4), crs);
                if (rs == null) break block20;
                rs.close();
            }
            return referencedEnvelope;
        }
    }

    public boolean isEstimatedExtentsEnabled() {
        return this.estimatedExtentsEnabled;
    }

    public void setEstimatedExtentsEnabled(boolean estimatedExtentsEnabled) {
        this.estimatedExtentsEnabled = estimatedExtentsEnabled;
    }
}

