/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.sqlserver;

import java.util.HashMap;
import java.util.Map;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.filter.spatial.Beyond;
import org.geotools.api.filter.spatial.BinarySpatialOperator;
import org.geotools.api.filter.spatial.Contains;
import org.geotools.api.filter.spatial.Crosses;
import org.geotools.api.filter.spatial.DWithin;
import org.geotools.api.filter.spatial.Disjoint;
import org.geotools.api.filter.spatial.Equals;
import org.geotools.api.filter.spatial.Intersects;
import org.geotools.api.filter.spatial.Overlaps;
import org.geotools.api.filter.spatial.Touches;
import org.geotools.api.filter.spatial.Within;
import org.geotools.filter.visitor.DefaultFilterVisitor;

class SpatialIndexAttributeExtractor
extends DefaultFilterVisitor {
    Map<String, Integer> spatialProperties = new HashMap<String, Integer>();

    SpatialIndexAttributeExtractor() {
    }

    Map<String, Integer> getSpatialProperties() {
        return this.spatialProperties;
    }

    public Object visit(BBOX filter, Object extraData) {
        return this.visitBinarySpatialOperator((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Beyond filter, Object extraData) {
        return this.visitBinarySpatialOperator((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Contains filter, Object extraData) {
        return this.visitBinarySpatialOperator((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Crosses filter, Object extraData) {
        return this.visitBinarySpatialOperator((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Disjoint filter, Object extraData) {
        return null;
    }

    public Object visit(DWithin filter, Object extraData) {
        return this.visitBinarySpatialOperator((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Equals filter, Object extraData) {
        return this.visitBinarySpatialOperator((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Intersects filter, Object extraData) {
        return this.visitBinarySpatialOperator((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Overlaps filter, Object extraData) {
        return this.visitBinarySpatialOperator((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Touches filter, Object extraData) {
        return this.visitBinarySpatialOperator((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Within filter, Object extraData) {
        return this.visitBinarySpatialOperator((BinarySpatialOperator)filter, extraData);
    }

    protected Object visitBinarySpatialOperator(BinarySpatialOperator filter, Object extraData) {
        Expression ex1 = filter.getExpression1();
        Expression ex2 = filter.getExpression2();
        PropertyName pn = null;
        if (ex1 instanceof PropertyName && ex2 instanceof Literal) {
            pn = (PropertyName)ex1;
        } else if (ex1 instanceof Literal && ex2 instanceof PropertyName) {
            pn = (PropertyName)ex2;
        }
        if (pn != null) {
            String name = pn.getPropertyName();
            if (this.spatialProperties.containsKey(name)) {
                Integer count = this.spatialProperties.get(name);
                this.spatialProperties.put(name, count + 1);
            } else {
                this.spatialProperties.put(name, 1);
            }
        }
        return null;
    }
}

