/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.maven;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.compiler.util.scan.InclusionScanException;
import org.codehaus.plexus.compiler.util.scan.StaleSourceScanner;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;
import org.codehaus.plexus.compiler.util.scan.mapping.SuffixMapping;
import org.codehaus.plexus.util.FileUtils;
import org.javacc.jjtree.JJTree;
import org.javacc.parser.Main;

public class JJTreeJavaCC
extends AbstractMojo {
    private String nodePackage;
    private String nodeDirectory;
    private String sourceDirectory;
    private String outputDirectory;
    private File outputPackageDirectory;
    private String timestampDirectory;
    private int staleMillis;
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        int status;
        String[] args;
        boolean windowsOs = System.getProperty("os.name").indexOf("Windows") != -1;
        this.outputPackageDirectory = this.createPackageDirectory(this.outputDirectory);
        if (!FileUtils.fileExists((String)this.timestampDirectory)) {
            FileUtils.mkdir((String)this.timestampDirectory);
        }
        Set userNodes = this.searchNodeFiles();
        for (File nodeFile : userNodes) {
            try {
                FileUtils.copyFileToDirectory((File)nodeFile, (File)this.outputPackageDirectory);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to copy Node.java files for JJTree.", (Exception)e);
            }
        }
        Set staleTrees = this.searchStaleGrammars(new File(this.sourceDirectory), ".jjt");
        Iterator it = staleTrees.iterator();
        while (it.hasNext()) {
            JJTree parser = new JJTree();
            File sourceFile = (File)it.next();
            args = this.generateJJTreeArgumentList(sourceFile.getPath());
            status = parser.main(args);
            if (status != 0) {
                throw new MojoFailureException("JJTree failed with error code " + status + '.');
            }
            try {
                FileUtils.copyFileToDirectory((File)sourceFile, (File)new File(this.timestampDirectory));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to copy processed .jjt file.", (Exception)e);
            }
        }
        Set staleGrammars = this.searchStaleGrammars(new File(this.outputDirectory), ".jj");
        for (File sourceFile : staleGrammars) {
            try {
                if (windowsOs) {
                    this.fixHeader(sourceFile);
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to fix header for .jj file.", (Exception)e);
            }
            args = this.generateJavaCCArgumentList(sourceFile.getPath());
            try {
                status = Main.mainProgram((String[])args);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failed to run javacc.", e);
            }
            if (status != 0) {
                throw new MojoFailureException("JavaCC failed with error code " + status + '.');
            }
            try {
                FileUtils.copyFileToDirectory((File)sourceFile, (File)new File(this.timestampDirectory));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to copy processed .jj file.", (Exception)e);
            }
        }
        if (windowsOs) {
            try {
                String[] files = FileUtils.getFilesFromExtension((String)this.outputDirectory, (String[])new String[]{"java"});
                for (int i = 0; i < files.length; ++i) {
                    System.out.println("Fixing " + files[i]);
                    this.fixHeader(new File(files[i]));
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to fix header for java file.", (Exception)e);
            }
        }
        if (this.project != null) {
            this.project.addCompileSourceRoot(this.outputDirectory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fixHeader(File sourceFile) throws IOException {
        BufferedReader reader = null;
        BufferedWriter writer = null;
        File fixedFile = new File(sourceFile.getParentFile(), sourceFile.getName() + ".fix");
        try {
            String line;
            reader = new BufferedReader(new FileReader(sourceFile));
            writer = new BufferedWriter(new FileWriter(fixedFile));
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("/*@bgen(jjtree) Generated By:JJTree:") || line.startsWith("/* Generated By:JJTree:")) {
                    line = line.replace('\\', '/');
                }
                writer.write(line);
                writer.newLine();
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
        sourceFile.delete();
        fixedFile.renameTo(sourceFile);
    }

    private File createPackageDirectory(String directory) throws MojoExecutionException {
        File packageDirectory = new File(directory);
        if (this.nodePackage != null && this.nodePackage.trim().length() != 0 && !(packageDirectory = new File(packageDirectory, this.nodePackage.replace('.', '/'))).exists() && !packageDirectory.mkdirs()) {
            throw new MojoExecutionException("Failed to create the destination directory.");
        }
        return packageDirectory;
    }

    private Set searchNodeFiles() throws MojoExecutionException {
        SuffixMapping mapping = new SuffixMapping(".java", ".java");
        SuffixMapping mappingCAP = new SuffixMapping(".JAVA", ".JAVA");
        StaleSourceScanner scanner = new StaleSourceScanner((long)this.staleMillis);
        scanner.addSourceMapping((SourceMapping)mapping);
        scanner.addSourceMapping((SourceMapping)mappingCAP);
        File directory = new File(this.nodeDirectory);
        if (this.nodePackage != null && this.nodePackage.trim().length() != 0) {
            directory = new File(directory, this.nodePackage.replace('.', '/'));
        }
        if (!directory.isDirectory()) {
            return Collections.EMPTY_SET;
        }
        File outDir = new File(this.timestampDirectory);
        try {
            return scanner.getIncludedSources(directory, outDir);
        }
        catch (InclusionScanException e) {
            throw new MojoExecutionException("Error scanning \"" + directory.getPath() + "\" for Node.java to copy.", (Exception)((Object)e));
        }
    }

    private Set searchStaleGrammars(File sourceDir, String ext) throws MojoExecutionException {
        String extCAP = ext.toUpperCase();
        SuffixMapping mapping = new SuffixMapping(ext, ext);
        SuffixMapping mappingCAP = new SuffixMapping(extCAP, extCAP);
        StaleSourceScanner scanner = new StaleSourceScanner((long)this.staleMillis);
        scanner.addSourceMapping((SourceMapping)mapping);
        scanner.addSourceMapping((SourceMapping)mappingCAP);
        File outDir = new File(this.timestampDirectory);
        try {
            return scanner.getIncludedSources(sourceDir, outDir);
        }
        catch (InclusionScanException e) {
            throw new MojoExecutionException("Error scanning source root \"" + sourceDir.getPath() + "\" for stale grammars to reprocess.", (Exception)((Object)e));
        }
    }

    private String[] generateJJTreeArgumentList(String sourceFilename) {
        ArrayList<String> argsList = new ArrayList<String>();
        if (this.nodePackage != null && this.nodePackage.trim().length() != 0) {
            argsList.add("-NODE_PACKAGE:" + this.nodePackage);
        }
        argsList.add("-OUTPUT_DIRECTORY:" + this.outputPackageDirectory.getPath());
        argsList.add(sourceFilename);
        this.getLog().debug((CharSequence)("jjtree arguments list: " + ((Object)argsList).toString()));
        return argsList.toArray(new String[argsList.size()]);
    }

    private String[] generateJavaCCArgumentList(String sourceInput) {
        ArrayList<String> argsList = new ArrayList<String>();
        argsList.add("-OUTPUT_DIRECTORY:" + this.outputPackageDirectory.getPath());
        argsList.add(sourceInput);
        this.getLog().debug((CharSequence)("javacc arguments list: " + ((Object)argsList).toString()));
        return argsList.toArray(new String[argsList.size()]);
    }
}

