/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.maven.xmlcodegen;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.eclipse.xsd.XSDSchema;
import org.geotools.maven.xmlcodegen.AbstractGeneratorMojo;
import org.geotools.maven.xmlcodegen.BindingConstructorArgument;
import org.geotools.maven.xmlcodegen.BindingGenerator;

public class BindingGeneratorMojo
extends AbstractGeneratorMojo {
    boolean generateConfiguration;
    boolean generateXsd;
    boolean generateAttributeBindings;
    boolean generateElementBindings;
    boolean generateTypeBindings;
    boolean generateTests;
    BindingConstructorArgument[] bindingConstructorArguments;
    String complexBindingBaseClass;
    String simpleBindingBaseClass;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Class<?> c;
        XSDSchema xsdSchema = this.schema();
        if (xsdSchema == null) {
            return;
        }
        BindingGenerator generator = new BindingGenerator();
        generator.setGenerateAttributes(this.generateAttributeBindings);
        generator.setGenerateElements(this.generateElementBindings);
        generator.setGenerateTypes(this.generateTypeBindings);
        generator.setGenerateConfiguration(this.generateConfiguration);
        generator.setGenerateXsd(this.generateXsd);
        generator.setGenerateTests(this.generateTests);
        generator.setOverwriting(this.overwriteExistingFiles);
        generator.setSourceLocation(this.sourceOutputDirectory.getAbsolutePath());
        generator.setTestLocation(this.testOutputDirectory.getAbsolutePath());
        generator.setResourceLocation(((Resource)this.project.getBuild().getResources().get(0)).getDirectory());
        generator.setSchemaSourceDirectory(this.schemaSourceDirectory);
        try {
            c = Class.forName(this.complexBindingBaseClass);
            generator.setComplexBindingBaseClass(c);
        }
        catch (ClassNotFoundException e) {
            this.getLog().error((CharSequence)("Could not load class: " + this.complexBindingBaseClass));
            return;
        }
        try {
            c = Class.forName(this.simpleBindingBaseClass);
            generator.setSimpleBindingBaseClass(c);
        }
        catch (ClassNotFoundException e) {
            this.getLog().error((CharSequence)("Could not load class: " + this.simpleBindingBaseClass));
            return;
        }
        if (this.schemaLookupDirectories != null) {
            generator.setSchemaLookupDirectories(this.schemaLookupDirectories);
        }
        if (this.destinationPackage != null) {
            generator.setPackageBase(this.destinationPackage);
        }
        HashSet<URL> urls = new HashSet<URL>();
        try {
            List l = this.project.getCompileClasspathElements();
            for (Object item : l) {
                String element = (String)item;
                File d = new File(element);
                if (!d.exists() || !d.isDirectory()) continue;
                urls.add(d.toURI().toURL());
            }
            List d = this.project.getDependencies();
            for (Object value : d) {
                Dependency dep = (Dependency)value;
                if (!"jar".equals(dep.getType())) continue;
                Artifact artifact = this.artifactFactory.createArtifact(dep.getGroupId(), dep.getArtifactId(), dep.getVersion(), dep.getScope(), dep.getType());
                Set artifacts = this.project.createArtifacts(this.artifactFactory, null, null);
                ArtifactResolutionResult result = this.artifactResolver.resolveTransitively(artifacts, artifact, this.remoteRepositories, this.localRepository, this.artifactMetadataSource);
                artifacts = result.getArtifacts();
                for (Object o : artifacts) {
                    Artifact dartifact = (Artifact)o;
                    urls.add(dartifact.getFile().toURI().toURL());
                }
            }
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
            return;
        }
        URLClassLoader cl = new URLClassLoader(urls.toArray(new URL[urls.size()]));
        if (this.bindingConstructorArguments != null) {
            HashMap map = new HashMap();
            for (BindingConstructorArgument bindingConstructorArgument : this.bindingConstructorArguments) {
                String name = bindingConstructorArgument.getName();
                String type = bindingConstructorArgument.getType();
                try {
                    bindingConstructorArgument.clazz = cl.loadClass(type);
                }
                catch (ClassNotFoundException e) {
                    this.getLog().error((CharSequence)("Could not locate class:" + type));
                    return;
                }
            }
            generator.setBindingConstructorArguments(this.bindingConstructorArguments);
        }
        if (this.includes != null && this.includes.length > 0) {
            HashSet<String> included = new HashSet<String>(Arrays.asList(this.includes));
            this.getLog().info((CharSequence)("Including: " + included));
            generator.setIncluded(included);
        }
        this.getLog().info((CharSequence)"Generating bindings...");
        generator.generate(xsdSchema);
    }
}

