/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.maven.xmlcodegen;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.eclipse.xsd.XSDSchema;
import org.geotools.api.feature.type.Schema;
import org.geotools.maven.xmlcodegen.AbstractGeneratorMojo;
import org.geotools.maven.xmlcodegen.CycleSchemaGenerator;
import org.geotools.maven.xmlcodegen.SchemaGenerator;
import org.geotools.maven.xmlcodegen.TypeBinding;

public class SchemaGeneratorMojo
extends AbstractGeneratorMojo {
    boolean includeComplexTypes;
    boolean includeSimpleTypes;
    boolean followComplexTypes;
    String[] imports;
    boolean printRecursionPaths;
    int maxRecursionDepth;
    private TypeBinding[] typeBindings;
    boolean cyclicTypeSupport;

    public void execute() throws MojoExecutionException, MojoFailureException {
        XSDSchema schema = this.schema();
        if (schema == null) {
            return;
        }
        SchemaGenerator generator = this.cyclicTypeSupport ? new CycleSchemaGenerator(schema) : new SchemaGenerator(schema);
        generator.setComplexTypes(this.includeComplexTypes);
        generator.setSimpleTypes(this.includeSimpleTypes);
        generator.setOverwriting(this.overwriteExistingFiles);
        generator.setSourceLocation(this.sourceOutputDirectory.getAbsolutePath());
        generator.setTestLocation(this.testOutputDirectory.getAbsolutePath());
        generator.setResourceLocation(((Resource)this.project.getBuild().getResources().get(0)).getDirectory());
        generator.setFollowComplexTypes(this.followComplexTypes);
        generator.setIncludes(this.includes);
        generator.setMaxRecursionDepth(this.maxRecursionDepth);
        generator.setPrintRecursionPaths(this.printRecursionPaths);
        generator.setTypeBindings(this.typeBindings);
        if (this.imports != null) {
            ArrayList<URL> urls = new ArrayList<URL>();
            for (Object o : this.project.getDependencies()) {
                Dependency dep = (Dependency)o;
                Artifact artifact = this.artifactFactory.createArtifact(dep.getGroupId(), dep.getArtifactId(), dep.getVersion(), null, dep.getType());
                try {
                    this.artifactResolver.resolve(artifact, this.remoteRepositories, this.localRepository);
                    urls.add(artifact.getFile().toURI().toURL());
                }
                catch (Exception e) {
                    this.getLog().error((CharSequence)("Unable to resolve " + artifact.getId()));
                }
            }
            try {
                urls.add(new File(this.project.getBuild().getOutputDirectory()).toURI().toURL());
            }
            catch (MalformedURLException e) {
                this.getLog().error((CharSequence)("Bad url: " + this.project.getBuild().getOutputDirectory()));
                return;
            }
            URLClassLoader ext = new URLClassLoader(urls.toArray(new URL[urls.size()]), ((Object)((Object)this)).getClass().getClassLoader());
            for (String schemaClassName : this.imports) {
                Class<?> schemaClass = null;
                try {
                    schemaClass = ext.loadClass(schemaClassName);
                }
                catch (ClassNotFoundException e) {
                    this.getLog().error((CharSequence)("Could note load class: " + schemaClassName));
                    return;
                }
                this.getLog().info((CharSequence)("Loading import schema: " + schemaClassName));
                Schema gtSchema = null;
                try {
                    gtSchema = (Schema)schemaClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    this.getLog().error((CharSequence)("Could not insantiate class: " + schemaClass.getName()));
                    return;
                }
                if (gtSchema == null) continue;
                generator.addImport(gtSchema);
            }
        }
        try {
            generator.generate();
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
        }
    }
}

