/*
 *    GeoTools - The Open Source Java GIS Toolkit
 *    http://geotools.org
 *
 *    (C) 2002-2008, Open Source Geospatial Foundation (OSGeo)
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation;
 *    version 2.1 of the License.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 */
package org.geotools.xs.bindings;

import javax.xml.namespace.QName;
import org.geotools.xs.XS;
import org.geotools.xsd.AbstractComplexBinding;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.Node;
import org.picocontainer.MutablePicoContainer;

/**
 * Binding object for the type http://www.w3.org/2001/XMLSchema:element.
 *
 * <p>
 *
 * <pre>
 *         <code>
 *  &lt;xs:complexType name="element" abstract="true"&gt;
 *      &lt;xs:annotation&gt;
 *          &lt;xs:documentation&gt;    The element element can be used either
 *              at the top level to define an element-type binding globally,
 *              or within a content model to either reference a
 *              globally-defined    element or type or declare an
 *              element-type binding locally.    The ref form is not allowed
 *              at the top level.&lt;/xs:documentation&gt;
 *      &lt;/xs:annotation&gt;
 *      &lt;xs:complexContent&gt;
 *          &lt;xs:extension base="xs:annotated"&gt;
 *              &lt;xs:sequence&gt;
 *                  &lt;xs:choice minOccurs="0"&gt;
 *                      &lt;xs:element name="simpleType" type="xs:localSimpleType"/&gt;
 *                      &lt;xs:element name="complexType" type="xs:localComplexType"/&gt;
 *                  &lt;/xs:choice&gt;
 *                  &lt;xs:group ref="xs:identityConstraint" minOccurs="0" maxOccurs="unbounded"/&gt;
 *              &lt;/xs:sequence&gt;
 *              &lt;xs:attributeGroup ref="xs:defRef"/&gt;
 *              &lt;xs:attribute name="type" type="xs:QName"/&gt;
 *              &lt;xs:attribute name="substitutionGroup" type="xs:QName"/&gt;
 *              &lt;xs:attributeGroup ref="xs:occurs"/&gt;
 *              &lt;xs:attribute name="default" type="xs:string"/&gt;
 *              &lt;xs:attribute name="fixed" type="xs:string"/&gt;
 *              &lt;xs:attribute name="nillable" type="xs:boolean"
 *                  use="optional" default="false"/&gt;
 *              &lt;xs:attribute name="abstract" type="xs:boolean"
 *                  use="optional" default="false"/&gt;
 *              &lt;xs:attribute name="final" type="xs:derivationSet"/&gt;
 *              &lt;xs:attribute name="block" type="xs:blockSet"/&gt;
 *              &lt;xs:attribute name="form" type="xs:formChoice"/&gt;
 *          &lt;/xs:extension&gt;
 *      &lt;/xs:complexContent&gt;
 *  &lt;/xs:complexType&gt;
 *
 *          </code>
 *         </pre>
 *
 * @generated
 */
public class XSElementBinding extends AbstractComplexBinding {
    /** @generated */
    @Override
    public QName getTarget() {
        return XS.ELEMENT;
    }

    /**
     *
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * @generated modifiable
     */
    @Override
    public int getExecutionMode() {
        return AFTER;
    }

    /**
     *
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * @generated modifiable
     */
    @Override
    public Class getType() {
        return null;
    }

    /**
     *
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * @generated modifiable
     */
    @Override
    public void initialize(ElementInstance instance, Node node, MutablePicoContainer context) {}

    /**
     *
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * @generated modifiable
     */
    @Override
    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        // TODO: implement
        return null;
    }
}
