/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xs.bindings;

import java.math.BigDecimal;
import junit.framework.TestCase;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDMaxExclusiveFacet;
import org.eclipse.xsd.XSDMaxInclusiveFacet;
import org.eclipse.xsd.XSDMinExclusiveFacet;
import org.eclipse.xsd.XSDMinInclusiveFacet;
import org.eclipse.xsd.XSDTotalDigitsFacet;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.impl.XSDElementDeclarationImpl;
import org.eclipse.xsd.impl.XSDMaxExclusiveFacetImpl;
import org.eclipse.xsd.impl.XSDMaxInclusiveFacetImpl;
import org.eclipse.xsd.impl.XSDMinExclusiveFacetImpl;
import org.eclipse.xsd.impl.XSDMinInclusiveFacetImpl;
import org.eclipse.xsd.impl.XSDSimpleTypeDefinitionImpl;
import org.eclipse.xsd.impl.XSDTotalDigitsFacetImpl;
import org.geotools.xs.bindings.XSDecimalBinding;
import org.geotools.xsd.InstanceComponent;
import org.geotools.xsd.Node;
import org.geotools.xsd.impl.ElementImpl;

public class XSDecimalStrategyTest
extends TestCase {
    public void testParse() throws Exception {
        this.validateValues("50", 5, 0.0, 0.0, 100.0, 100.0);
        this.validateValues("50", 3, 49.0, 50.0, 50.0, 51.0);
        this.validateValues("50.0", 3, 49.0, 50.0, 51.0, 52.0);
        this.validateValues("50.8", 4, 49.0, 50.0, 51.0, 52.0);
        this.validateValues("51.0", 4, 49.0, 50.0, 51.0, 52.0);
    }

    public void validateValues(String elementText, int totalDigits, double minExc, double minInc, double maxInc, double maxExc) throws Exception {
        XSDecimalBinding strat = new XSDecimalBinding();
        XSDElementDeclaration declaration = this.makeDeclaration(totalDigits, new BigDecimal(minExc), new BigDecimal(minInc), new BigDecimal(maxInc), new BigDecimal(maxExc));
        ElementImpl element = new ElementImpl(declaration);
        element.setText(elementText);
        Node[] children = new Node[]{};
        Object value = null;
        BigDecimal decimal = (BigDecimal)strat.parse((InstanceComponent)element, (Object)element.getText().trim());
        XSDecimalStrategyTest.assertNotNull((Object)decimal);
    }

    private XSDElementDeclaration makeDeclaration(final int digits, final BigDecimal minExc, final BigDecimal minInc, final BigDecimal maxInc, final BigDecimal maxExc) {
        return new XSDElementDeclarationImpl(){

            public XSDTypeDefinition getTypeDefinition() {
                return new XSDSimpleTypeDefinitionImpl(){

                    public XSDTotalDigitsFacet getTotalDigitsFacet() {
                        return new XSDTotalDigitsFacetImpl(){

                            public int getValue() {
                                return digits;
                            }
                        };
                    }

                    public XSDMinInclusiveFacet getMinInclusiveFacet() {
                        return new XSDMinInclusiveFacetImpl(){

                            public Object getValue() {
                                return minInc;
                            }
                        };
                    }

                    public XSDMinExclusiveFacet getMinExclusiveFacet() {
                        return new XSDMinExclusiveFacetImpl(){

                            public Object getValue() {
                                return minExc;
                            }
                        };
                    }

                    public XSDMaxInclusiveFacet getMaxInclusiveFacet() {
                        return new XSDMaxInclusiveFacetImpl(){

                            public Object getValue() {
                                return maxInc;
                            }
                        };
                    }

                    public XSDMaxExclusiveFacet getMaxExclusiveFacet() {
                        return new XSDMaxExclusiveFacetImpl(){

                            public Object getValue() {
                                return maxExc;
                            }
                        };
                    }
                };
            }
        };
    }
}

