/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xs.bindings;

import javax.xml.namespace.QName;
import org.geotools.xs.TestSchema;
import org.geotools.xs.XS;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.InstanceComponent;

public class XSDoubleStrategyTest
extends TestSchema {
    public void testParse() throws Exception {
        this.validateValues("-1E4", -10000.0);
        this.validateValues("1267.43233E12", 1.26743233E15);
        this.validateValues("12.78e-2", 0.1278);
        this.validateValues("12", 12.0);
        this.validateValues("-0", Double.valueOf("-0"));
        this.validateValues("0", 0.0);
        ElementInstance element = this.element("INF", XS.DOUBLE);
        XSDoubleStrategyTest.assertEquals((Object)Double.POSITIVE_INFINITY, (Object)this.strategy.parse((InstanceComponent)element, (Object)"INF"));
    }

    public void testIntegerParse() throws Exception {
        ElementInstance element = this.element("12345", XS.INTEGER);
        XSDoubleStrategyTest.assertEquals((Object)12345.0, (Object)this.strategy.parse((InstanceComponent)element, (Object)"12345"));
    }

    @Override
    protected QName getQName() {
        return XS.DOUBLE;
    }
}

