/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xsd;

import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.TestCase;
import org.geotools.xs.XSConfiguration;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.DOMParser;
import org.w3c.dom.Document;

public class FacetTest
extends TestCase {
    public void testList() throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(((Object)((Object)this)).getClass().getResourceAsStream("list.xml"));
        String schemaLocation = "http://geotools.org/test " + ((Object)((Object)this)).getClass().getResource("facets.xsd").getFile();
        doc.getDocumentElement().setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", schemaLocation);
        DOMParser parser = new DOMParser((Configuration)new XSConfiguration(), doc);
        Object o = parser.parse();
        FacetTest.assertTrue((boolean)(o instanceof List));
        List list = (List)o;
        FacetTest.assertEquals((int)3, (int)list.size());
        FacetTest.assertEquals((Object)1, list.get(0));
        FacetTest.assertEquals((Object)2, list.get(1));
        FacetTest.assertEquals((Object)3, list.get(2));
    }

    public void testWhitespace() throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(((Object)((Object)this)).getClass().getResourceAsStream("whitespace.xml"));
        String schemaLocation = "http://geotools.org/test " + ((Object)((Object)this)).getClass().getResource("facets.xsd").getFile();
        doc.getDocumentElement().setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", schemaLocation);
        DOMParser parser = new DOMParser((Configuration)new XSConfiguration(), doc);
        String s = (String)parser.parse();
        FacetTest.assertEquals((String)"this is a normal string with some whitespace and some new lines", (String)s);
    }

    public void testCDATAWhitespace() throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(((Object)((Object)this)).getClass().getResourceAsStream("whitespace-cdata.xml"));
        String schemaLocation = "http://geotools.org/test " + ((Object)((Object)this)).getClass().getResource("facets.xsd").getFile();
        doc.getDocumentElement().setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", schemaLocation);
        DOMParser parser = new DOMParser((Configuration)new XSConfiguration(), doc);
        String s = (String)parser.parse();
        FacetTest.assertEquals((String)" this is a \n normal string \n with some whitespace and \n some new lines", (String)s);
    }
}

