/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xsd;

import java.awt.RenderingHints;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import junit.framework.TestCase;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.util.XSDSchemaLocationResolver;
import org.geotools.util.NullEntityResolver;
import org.geotools.util.PreventLocalEntityResolver;
import org.geotools.util.factory.Hints;
import org.geotools.xs.XS;
import org.geotools.xsd.SchemaLocationResolver;
import org.geotools.xsd.Schemas;
import org.geotools.xsd.impl.HTTPURIHandler;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.xml.sax.EntityResolver;

public class SchemasTest
extends TestCase {
    File tmp;
    File sub;
    private ExecutorService executorService = Executors.newSingleThreadExecutor();

    protected void setUp() throws Exception {
        super.setUp();
        Hints.putSystemDefault((RenderingHints.Key)Hints.ENTITY_RESOLVER, (Object)NullEntityResolver.INSTANCE);
        this.tmp = File.createTempFile("schemas", "xsd");
        this.tmp.delete();
        this.tmp.mkdir();
        this.tmp.deleteOnExit();
        this.sub = new File(this.tmp, "sub");
        this.sub.mkdir();
        this.sub.deleteOnExit();
        File f = new File(this.tmp, "root.xsd");
        String xsd = "<xsd:schema xmlns='http://geotools.org/test' xmlns:xsd='http://www.w3.org/2001/XMLSchema' targetNamespace='http://geotools.org/test'> <xsd:import namespace='http://geotools/org/import1' schemaLocation='import1.xsd'/><xsd:import namespace='http://geotools/org/import2' schemaLocation='import2.xsd'/><xsd:include location='include1.xsd'/><xsd:include location='include2.xsd'/></xsd:schema>";
        this.write(f, xsd);
        f = new File(this.tmp, "import1.xsd");
        xsd = "<xsd:schema xmlns='http://geotools.org/import1' xmlns:xsd='http://www.w3.org/2001/XMLSchema' targetNamespace='http://geotools.org/import1'> </xsd:schema>";
        this.write(f, xsd);
        f = new File(this.sub, "import2.xsd");
        xsd = "<xsd:schema xmlns='http://geotools.org/import2' xmlns:xsd='http://www.w3.org/2001/XMLSchema' targetNamespace='http://geotools.org/import2'> </xsd:schema>";
        this.write(f, xsd);
        f = new File(this.tmp, "include1.xsd");
        xsd = "<xsd:schema xmlns='http://geotools.org/test' xmlns:xsd='http://www.w3.org/2001/XMLSchema' targetNamespace='http://geotools.org/test'> </xsd:schema>";
        this.write(f, xsd);
        f = new File(this.sub, "include2.xsd");
        xsd = "<xsd:schema xmlns='http://geotools.org/test' xmlns:xsd='http://www.w3.org/2001/XMLSchema' targetNamespace='http://geotools.org/test'> </xsd:schema>";
        this.write(f, xsd);
        f = new File(this.sub, "test.xsd");
        xsd = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\n           targetNamespace=\"http://geotools.org/test\"\n           xmlns=\"http://geotools.org/test\"\n           elementFormDefault=\"qualified\">\n  <xs:element name=\"root\" type=\"xs:anyType\"/>\n</xs:schema>";
        this.write(f, xsd);
        System.setProperty("org.geotools.xml.forceSchemaImport", "false");
    }

    void write(File f, String xsd) throws IOException {
        f.deleteOnExit();
        f.createNewFile();
        FileWriter w = new FileWriter(f);
        w.write(xsd);
        w.flush();
        w.close();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        new File(this.tmp, "root.xsd").delete();
        new File(this.tmp, "import1.xsd").delete();
        new File(this.sub, "import2.xsd").delete();
        new File(this.tmp, "include1.xsd").delete();
        new File(this.sub, "include2.xsd").delete();
        this.sub.delete();
        this.tmp.delete();
        System.setProperty("org.geotools.xml.forceSchemaImport", "false");
        this.executorService.shutdown();
    }

    public void testValidateImportsIncludes() throws Exception {
        String location = new File(this.tmp, "root.xsd").getAbsolutePath();
        List errors = Schemas.validateImportsIncludes((String)location);
        SchemasTest.assertEquals((int)2, (int)errors.size());
        SchemaLocationResolver resolver1 = new SchemaLocationResolver(XS.getInstance()){

            public boolean canHandle(XSDSchema schema, String uri, String location) {
                return location.endsWith("import2.xsd");
            }

            public String resolveSchemaLocation(XSDSchema schema, String uri, String location) {
                return new File(SchemasTest.this.sub, "import2.xsd").getAbsolutePath();
            }
        };
        SchemaLocationResolver resolver2 = new SchemaLocationResolver(XS.getInstance()){

            public boolean canHandle(XSDSchema schema, String uri, String location) {
                return location.endsWith("include2.xsd");
            }

            public String resolveSchemaLocation(XSDSchema schema, String uri, String location) {
                return new File(SchemasTest.this.sub, "include2.xsd").getAbsolutePath();
            }
        };
        errors = Schemas.validateImportsIncludes((String)location, null, (XSDSchemaLocationResolver[])new XSDSchemaLocationResolver[]{resolver1, resolver2});
        SchemasTest.assertEquals((int)0, (int)errors.size());
    }

    public void testImportsOnly() throws IOException {
        XSDSchema schema = Schemas.parse((String)Schemas.class.getResource("importFacetsEmpty.xsd").toString());
        SchemasTest.assertNotNull((Object)schema);
        boolean elFound = this.hasElement(schema, "collapsedString");
        SchemasTest.assertTrue((boolean)elFound);
    }

    public void testForcedSchemaImport() throws IOException {
        XSDSchema schema = Schemas.parse((String)Schemas.class.getResource("importFacetsNotEmpty.xsd").toString());
        SchemasTest.assertNotNull((Object)schema);
        boolean elFound = this.hasElement(schema, "collapsedString");
        SchemasTest.assertFalse((boolean)elFound);
        System.setProperty("org.geotools.xml.forceSchemaImport", "true");
        schema = Schemas.parse((String)Schemas.class.getResource("importFacetsNotEmpty.xsd").toString());
        SchemasTest.assertNotNull((Object)schema);
        elFound = this.hasElement(schema, "collapsedString");
        SchemasTest.assertTrue((boolean)elFound);
    }

    private boolean hasElement(XSDSchema schema, String elQName) {
        boolean elFound = false;
        EList elDeclList = schema.getElementDeclarations();
        for (XSDElementDeclaration elDecl : elDeclList) {
            if (!elQName.equals(elDecl.getQName())) continue;
            elFound = true;
        }
        return elFound;
    }

    public void testParseRemoteDoesNotBlock() throws IOException {
        ExtensibleURIConverterImpl converter = new ExtensibleURIConverterImpl(Collections.singletonList(new MockServerBehaviour()), Collections.emptyList());
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.setURIConverter((URIConverter)converter);
        XSDSchema schema = Schemas.parse((String)"http://www.foo.bar/remoteSchemaLocation.xsd", (ResourceSet)resourceSet);
        SchemasTest.assertNotNull((Object)schema);
    }

    @Test
    public void testEntityResolverDisallow() throws IOException {
        try {
            Schemas.parse((String)new File(this.sub, "test.xsd").getCanonicalPath(), null, null, null, (EntityResolver)PreventLocalEntityResolver.INSTANCE);
        }
        catch (IOException exception) {
            MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.containsString((String)"Entity resolution disallowed"));
        }
    }

    @Test
    public void testEntityResolverAllow() throws IOException {
        XSDSchema schema = Schemas.parse((String)new File(this.sub, "test.xsd").getCanonicalPath(), null, null, null, (EntityResolver)NullEntityResolver.INSTANCE);
        SchemasTest.assertEquals((String)"root", (String)((XSDElementDeclaration)schema.getContents().get(0)).getName());
    }

    private final class MockServerBehaviour
    extends HTTPURIHandler {
        private MockServerBehaviour() {
        }

        public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
            try {
                return (InputStream)SchemasTest.this.executorService.invokeAny(Collections.singletonList(new Callable<InputStream>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public InputStream call() throws Exception {
                        Class<Schemas> clazz = Schemas.class;
                        synchronized (Schemas.class) {
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return Schemas.class.getResourceAsStream("remoteSchemaLocation.xsd");
                        }
                    }
                }), 3L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                return null;
            }
            catch (ExecutionException e) {
                return null;
            }
            catch (TimeoutException e) {
                throw new RuntimeException("Timed out.", e);
            }
        }
    }
}

