/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xsd.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.Collections;
import org.easymock.EasyMock;
import org.eclipse.emf.common.util.URI;
import org.geotools.xsd.impl.HTTPURIHandler;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class HTTPURIHandlerTest {
    HttpURLConnection conn;
    InputStream is;
    HTTPURIHandler handler;
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Before
    public void setUp() throws Exception {
        this.conn = (HttpURLConnection)EasyMock.createMock(HttpURLConnection.class);
        this.is = (InputStream)EasyMock.createMock(InputStream.class);
        this.conn.setConnectTimeout(EasyMock.anyInt());
        EasyMock.expectLastCall().asStub();
        this.conn.setReadTimeout(EasyMock.anyInt());
        EasyMock.expectLastCall().asStub();
        EasyMock.expect((Object)this.conn.getInputStream()).andStubReturn((Object)this.is);
        this.handler = new HTTPURIHandler(){

            protected HttpURLConnection getConnection(URI uri) throws IOException {
                return HTTPURIHandlerTest.this.conn;
            }
        };
        EasyMock.replay((Object[])new Object[]{this.conn, this.is});
    }

    @After
    public void tearDown() throws Exception {
        EasyMock.verify((Object[])new Object[]{this.conn, this.is});
    }

    @Test
    public void testCanHandleHttp() throws Exception {
        URI uri = URI.createURI((String)"http://example.com");
        Assert.assertThat((Object)this.handler.canHandle(uri), (Matcher)CoreMatchers.is((Object)true));
        this.handler.createInputStream(uri, Collections.EMPTY_MAP);
    }

    @Test
    public void testCanHandleHttps() throws Exception {
        URI uri = URI.createURI((String)"https://example.com");
        Assert.assertThat((Object)this.handler.canHandle(uri), (Matcher)CoreMatchers.is((Object)true));
        this.handler.createInputStream(uri, Collections.EMPTY_MAP);
    }

    @Test
    public void testCantHandleFtp() throws Exception {
        URI uri = URI.createURI((String)"ftp://example.com");
        Assert.assertThat((Object)this.handler.canHandle(uri), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testDefaultTimeouts() throws Exception {
        EasyMock.reset((Object[])new Object[]{this.conn});
        this.conn.setConnectTimeout(HTTPURIHandler.DEFAULT_CONNECTION_TIMEOUT);
        EasyMock.expectLastCall();
        this.conn.setReadTimeout(HTTPURIHandler.DEFAULT_READ_TIMEOUT);
        EasyMock.expectLastCall();
        EasyMock.expect((Object)this.conn.getInputStream()).andStubReturn((Object)this.is);
        EasyMock.replay((Object[])new Object[]{this.conn});
        URI uri = URI.createURI((String)"http://example.com");
        this.handler.createInputStream(uri, Collections.EMPTY_MAP);
    }

    @Test
    public void testCustomConnectTimeout() throws Exception {
        int testValue = 42;
        EasyMock.reset((Object[])new Object[]{this.conn});
        this.conn.setConnectTimeout(42);
        EasyMock.expectLastCall();
        this.conn.setReadTimeout(HTTPURIHandler.DEFAULT_READ_TIMEOUT);
        EasyMock.expectLastCall();
        EasyMock.expect((Object)this.conn.getInputStream()).andReturn((Object)this.is);
        EasyMock.replay((Object[])new Object[]{this.conn});
        this.handler.setConnectionTimeout(42);
        URI uri = URI.createURI((String)"http://example.com");
        this.handler.createInputStream(uri, Collections.EMPTY_MAP);
    }

    @Test
    public void testCustomReadTimeout() throws Exception {
        int testValue = 42;
        EasyMock.reset((Object[])new Object[]{this.conn});
        this.conn.setConnectTimeout(HTTPURIHandler.DEFAULT_CONNECTION_TIMEOUT);
        EasyMock.expectLastCall();
        this.conn.setReadTimeout(42);
        EasyMock.expectLastCall();
        EasyMock.expect((Object)this.conn.getInputStream()).andStubReturn((Object)this.is);
        EasyMock.replay((Object[])new Object[]{this.conn});
        this.handler.setReadTimeout(42);
        URI uri = URI.createURI((String)"http://example.com");
        this.handler.createInputStream(uri, Collections.EMPTY_MAP);
    }

    @Test
    public void testTimeout() throws Exception {
        EasyMock.reset((Object[])new Object[]{this.conn});
        this.conn.setConnectTimeout(EasyMock.anyInt());
        EasyMock.expectLastCall();
        this.conn.setReadTimeout(EasyMock.anyInt());
        EasyMock.expectLastCall();
        EasyMock.expect((Object)this.conn.getInputStream()).andThrow((Throwable)new IOException());
        EasyMock.replay((Object[])new Object[]{this.conn});
        URI uri = URI.createURI((String)"http://example.com");
        this.exception.expect(IOException.class);
        this.handler.createInputStream(uri, Collections.EMPTY_MAP);
    }
}

