/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xs.bindings;

import javax.xml.namespace.QName;
import org.geotools.xs.XS;
import org.geotools.xsd.InstanceComponent;
import org.geotools.xsd.SimpleBinding;

public class XSBooleanBinding
implements SimpleBinding {
    @Override
    public QName getTarget() {
        return XS.BOOLEAN;
    }

    @Override
    public int getExecutionMode() {
        return 0;
    }

    @Override
    public Class getType() {
        return Boolean.class;
    }

    @Override
    public Object parse(InstanceComponent instance, Object value) throws Exception {
        if ("1".equals(value) || "true".equals(value)) {
            return Boolean.TRUE;
        }
        if ("0".equals(value) || "false".equals(value)) {
            return Boolean.FALSE;
        }
        throw new IllegalArgumentException("boolean indeterminate from  '" + value + "'");
    }

    @Override
    public String encode(Object object, String value) {
        Boolean bool = (Boolean)object;
        if (Boolean.TRUE.equals(bool)) {
            return "true";
        }
        if (Boolean.FALSE.equals(bool)) {
            return "false";
        }
        return null;
    }
}

