/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xs.bindings;

import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.geotools.xml.impl.DatatypeConverterImpl;
import org.geotools.xs.XS;
import org.geotools.xsd.InstanceComponent;
import org.geotools.xsd.SimpleBinding;

public class XSQNameBinding
implements SimpleBinding {
    protected NamespaceContext namespaceContext;

    public XSQNameBinding(NamespaceContext namespaceContext) {
        this.namespaceContext = namespaceContext;
    }

    @Override
    public QName getTarget() {
        return XS.QNAME;
    }

    @Override
    public int getExecutionMode() {
        return 2;
    }

    @Override
    public Class getType() {
        return QName.class;
    }

    @Override
    public Object parse(InstanceComponent instance, Object value) throws Exception {
        if (value == null) {
            return new QName(null);
        }
        QName qName = null;
        try {
            qName = DatatypeConverterImpl.getInstance().parseQName((String)value, this.namespaceContext);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (qName != null && (qName.getPrefix() == null || qName.getPrefix().equals(""))) {
            String prefix;
            if (qName.getNamespaceURI() != null && !"".equals(qName.getNamespaceURI()) && (prefix = this.namespaceContext.getPrefix(qName.getNamespaceURI())) != null && !"".equals(prefix)) {
                qName = new QName(qName.getNamespaceURI(), qName.getLocalPart(), prefix);
            }
            return qName;
        }
        String s = (String)value;
        int i = s.indexOf(58);
        if (i != -1) {
            String prefix = s.substring(0, i);
            String local = s.substring(i + 1);
            return new QName(null, local, prefix);
        }
        return new QName(null, s);
    }

    @Override
    public String encode(Object object, String value) throws Exception {
        try {
            return DatatypeConverterImpl.getInstance().printQName((QName)object, this.namespaceContext);
        }
        catch (Exception e) {
            QName qName = (QName)object;
            if (qName.getPrefix() == null || qName.getPrefix().equals("")) {
                return qName.getLocalPart();
            }
            return qName.getPrefix() + ":" + qName.getLocalPart();
        }
    }
}

