/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xsd;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.xml.namespace.QName;
import org.geotools.ml.MLConfiguration;
import org.geotools.util.PreventLocalEntityResolver;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.StreamingParser;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.EntityResolver;

public class StreamingParserTest {
    @Test
    public void testParseXXE() throws Exception {
        String xml = "<!DOCTYPE foo [<!ENTITY xxe SYSTEM \"file:///\" >]><mails><mail><body>&xxe;</body></mail></mails>";
        ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes());
        StreamingParser parser = new StreamingParser((Configuration)new MLConfiguration(), (InputStream)in, new QName("http://mails/refractions/net", "mail"));
        parser.setEntityResolver((EntityResolver)PreventLocalEntityResolver.INSTANCE);
        Assert.assertNull((Object)parser.parse());
    }

    @Test
    public void testParseWithJavaMethod() throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream("<mails></mails>".getBytes());
        StreamingParser parser = new StreamingParser((Configuration)new MLConfiguration(), (InputStream)in, "java.lang.Thread.sleep(30000)");
        long start = System.currentTimeMillis();
        Assert.assertNull((Object)parser.parse());
        long runtime = System.currentTimeMillis() - start;
        Assert.assertTrue((String)"java.lang.Thread.sleep(30000) was executed", (runtime < 30000L ? 1 : 0) != 0);
    }
}

