/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xsd;

import java.math.BigInteger;
import java.util.Calendar;
import javax.xml.namespace.QName;
import org.geotools.ml.Envelope;
import org.geotools.ml.MLConfiguration;
import org.geotools.ml.Mail;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Encoder;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class EncoderTest {
    @Test
    @Ignore
    public void testIndent() throws Exception {
        Mail ml = new Mail(BigInteger.valueOf(10L), "hi", new Envelope("me@me.org", "you@you.org", Calendar.getInstance(), "hey", null), null);
        Encoder e = new Encoder((Configuration)new MLConfiguration());
        e.setIndenting(true);
        e.setIndentSize(4);
        String mail = e.encodeAsString((Object)ml, new QName("http://mails/refractions/net", "mails"));
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><ml:mails xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:ml=\"http://mails/refractions/net\">\n    <ml:mail>\n        <ml:envelope From=\"me@me.org\">\n            <ml:From>me@me.org</ml:From>\n            <ml:To>you@you.org</ml:To>\n        </ml:envelope>\n    </ml:mail>\n</ml:mails>";
        Assert.assertEquals((Object)expected, (Object)mail);
    }

    @Test
    public void testSetOmitXMLDeclaration() {
        Encoder encoder = new Encoder((Configuration)new MLConfiguration());
        encoder.setOmitXMLDeclaration(false);
        Assert.assertFalse((boolean)encoder.isOmitXMLDeclaration());
        encoder.setOmitXMLDeclaration(true);
        Assert.assertTrue((boolean)encoder.isOmitXMLDeclaration());
    }

    @Test
    public void testSetIndenting() {
        Encoder encoder = new Encoder((Configuration)new MLConfiguration());
        encoder.setIndenting(false);
        Assert.assertFalse((boolean)encoder.isIndenting());
        encoder.setIndenting(true);
        Assert.assertTrue((boolean)encoder.isIndenting());
    }
}

