/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xsd;

import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.geotools.xs.XSConfiguration;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.DOMParser;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;

public class FacetTest {
    @Test
    public void testList() throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(this.getClass().getResourceAsStream("list.xml"));
        String schemaLocation = "http://geotools.org/test " + this.getClass().getResource("facets.xsd").getFile();
        doc.getDocumentElement().setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", schemaLocation);
        DOMParser parser = new DOMParser((Configuration)new XSConfiguration(), doc);
        Object o = parser.parse();
        Assert.assertTrue((boolean)(o instanceof List));
        List list = (List)o;
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((Object)1, list.get(0));
        Assert.assertEquals((Object)2, list.get(1));
        Assert.assertEquals((Object)3, list.get(2));
    }

    @Test
    public void testWhitespace() throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(this.getClass().getResourceAsStream("whitespace.xml"));
        String schemaLocation = "http://geotools.org/test " + this.getClass().getResource("facets.xsd").getFile();
        doc.getDocumentElement().setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", schemaLocation);
        DOMParser parser = new DOMParser((Configuration)new XSConfiguration(), doc);
        String s = (String)parser.parse();
        Assert.assertEquals((Object)"this is a normal string with some whitespace and some new lines", (Object)s);
    }

    @Test
    public void testCDATAWhitespace() throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(this.getClass().getResourceAsStream("whitespace-cdata.xml"));
        String schemaLocation = "http://geotools.org/test " + this.getClass().getResource("facets.xsd").getFile();
        doc.getDocumentElement().setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", schemaLocation);
        DOMParser parser = new DOMParser((Configuration)new XSConfiguration(), doc);
        String s = (String)parser.parse();
        Assert.assertEquals((Object)" this is a \n normal string \n with some whitespace and \n some new lines", (Object)s);
    }
}

