/*
 *    GeoTools - The Open Source Java GIS Toolkit
 *    http://geotools.org
 *
 *    (C) 2002-2008, Open Source Geospatial Foundation (OSGeo)
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation;
 *    version 2.1 of the License.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 */
package org.geotools.xsd.impl;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BufferTest {
    Buffer buffer;

    @Before
    public void setUp() throws Exception {
        buffer = new Buffer(10);
    }

    @Test
    public void test() throws Exception {
        Consumer consumer = new Consumer(buffer);
        Thread thread = new Thread(consumer);
        thread.start();

        for (int i = 0; i < 1000; i++) {
            buffer.put(Integer.valueOf(i));
        }

        thread.join();

        for (int i = 0; i < consumer.taken.size(); i++) {
            Integer integer = (Integer) consumer.taken.get(i);
            Assert.assertEquals(i, integer.intValue());
        }
    }

    static class Consumer implements Runnable {
        Buffer buffer;
        List<Object> taken;

        public Consumer(Buffer buffer) {
            this.buffer = buffer;
        }

        @Override
        public void run() {
            taken = new ArrayList<>();

            for (int i = 0; i < 1000; i++) {
                taken.add(buffer.get());
            }
        }
    }
}
