/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xs.bindings;

import javax.xml.namespace.QName;
import org.geotools.xs.TestSchema;
import org.geotools.xs.XS;
import org.geotools.xsd.InstanceComponent;
import org.junit.Assert;
import org.junit.Test;

public class XSFloatStrategyTest
extends TestSchema {
    public void validateValues(String given, Float expected) throws Exception {
        Float actual = (Float)this.strategy.parse((InstanceComponent)this.element(given, this.qname), (Object)given);
        Assert.assertEquals((String)given, (Object)expected, (Object)actual);
    }

    @Test
    public void testWhiteSpace() throws Exception {
        this.validateValues(" \n12", Float.valueOf(12.0f));
    }

    @Test
    public void testParse() throws Exception {
        this.validateValues("-1E4", Float.valueOf(-10000.0f));
        this.validateValues("1267.43233E12", Float.valueOf(1.2674324E15f));
        this.validateValues("12.78e-2", Float.valueOf(0.1278f));
        this.validateValues("12", Float.valueOf(12.0f));
        this.validateValues("-0", Float.valueOf("-0"));
        this.validateValues("0", Float.valueOf(0.0f));
        this.validateValues("INF", Float.valueOf(Float.POSITIVE_INFINITY));
    }

    @Override
    protected QName getQName() {
        return XS.FLOAT;
    }

    @Test
    public void testParseEmptyStringAsNull() throws Exception {
        this.validateValues("", null);
        this.validateValues("\t", null);
    }
}

