/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xsd;

import java.awt.RenderingHints;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.geotools.util.factory.Hints;
import org.geotools.xml.XmlConverterFactory;
import org.geotools.xs.bindings.XSDateBinding;
import org.geotools.xs.bindings.XSDateTimeBinding;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DateConversionTimezoneTest {
    private XmlConverterFactory sut1 = new XmlConverterFactory();
    private XSDateBinding sut2 = new XSDateBinding();
    private XSDateTimeBinding sut3 = new XSDateTimeBinding();
    private TimeZone systemTimeZone;

    @Test
    public void testLocalEncode() throws Exception {
        Hints.putSystemDefault((RenderingHints.Key)Hints.LOCAL_DATE_TIME_HANDLING, (Object)true);
        this.assertDateEquals("2015-09-02", 2015, 9, 2, 0, "UTC");
        this.assertDateEquals("2015-09-02", 2015, 9, 2, 1, "UTC");
        this.assertDateEquals("2015-09-02", 2015, 9, 2, 23, "UTC");
        this.assertDateTimeEquals("2015-09-02T00:00:00Z", 2015, 9, 2, 0, "UTC");
        this.assertDateTimeEquals("2015-09-02T01:00:00Z", 2015, 9, 2, 1, "UTC");
        this.assertDateTimeEquals("2015-09-02T23:00:00Z", 2015, 9, 2, 23, "UTC");
        this.assertDateEquals("2015-09-02", 2015, 9, 2, 0, "GMT");
        this.assertDateEquals("2015-09-02", 2015, 9, 2, 1, "GMT");
        this.assertDateEquals("2015-09-02", 2015, 9, 2, 23, "GMT");
        this.assertDateTimeEquals("2015-09-02T00:00:00Z", 2015, 9, 2, 0, "GMT");
        this.assertDateTimeEquals("2015-09-02T01:00:00Z", 2015, 9, 2, 1, "GMT");
        this.assertDateTimeEquals("2015-09-02T23:00:00Z", 2015, 9, 2, 23, "GMT");
        this.assertDateEquals("2015-09-02", 2015, 9, 2, 0, "CET");
        this.assertDateEquals("2015-09-02", 2015, 9, 2, 1, "CET");
        this.assertDateEquals("2015-09-02", 2015, 9, 2, 2, "CET");
        this.assertDateEquals("2015-09-02", 2015, 9, 2, 23, "CET");
        this.assertDateTimeEquals("2015-09-02T00:00:00+02:00", 2015, 9, 2, 0, "CET");
        this.assertDateTimeEquals("2015-09-02T01:00:00+02:00", 2015, 9, 2, 1, "CET");
        this.assertDateTimeEquals("2015-09-02T02:00:00+02:00", 2015, 9, 2, 2, "CET");
        this.assertDateTimeEquals("2015-09-02T23:00:00+02:00", 2015, 9, 2, 23, "CET");
        this.assertDateEquals("2015-09-02", 2015, 9, 2, 0, "EST");
        this.assertDateEquals("2015-09-02", 2015, 9, 2, 1, "EST");
        this.assertDateEquals("2015-09-02", 2015, 9, 2, 23, "EST");
        this.assertDateTimeEquals("2015-09-02T00:00:00-05:00", 2015, 9, 2, 0, "EST");
        this.assertDateTimeEquals("2015-09-02T01:00:00-05:00", 2015, 9, 2, 1, "EST");
        this.assertDateTimeEquals("2015-09-02T23:00:00-05:00", 2015, 9, 2, 23, "EST");
    }

    @Test
    public void testTimezoneAwareEncode() throws Exception {
        this.assertDateEquals("2015-09-02Z", 2015, 9, 2, 0, "UTC");
        this.assertDateEquals("2015-09-02Z", 2015, 9, 2, 1, "UTC");
        this.assertDateEquals("2015-09-02Z", 2015, 9, 2, 23, "UTC");
        this.assertDateTimeEquals("2015-09-02T00:00:00Z", 2015, 9, 2, 0, "UTC");
        this.assertDateTimeEquals("2015-09-02T01:00:00Z", 2015, 9, 2, 1, "UTC");
        this.assertDateTimeEquals("2015-09-02T23:00:00Z", 2015, 9, 2, 23, "UTC");
        this.assertDateEquals("2015-09-02Z", 2015, 9, 2, 0, "GMT");
        this.assertDateEquals("2015-09-02Z", 2015, 9, 2, 1, "GMT");
        this.assertDateEquals("2015-09-02Z", 2015, 9, 2, 23, "GMT");
        this.assertDateTimeEquals("2015-09-02T00:00:00Z", 2015, 9, 2, 0, "GMT");
        this.assertDateTimeEquals("2015-09-02T01:00:00Z", 2015, 9, 2, 1, "GMT");
        this.assertDateTimeEquals("2015-09-02T23:00:00Z", 2015, 9, 2, 23, "GMT");
        this.assertDateEquals("2015-09-01Z", 2015, 9, 2, 0, "CET");
        this.assertDateEquals("2015-09-01Z", 2015, 9, 2, 1, "CET");
        this.assertDateEquals("2015-09-02Z", 2015, 9, 2, 2, "CET");
        this.assertDateEquals("2015-09-02Z", 2015, 9, 2, 23, "CET");
        this.assertDateTimeEquals("2015-09-01T22:00:00Z", 2015, 9, 2, 0, "CET");
        this.assertDateTimeEquals("2015-09-01T23:00:00Z", 2015, 9, 2, 1, "CET");
        this.assertDateTimeEquals("2015-09-02T00:00:00Z", 2015, 9, 2, 2, "CET");
        this.assertDateTimeEquals("2015-09-02T21:00:00Z", 2015, 9, 2, 23, "CET");
        this.assertDateEquals("2015-09-02Z", 2015, 9, 2, 0, "EST");
        this.assertDateEquals("2015-09-02Z", 2015, 9, 2, 1, "EST");
        this.assertDateEquals("2015-09-03Z", 2015, 9, 2, 23, "EST");
        this.assertDateTimeEquals("2015-09-02T05:00:00Z", 2015, 9, 2, 0, "EST");
        this.assertDateTimeEquals("2015-09-02T06:00:00Z", 2015, 9, 2, 1, "EST");
        this.assertDateTimeEquals("2015-09-03T04:00:00Z", 2015, 9, 2, 23, "EST");
    }

    private void assertDateEquals(String expected, int year, int month, int day, int hour, String timezoneId) throws Exception {
        Calendar calendar = this.calendarOf(year, month, day, hour, timezoneId);
        Date utilDate = calendar.getTime();
        java.sql.Date date = new java.sql.Date(utilDate.getTime());
        Assert.assertEquals((Object)expected, (Object)this.sut1Convert(date));
        Assert.assertEquals((Object)expected, (Object)this.sut2Convert(date));
    }

    private Calendar calendarOf(int year, int month, int day, int hour, String timezoneId) {
        TimeZone timeZone = TimeZone.getTimeZone(timezoneId);
        TimeZone.setDefault(timeZone);
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, year);
        calendar.set(5, day);
        calendar.set(2, month - 1);
        calendar.set(11, hour);
        return calendar;
    }

    private void assertDateTimeEquals(String expected, int year, int month, int day, int hour, String timezoneId) throws Exception {
        Calendar calendar = this.calendarOf(year, month, day, hour, timezoneId);
        Date utilDate = calendar.getTime();
        java.sql.Date date = new java.sql.Date(utilDate.getTime());
        Assert.assertEquals((Object)expected, (Object)this.sut3Convert(date));
    }

    @Before
    public void setUp() {
        this.systemTimeZone = TimeZone.getDefault();
    }

    @After
    public void tearDown() {
        TimeZone.setDefault(this.systemTimeZone);
        Hints.removeSystemDefault((RenderingHints.Key)Hints.LOCAL_DATE_TIME_HANDLING);
    }

    private String sut1Convert(java.sql.Date date) throws Exception {
        return (String)this.sut1.createConverter(java.sql.Date.class, String.class, null).convert((Object)date, String.class);
    }

    private String sut2Convert(java.sql.Date date) throws Exception {
        return this.sut2.encode((Object)date, null);
    }

    private String sut3Convert(java.sql.Date date) throws Exception {
        return this.sut3.encode((Object)date, null);
    }
}

