/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xsd.impl;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import org.geotools.xml.impl.XsDateTimeFormat;
import org.junit.Assert;
import org.junit.Test;

public class XsDateTimeFormatTest {
    @Test
    public void testDate() throws ParseException {
        XsDateTimeFormat format = new XsDateTimeFormat();
        String time = "2014-10-12T09:00:00.000Z";
        Object parseObject = format.parseObject(time);
        Assert.assertTrue((boolean)(parseObject instanceof Calendar));
        Calendar cal = (Calendar)parseObject;
        int year = cal.get(1);
        int month = cal.get(2);
        int day = cal.get(5);
        int hours = cal.get(10);
        int mins = cal.get(12);
        int sec = cal.get(13);
        int millis = cal.get(14);
        Assert.assertEquals((long)year, (long)2014L);
        Assert.assertEquals((long)month, (long)9L);
        Assert.assertEquals((long)day, (long)12L);
        Assert.assertEquals((long)hours, (long)9L);
        Assert.assertEquals((long)mins, (long)0L);
        Assert.assertEquals((long)sec, (long)0L);
        Assert.assertEquals((long)millis, (long)0L);
    }

    @Test(expected=ParseException.class)
    public void testWrongDate() throws ParseException {
        XsDateTimeFormat format = new XsDateTimeFormat();
        String time = "2014-10-12T09:00Z";
        format.parseObject(time);
    }

    @Test
    public void testWrongDateLenientNoSec() throws ParseException {
        XsDateTimeFormat format = new XsDateTimeFormat();
        String time = "2014-10-12T09:00Z";
        Object parseObject = format.parseObject(time, true);
        Assert.assertTrue((boolean)(parseObject instanceof Calendar));
        Calendar cal = (Calendar)parseObject;
        int year = cal.get(1);
        int month = cal.get(2);
        int day = cal.get(5);
        int hours = cal.get(10);
        int mins = cal.get(12);
        int sec = cal.get(13);
        int millis = cal.get(14);
        Assert.assertEquals((long)year, (long)2014L);
        Assert.assertEquals((long)month, (long)9L);
        Assert.assertEquals((long)day, (long)12L);
        Assert.assertEquals((long)hours, (long)9L);
        Assert.assertEquals((long)mins, (long)0L);
        Assert.assertEquals((long)sec, (long)0L);
        Assert.assertEquals((long)millis, (long)0L);
    }

    @Test
    public void testWrongDateLenientNoMins() throws ParseException {
        XsDateTimeFormat format = new XsDateTimeFormat();
        String time = "2014-10-12T09Z";
        Object parseObject = format.parseObject(time, true);
        Assert.assertTrue((boolean)(parseObject instanceof Calendar));
        Calendar cal = (Calendar)parseObject;
        int year = cal.get(1);
        int month = cal.get(2);
        int day = cal.get(5);
        int hours = cal.get(10);
        int mins = cal.get(12);
        int sec = cal.get(13);
        int millis = cal.get(14);
        Assert.assertEquals((long)year, (long)2014L);
        Assert.assertEquals((long)month, (long)9L);
        Assert.assertEquals((long)day, (long)12L);
        Assert.assertEquals((long)hours, (long)9L);
        Assert.assertEquals((long)mins, (long)0L);
        Assert.assertEquals((long)sec, (long)0L);
        Assert.assertEquals((long)millis, (long)0L);
    }

    @Test
    public void testWrongDateLenientIncomplete() throws ParseException {
        XsDateTimeFormat format = new XsDateTimeFormat();
        String time = "2014-10-12T0Z";
        Object parseObject = format.parseObject(time, true);
        Assert.assertTrue((boolean)(parseObject instanceof Calendar));
        Calendar cal = (Calendar)parseObject;
        int year = cal.get(1);
        int month = cal.get(2);
        int day = cal.get(5);
        int hours = cal.get(10);
        int mins = cal.get(12);
        int sec = cal.get(13);
        int millis = cal.get(14);
        Assert.assertEquals((long)year, (long)2014L);
        Assert.assertEquals((long)month, (long)9L);
        Assert.assertEquals((long)day, (long)12L);
        Assert.assertEquals((long)hours, (long)0L);
        Assert.assertEquals((long)mins, (long)0L);
        Assert.assertEquals((long)sec, (long)0L);
        Assert.assertEquals((long)millis, (long)0L);
    }

    @Test
    public void testWrongDateLenientIncompleteMins() throws ParseException {
        XsDateTimeFormat format = new XsDateTimeFormat();
        String time = "2014-10-12T05:0Z";
        Object parseObject = format.parseObject(time, true);
        Assert.assertTrue((boolean)(parseObject instanceof Calendar));
        Calendar cal = (Calendar)parseObject;
        int year = cal.get(1);
        int month = cal.get(2);
        int day = cal.get(5);
        int hours = cal.get(10);
        int mins = cal.get(12);
        int sec = cal.get(13);
        int millis = cal.get(14);
        Assert.assertEquals((long)year, (long)2014L);
        Assert.assertEquals((long)month, (long)9L);
        Assert.assertEquals((long)day, (long)12L);
        Assert.assertEquals((long)hours, (long)5L);
        Assert.assertEquals((long)mins, (long)0L);
        Assert.assertEquals((long)sec, (long)0L);
        Assert.assertEquals((long)millis, (long)0L);
    }

    @Test
    public void testExtendedFractionalSeconds() throws ParseException {
        XsDateTimeFormat format = new XsDateTimeFormat();
        String time = "2014-10-13T05:34:02.1109963Z";
        Object parseObject = format.parseObject(time, true);
        Assert.assertTrue((boolean)(parseObject instanceof Calendar));
        Calendar cal = (Calendar)parseObject;
        int year = cal.get(1);
        int month = cal.get(2);
        int day = cal.get(5);
        int hours = cal.get(10);
        int mins = cal.get(12);
        int sec = cal.get(13);
        int millis = cal.get(14);
        Assert.assertEquals((long)year, (long)2014L);
        Assert.assertEquals((long)month, (long)9L);
        Assert.assertEquals((long)day, (long)13L);
        Assert.assertEquals((long)hours, (long)5L);
        Assert.assertEquals((long)mins, (long)34L);
        Assert.assertEquals((long)sec, (long)2L);
        Assert.assertEquals((long)millis, (long)111L);
    }

    @Test
    public void testDefaultFormatDates() throws ParseException {
        XsDateTimeFormat format = new XsDateTimeFormat();
        TimeZone originalTimeZone = TimeZone.getDefault();
        TimeZone tz = TimeZone.getTimeZone("GMT");
        TimeZone.setDefault(tz);
        Locale originalLocale = Locale.getDefault();
        Locale.setDefault(Locale.ENGLISH);
        String t = "Tue Apr 25 13:13:14 UTC 2017";
        Object parseObject = format.parseObject(t, true);
        Assert.assertTrue((boolean)(parseObject instanceof Calendar));
        Calendar cal = (Calendar)parseObject;
        int year = cal.get(1);
        int month = cal.get(2);
        int day = cal.get(5);
        int hours = cal.get(11);
        int mins = cal.get(12);
        int sec = cal.get(13);
        Assert.assertEquals((long)year, (long)2017L);
        Assert.assertEquals((long)month, (long)3L);
        Assert.assertEquals((long)day, (long)25L);
        Assert.assertEquals((long)hours, (long)13L);
        Assert.assertEquals((long)mins, (long)13L);
        Assert.assertEquals((long)sec, (long)14L);
        t = "Fri Oct 13 14:22:10 BST 2017";
        parseObject = format.parseObject(t, true);
        Assert.assertTrue((boolean)(parseObject instanceof Calendar));
        cal = (Calendar)parseObject;
        year = cal.get(1);
        month = cal.get(2);
        day = cal.get(5);
        hours = cal.get(11);
        mins = cal.get(12);
        sec = cal.get(13);
        Assert.assertEquals((long)year, (long)2017L);
        Assert.assertEquals((long)month, (long)9L);
        Assert.assertEquals((long)day, (long)13L);
        Assert.assertEquals((long)hours, (long)13L);
        Assert.assertEquals((long)mins, (long)22L);
        Assert.assertEquals((long)sec, (long)10L);
        t = "Sun Oct 1 4:22:10 BST 2017";
        parseObject = format.parseObject(t, true);
        Assert.assertTrue((boolean)(parseObject instanceof Calendar));
        cal = (Calendar)parseObject;
        year = cal.get(1);
        month = cal.get(2);
        day = cal.get(5);
        hours = cal.get(11);
        mins = cal.get(12);
        sec = cal.get(13);
        Assert.assertEquals((long)year, (long)2017L);
        Assert.assertEquals((long)month, (long)9L);
        Assert.assertEquals((long)day, (long)1L);
        Assert.assertEquals((long)hours, (long)3L);
        Assert.assertEquals((long)mins, (long)22L);
        Assert.assertEquals((long)sec, (long)10L);
        TimeZone.setDefault(originalTimeZone);
        Locale.setDefault(originalLocale);
    }
}

