/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.v2_0.bindings;

import java.util.Date;
import javax.xml.namespace.QName;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.identity.FeatureId;
import org.geotools.api.filter.identity.ResourceId;
import org.geotools.api.filter.identity.Version;
import org.geotools.filter.v2_0.FES;
import org.geotools.xsd.AbstractComplexBinding;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.Node;

public class ResourceIdTypeBinding
extends AbstractComplexBinding {
    FilterFactory factory;

    public ResourceIdTypeBinding(FilterFactory factory) {
        this.factory = factory;
    }

    public Class<?> getType() {
        return FeatureId.class;
    }

    public QName getTarget() {
        return FES.ResourceIdType;
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        String fid;
        String rid = (String)node.getAttributeValue("rid");
        Version version = (Version)node.getAttributeValue("version");
        Date startTime = (Date)node.getAttributeValue("startDate");
        Date endTime = (Date)node.getAttributeValue("endDate");
        String featureVersion = null;
        int idx = rid.indexOf(64);
        if (idx == -1) {
            fid = rid;
        } else {
            fid = rid.substring(0, idx);
            featureVersion = rid.substring(idx + 1);
        }
        ResourceId resourceId = startTime != null || endTime != null ? this.factory.resourceId(fid, startTime, endTime) : this.factory.resourceId(fid, featureVersion, version);
        return resourceId;
    }

    public Object getProperty(Object object, QName name) throws Exception {
        if (object == null) {
            return null;
        }
        FeatureId fid = (FeatureId)object;
        String localName = name.getLocalPart();
        if ("id".equals(localName)) {
            return fid.getID();
        }
        if ("rid".equals(localName)) {
            return fid.getRid();
        }
        if ("previousRid".equals(localName)) {
            return fid.getPreviousRid();
        }
        if ("version".equals(localName) && fid instanceof ResourceId) {
            return ((ResourceId)fid).getVersion();
        }
        if ("startDate".equals(localName) && fid instanceof ResourceId) {
            return ((ResourceId)fid).getStartTime();
        }
        if ("endDate".equals(localName) && fid instanceof ResourceId) {
            return ((ResourceId)fid).getEndTime();
        }
        return null;
    }
}

