/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.v1_0;

import org.geotools.filter.v1_0.FilterMockData;
import org.geotools.filter.v1_0.FilterTestSupport;
import org.geotools.filter.v1_0.OGC;
import org.geotools.gml3.GML;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.filter.expression.Function;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.DistanceBufferOperator;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BinarySpatialOpTypeBindingTest
extends FilterTestSupport {
    @Test
    public void testDistanceBufferType() {
        Assert.assertEquals(DistanceBufferOperator.class, (Object)this.binding(OGC.DistanceBufferType).getType());
    }

    @Test
    public void testBeyondType() {
        Assert.assertEquals(Beyond.class, (Object)this.binding(OGC.Beyond).getType());
    }

    @Test
    public void testBeyondParse() throws Exception {
        FilterMockData.beyond(this.document, this.document);
        Beyond beyond = (Beyond)this.parse();
        Assert.assertNotNull((Object)beyond.getExpression1());
        Assert.assertNotNull((Object)beyond.getExpression2());
        Assert.assertEquals((double)1.0, (double)beyond.getDistance(), (double)0.1);
        Assert.assertEquals((Object)"m", (Object)beyond.getDistanceUnits());
    }

    @Test
    public void testBeyondEncode() throws Exception {
        Document dom = this.encode(FilterMockData.beyond(), OGC.Beyond);
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagNameNS("http://www.opengis.net/ogc", OGC.PropertyName.getLocalPart()).getLength());
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagNameNS("http://www.opengis.net/gml", GML.Point.getLocalPart()).getLength());
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagNameNS("http://www.opengis.net/ogc", "Distance").getLength());
        Assert.assertEquals((Object)"1.0", (Object)dom.getElementsByTagNameNS("http://www.opengis.net/ogc", OGC.Distance.getLocalPart()).item(0).getFirstChild().getNodeValue());
        Assert.assertEquals((Object)"m", (Object)((Element)dom.getElementsByTagNameNS("http://www.opengis.net/ogc", OGC.Distance.getLocalPart()).item(0)).getAttribute("units"));
    }

    @Test
    public void testDWithinType() {
        Assert.assertEquals(DWithin.class, (Object)this.binding(OGC.DWithin).getType());
    }

    @Test
    public void testDWithinParse() throws Exception {
        FilterMockData.dwithin(this.document, this.document);
        DWithin dwithin = (DWithin)this.parse();
        Assert.assertNotNull((Object)dwithin.getExpression1());
        Assert.assertNotNull((Object)dwithin.getExpression2());
        Assert.assertEquals((double)1.0, (double)dwithin.getDistance(), (double)0.1);
        Assert.assertEquals((Object)"m", (Object)dwithin.getDistanceUnits());
    }

    @Test
    public void testDWithinEncode() throws Exception {
        Document dom = this.encode(FilterMockData.beyond(), OGC.DWithin);
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagNameNS("http://www.opengis.net/ogc", OGC.PropertyName.getLocalPart()).getLength());
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagNameNS("http://www.opengis.net/gml", GML.Point.getLocalPart()).getLength());
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagNameNS("http://www.opengis.net/ogc", "Distance").getLength());
        Assert.assertEquals((Object)"1.0", (Object)dom.getElementsByTagNameNS("http://www.opengis.net/ogc", "Distance").item(0).getFirstChild().getNodeValue());
    }

    @Test
    public void testBinarySpatialOpType() {
        Assert.assertEquals(BinarySpatialOperator.class, (Object)this.binding(OGC.BinarySpatialOpType).getType());
    }

    @Test
    public void testContainsType() {
        Assert.assertEquals(Contains.class, (Object)this.binding(OGC.Contains).getType());
    }

    @Test
    public void testContainsParse() throws Exception {
        FilterMockData.contains(this.document, this.document);
        Contains contains = (Contains)this.parse();
        Assert.assertNotNull((Object)contains.getExpression1());
        Assert.assertNotNull((Object)contains.getExpression2());
    }

    @Test
    public void testContainsEncode() throws Exception {
        Document dom = this.encode(FilterMockData.contains(), OGC.Contains);
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagNameNS("http://www.opengis.net/ogc", OGC.PropertyName.getLocalPart()).getLength());
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagNameNS("http://www.opengis.net/gml", GML.Point.getLocalPart()).getLength());
    }

    @Test
    public void testCrossesType() {
        Assert.assertEquals(Crosses.class, (Object)this.binding(OGC.Crosses).getType());
    }

    @Test
    public void testCrossesParse() throws Exception {
        FilterMockData.crosses(this.document, this.document);
        Crosses crosses = (Crosses)this.parse();
        Assert.assertNotNull((Object)crosses.getExpression1());
        Assert.assertNotNull((Object)crosses.getExpression2());
    }

    @Test
    public void testCrossesEncode() throws Exception {
        Document dom = this.encode(FilterMockData.crosses(), OGC.Crosses);
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagNameNS("http://www.opengis.net/ogc", OGC.PropertyName.getLocalPart()).getLength());
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagNameNS("http://www.opengis.net/gml", GML.Point.getLocalPart()).getLength());
    }

    @Test
    public void testDisjointType() {
        Assert.assertEquals(Disjoint.class, (Object)this.binding(OGC.Disjoint).getType());
    }

    @Test
    public void testDisjointParse() throws Exception {
        FilterMockData.disjoint(this.document, this.document);
        Disjoint disjoint = (Disjoint)this.parse();
        Assert.assertNotNull((Object)disjoint.getExpression1());
        Assert.assertNotNull((Object)disjoint.getExpression2());
    }

    @Test
    public void testDisjointEncode() throws Exception {
        Document dom = this.encode(FilterMockData.disjoint(), OGC.Disjoint);
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagNameNS("http://www.opengis.net/ogc", OGC.PropertyName.getLocalPart()).getLength());
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagNameNS("http://www.opengis.net/gml", GML.Point.getLocalPart()).getLength());
    }

    @Test
    public void testEqualsType() {
        Assert.assertEquals(Equals.class, (Object)this.binding(OGC.Equals).getType());
    }

    @Test
    public void testEqualsParse() throws Exception {
        FilterMockData.equals(this.document, this.document);
        Equals equals = (Equals)this.parse();
        Assert.assertNotNull((Object)equals.getExpression1());
        Assert.assertNotNull((Object)equals.getExpression2());
    }

    @Test
    public void testEqualsEncode() throws Exception {
        Document dom = this.encode(FilterMockData.equals(), OGC.Equals);
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagNameNS("http://www.opengis.net/ogc", OGC.PropertyName.getLocalPart()).getLength());
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagNameNS("http://www.opengis.net/gml", GML.Point.getLocalPart()).getLength());
    }

    @Test
    public void testIntersectsType() {
        Assert.assertEquals(Intersects.class, (Object)this.binding(OGC.Intersects).getType());
    }

    @Test
    public void testIntersectsParse() throws Exception {
        FilterMockData.intersects(this.document, this.document);
        Intersects intersects = (Intersects)this.parse();
        Assert.assertNotNull((Object)intersects.getExpression1());
        Assert.assertNotNull((Object)intersects.getExpression2());
    }

    @Test
    public void testIntersectsEncode() throws Exception {
        Document dom = this.encode(FilterMockData.intersects(), OGC.Intersects);
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagNameNS("http://www.opengis.net/ogc", OGC.PropertyName.getLocalPart()).getLength());
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagNameNS("http://www.opengis.net/gml", GML.Point.getLocalPart()).getLength());
    }

    @Test
    public void testOverlapsType() {
        Assert.assertEquals(Overlaps.class, (Object)this.binding(OGC.Overlaps).getType());
    }

    @Test
    public void testOverlapsParse() throws Exception {
        FilterMockData.overlaps(this.document, this.document);
        Overlaps overlaps = (Overlaps)this.parse();
        Assert.assertNotNull((Object)overlaps.getExpression1());
        Assert.assertNotNull((Object)overlaps.getExpression2());
    }

    @Test
    public void testOverlapsEncode() throws Exception {
        Document dom = this.encode(FilterMockData.overlaps(), OGC.Overlaps);
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagNameNS("http://www.opengis.net/ogc", OGC.PropertyName.getLocalPart()).getLength());
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagNameNS("http://www.opengis.net/gml", GML.Point.getLocalPart()).getLength());
    }

    @Test
    public void testTouchesType() {
        Assert.assertEquals(Touches.class, (Object)this.binding(OGC.Touches).getType());
    }

    @Test
    public void testTouchesParse() throws Exception {
        FilterMockData.touches(this.document, this.document);
        Touches touches = (Touches)this.parse();
        Assert.assertNotNull((Object)touches.getExpression1());
        Assert.assertNotNull((Object)touches.getExpression2());
    }

    @Test
    public void testTouchesEncode() throws Exception {
        Document dom = this.encode(FilterMockData.touches(), OGC.Touches);
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagNameNS("http://www.opengis.net/ogc", OGC.PropertyName.getLocalPart()).getLength());
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagNameNS("http://www.opengis.net/gml", GML.Point.getLocalPart()).getLength());
    }

    @Test
    public void testWithinType() {
        Assert.assertEquals(Within.class, (Object)this.binding(OGC.Within).getType());
    }

    @Test
    public void testWithinParse() throws Exception {
        FilterMockData.within(this.document, this.document);
        Within within = (Within)this.parse();
        Assert.assertNotNull((Object)within.getExpression1());
        Assert.assertNotNull((Object)within.getExpression2());
    }

    @Test
    public void testWithinEncode() throws Exception {
        Document dom = this.encode(FilterMockData.within(), OGC.Within);
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagNameNS("http://www.opengis.net/ogc", OGC.PropertyName.getLocalPart()).getLength());
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagNameNS("http://www.opengis.net/gml", GML.Point.getLocalPart()).getLength());
    }

    @Test
    public void testWithFunctionParse() throws Exception {
        FilterMockData.withinWithFunction(this.document, this.document);
        Within within = (Within)this.parse();
        Assert.assertNotNull((Object)within.getExpression1());
        Assert.assertNotNull((Object)within.getExpression2());
        Assert.assertTrue((boolean)(within.getExpression2() instanceof Function));
    }

    @Test
    public void testWithFunctionEncode() throws Exception {
        Document dom = this.encode(FilterMockData.withinWithFunction(), OGC.Within);
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagNameNS("http://www.opengis.net/ogc", OGC.Function.getLocalPart()).getLength());
    }
}

