/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.v1_0;

import org.geotools.filter.v1_0.FilterMockData;
import org.geotools.filter.v1_0.FilterTestSupport;
import org.geotools.filter.v1_0.OGC;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.gml2.GML;
import org.geotools.referencing.CRS;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BBOX;
import org.opengis.geometry.BoundingBox;
import org.w3c.dom.Document;

public class OGCBBoxTypeBindingTest
extends FilterTestSupport {
    @Test
    public void testType() {
        Assert.assertEquals(BBOX.class, (Object)this.binding(OGC.BBOXType).getType());
    }

    @Test
    public void testExecutionMode() {
        Assert.assertEquals((long)2L, (long)this.binding(OGC.BBOXType).getExecutionMode());
    }

    @Test
    public void testParse() throws Exception {
        FilterMockData.bbox(this.document, this.document);
        BBOX box = (BBOX)this.parse();
        Assert.assertEquals((Object)"foo", (Object)((PropertyName)box.getExpression1()).getPropertyName());
        Assert.assertTrue((boolean)JTS.equals((BoundingBox)new ReferencedEnvelope(0.0, 1.0, 0.0, 1.0, CRS.decode((String)"EPSG:4326")), (BoundingBox)box.getBounds(), (double)1.0E-6));
    }

    @Test
    public void testEncode() throws Exception {
        Document doc = this.encode(FilterMockData.bbox(), OGC.BBOX);
        Assert.assertEquals((long)1L, (long)doc.getElementsByTagNameNS("http://www.opengis.net/ogc", OGC.PropertyName.getLocalPart()).getLength());
        Assert.assertEquals((long)1L, (long)doc.getElementsByTagNameNS("http://www.opengis.net/gml", GML.Box.getLocalPart()).getLength());
    }
}

