/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.v1_0;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.geotools.filter.v1_0.OGCConfiguration;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Parser;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.filter.Filter;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.DWithin;

public class OGCFilterTest {
    Parser parser;

    @Before
    public void setUp() throws Exception {
        OGCConfiguration configuration = new OGCConfiguration();
        this.parser = new Parser((Configuration)configuration);
    }

    @Test
    public void testRun() throws Exception {
        Object thing = this.parser.parse(this.getClass().getResourceAsStream("test1.xml"));
        Assert.assertNotNull((Object)thing);
        Assert.assertTrue((boolean)(thing instanceof PropertyIsEqualTo));
        PropertyIsEqualTo equal = (PropertyIsEqualTo)thing;
        Assert.assertTrue((boolean)(equal.getExpression1() instanceof PropertyName));
        Assert.assertTrue((boolean)(equal.getExpression2() instanceof Literal));
        PropertyName name = (PropertyName)equal.getExpression1();
        Assert.assertEquals((Object)"testString", (Object)name.getPropertyName());
        Literal literal = (Literal)equal.getExpression2();
        Assert.assertEquals((Object)"2", (Object)literal.toString());
    }

    @Test
    public void testLax() throws Exception {
        String xml = "<Filter>  <PropertyIsEqualTo>    <PropertyName>foo</PropertyName>    <Literal>bar</Literal>  </PropertyIsEqualTo></Filter>";
        Parser parser = new Parser((Configuration)new OGCConfiguration());
        parser.setStrict(false);
        Filter filter = (Filter)parser.parse((InputStream)new ByteArrayInputStream(xml.getBytes()));
        Assert.assertNotNull((Object)filter);
    }

    @Test
    public void testLiteralWithEntity() throws Exception {
        String xml = "<Filter>  <PropertyIsEqualTo>    <PropertyName>foo</PropertyName>    <Literal>bar &gt; 10 and &lt; 20</Literal>  </PropertyIsEqualTo></Filter>";
        Parser parser = new Parser((Configuration)new OGCConfiguration());
        parser.setStrict(false);
        Filter filter = (Filter)parser.parse((InputStream)new ByteArrayInputStream(xml.getBytes()));
        Assert.assertNotNull((Object)filter);
        PropertyIsEqualTo equal = (PropertyIsEqualTo)filter;
        PropertyName pn = (PropertyName)equal.getExpression1();
        Assert.assertEquals((Object)"foo", (Object)pn.getPropertyName());
        Literal literal = (Literal)equal.getExpression2();
        Assert.assertEquals((Object)"bar > 10 and < 20", (Object)literal.getValue());
    }

    @Test
    public void testDWithinParse() throws Exception {
        String xml = "<Filter><DWithin><PropertyName>the_geom</PropertyName><Point><coordinates>-74.817265,40.5296504</coordinates></Point><Distance units=\"km\">200</Distance></DWithin></Filter>";
        OGCConfiguration configuration = new OGCConfiguration();
        Parser parser = new Parser((Configuration)configuration);
        DWithin filter = (DWithin)parser.parse((InputStream)new ByteArrayInputStream(xml.getBytes()));
        Assert.assertNotNull((Object)filter);
        Assert.assertNotNull((Object)filter.getExpression1());
        PropertyName propName = (PropertyName)filter.getExpression1();
        String name = propName.getPropertyName();
        Assert.assertEquals((Object)"the_geom", (Object)name);
        Assert.assertNotNull((Object)filter.getExpression2());
        Literal geom = (Literal)filter.getExpression2();
        Assert.assertEquals((Object)"POINT (-74.817265 40.5296504)", (Object)geom.toString());
        Assert.assertTrue((filter.getDistance() > 0.0 ? 1 : 0) != 0);
        Double dist = filter.getDistance();
        Assert.assertEquals((double)200.0, (double)dist, (double)0.0);
        Assert.assertNotNull((Object)filter.getDistanceUnits());
        String unit = filter.getDistanceUnits();
        Assert.assertEquals((Object)"km", (Object)unit);
    }
}

