/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.v1_0;

import org.geotools.filter.v1_0.FilterMockData;
import org.geotools.filter.v1_0.FilterTestSupport;
import org.geotools.filter.v1_0.OGC;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.w3c.dom.Document;

public class OGCPropertyIsBetweenTypeBindingTest
extends FilterTestSupport {
    @Test
    public void testLowerBoundaryType() {
        Assert.assertEquals(Expression.class, (Object)this.binding(OGC.LowerBoundaryType).getType());
    }

    @Test
    public void testLowerBoundaryExecutionMode() {
        Assert.assertEquals((long)2L, (long)this.binding(OGC.LowerBoundaryType).getExecutionMode());
    }

    @Test
    public void testUpperBoundaryType() {
        Assert.assertEquals(Expression.class, (Object)this.binding(OGC.UpperBoundaryType).getType());
    }

    @Test
    public void testUpperBoundaryExecutionMode() {
        Assert.assertEquals((long)2L, (long)this.binding(OGC.UpperBoundaryType).getExecutionMode());
    }

    @Test
    public void testType() {
        Assert.assertEquals(PropertyIsBetween.class, (Object)this.binding(OGC.PropertyIsBetweenType).getType());
    }

    @Test
    public void testExecutionMode() {
        Assert.assertEquals((long)2L, (long)this.binding(OGC.PropertyIsBetweenType).getExecutionMode());
    }

    @Test
    public void testParse() throws Exception {
        FilterMockData.propertyIsBetween(this.document, this.document);
        PropertyIsBetween between = (PropertyIsBetween)this.parse();
        Assert.assertTrue((boolean)(between.getExpression() instanceof PropertyName));
        Assert.assertTrue((boolean)(between.getLowerBoundary() instanceof Literal));
        Assert.assertTrue((boolean)(between.getUpperBoundary() instanceof Literal));
    }

    @Test
    public void testEncode() throws Exception {
        Document doc = this.encode(FilterMockData.propertyIsBetween(), OGC.PropertyIsBetween);
        Assert.assertEquals((long)1L, (long)doc.getElementsByTagNameNS("http://www.opengis.net/ogc", OGC.PropertyName.getLocalPart()).getLength());
        Assert.assertEquals((long)1L, (long)doc.getElementsByTagNameNS("http://www.opengis.net/ogc", "LowerBoundary").getLength());
        Assert.assertEquals((long)1L, (long)doc.getElementsByTagNameNS("http://www.opengis.net/ogc", "UpperBoundary").getLength());
    }

    @Test
    public void testEncodeAsFilter() throws Exception {
        Document doc = this.encode(FilterMockData.propertyIsBetween(), OGC.Filter);
        Assert.assertEquals((long)1L, (long)doc.getElementsByTagNameNS("http://www.opengis.net/ogc", OGC.PropertyName.getLocalPart()).getLength());
        Assert.assertEquals((long)1L, (long)doc.getElementsByTagNameNS("http://www.opengis.net/ogc", "LowerBoundary").getLength());
        Assert.assertEquals((long)1L, (long)doc.getElementsByTagNameNS("http://www.opengis.net/ogc", "UpperBoundary").getLength());
    }
}

