/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.v1_1;

import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashSet;
import javax.xml.namespace.QName;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.identity.ResourceIdImpl;
import org.geotools.filter.v1_1.OGC;
import org.geotools.gml3.GML;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.Id;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNotEqualTo;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.Divide;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.Multiply;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.expression.Subtract;
import org.opengis.filter.identity.FeatureId;
import org.opengis.filter.identity.GmlObjectId;
import org.opengis.filter.identity.Version;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FilterMockData {
    static FilterFactory2 f = (FilterFactory2)CommonFactoryFinder.getFilterFactory(null);

    public static Id id() {
        return f.id(new LinkedHashSet<FeatureId>(Arrays.asList(f.featureId("foo.1"), f.featureId("foo.2"), f.featureId("foo.3"))));
    }

    public static Id resourceId() {
        ResourceIdImpl resourceId = new ResourceIdImpl("foo.4", "", new Version(Version.Action.NEXT));
        resourceId.setPreviousRid("previousRid");
        resourceId.setStartTime(new Date(1000L));
        resourceId.setEndTime(new Date(2000L));
        Integer testInt = 1234567890;
        return f.id(new LinkedHashSet<FeatureId>(Arrays.asList(f.featureId("foo.1", "v1"), f.resourceId("foo.2", "", new Version(new Date(1000L))), f.resourceId("foo.3", "", new Version(testInt)), resourceId)));
    }

    public static Element propertyName(Document document, Node parent) {
        return FilterMockData.propertyName("foo", document, parent);
    }

    public static Element propertyName(String property, Document document, Node parent) {
        Element propertyName = FilterMockData.element(document, parent, OGC.PropertyName);
        propertyName.appendChild(document.createTextNode(property));
        return propertyName;
    }

    public static PropertyName propertyName() {
        return FilterMockData.propertyName("foo");
    }

    public static PropertyName propertyName(String property) {
        return f.property(property);
    }

    public static Element literal(Document document, Node parent) {
        return FilterMockData.literal("foo", document, parent);
    }

    public static Element literal(String value, Document document, Node parent) {
        Element literal = FilterMockData.element(document, parent, OGC.Literal);
        literal.appendChild(document.createTextNode(value));
        return literal;
    }

    public static Literal literal() {
        return FilterMockData.literal("foo");
    }

    public static Literal literal(Object value) {
        return f.literal(value);
    }

    public static Function function() {
        return f.function("abs", new Expression[]{f.property("foo")});
    }

    static PropertyIsLike propertyIsLike() {
        return f.like((Expression)FilterMockData.propertyName(), "foo", "x", "y", "z", false);
    }

    static Element propertyIsLike(Document document, Node parent) {
        Element isLike = FilterMockData.element(document, parent, OGC.PropertyIsLike);
        FilterMockData.propertyName(document, isLike);
        FilterMockData.literal(document, isLike);
        isLike.setAttribute("wildCard", "x");
        isLike.setAttribute("singleChar", "y");
        isLike.setAttribute("escape", "z");
        isLike.setAttribute("matchCase", "false");
        return isLike;
    }

    public static Element propertyIsEqualTo(Document document, Node parent) {
        return FilterMockData.binaryComparisonOp(document, parent, OGC.PropertyIsEqualTo);
    }

    public static PropertyIsEqualTo propertyIsEqualTo() {
        return f.equals((Expression)FilterMockData.propertyName(), (Expression)FilterMockData.literal());
    }

    public static Element propertyIsNotEqualTo(Document document, Node parent) {
        return FilterMockData.binaryComparisonOp(document, parent, OGC.PropertyIsNotEqualTo);
    }

    public static PropertyIsNotEqualTo propertyIsNotEqualTo() {
        return f.notEqual((Expression)FilterMockData.propertyName(), (Expression)FilterMockData.literal(), false);
    }

    public static Element propertyIsLessThan(Document document, Node parent) {
        return FilterMockData.binaryComparisonOp(document, parent, OGC.PropertyIsLessThan);
    }

    public static PropertyIsLessThan propertyIsLessThan() {
        return f.less((Expression)FilterMockData.propertyName(), (Expression)FilterMockData.literal());
    }

    public static Element propertyIsLessThanOrEqualTo(Document document, Node parent) {
        return FilterMockData.binaryComparisonOp(document, parent, OGC.PropertyIsLessThanOrEqualTo);
    }

    public static PropertyIsLessThanOrEqualTo propertyIsLessThanOrEqualTo() {
        return f.lessOrEqual((Expression)FilterMockData.propertyName(), (Expression)FilterMockData.literal());
    }

    public static Element propertyIsGreaterThan(Document document, Node parent) {
        return FilterMockData.binaryComparisonOp(document, parent, OGC.PropertyIsGreaterThan);
    }

    public static PropertyIsGreaterThan propertyIsGreaterThan() {
        return f.greater((Expression)FilterMockData.propertyName(), (Expression)FilterMockData.literal());
    }

    public static Element propertyIsGreaterThanOrEqualTo(Document document, Node parent) {
        return FilterMockData.binaryComparisonOp(document, parent, OGC.PropertyIsGreaterThanOrEqualTo);
    }

    public static PropertyIsGreaterThanOrEqualTo propertyIsGreaterThanOrEqualTo() {
        return f.greaterOrEqual((Expression)FilterMockData.propertyName(), (Expression)FilterMockData.literal());
    }

    public static Element binaryComparisonOp(Document document, Node parent, QName name) {
        Element binaryComparisonOp = FilterMockData.element(document, parent, name);
        FilterMockData.propertyName(document, binaryComparisonOp);
        FilterMockData.literal(document, binaryComparisonOp);
        return binaryComparisonOp;
    }

    public static Element and(Document document, Node parent) {
        Element and = FilterMockData.element(document, parent, OGC.And);
        FilterMockData.propertyIsEqualTo(document, and);
        FilterMockData.propertyIsNotEqualTo(document, and);
        return and;
    }

    public static And and() {
        return f.and((Filter)FilterMockData.propertyIsEqualTo(), (Filter)FilterMockData.propertyIsNotEqualTo());
    }

    public static Element or(Document document, Node parent) {
        Element or = FilterMockData.element(document, parent, OGC.Or);
        FilterMockData.propertyIsEqualTo(document, or);
        FilterMockData.propertyIsNotEqualTo(document, or);
        return or;
    }

    public static Or or() {
        return f.or((Filter)FilterMockData.propertyIsEqualTo(), (Filter)FilterMockData.propertyIsNotEqualTo());
    }

    public static Not not() {
        return f.not((Filter)FilterMockData.propertyIsEqualTo());
    }

    public static Element not(Document document, Node parent) {
        Element not = FilterMockData.element(document, parent, OGC.Not);
        FilterMockData.propertyIsEqualTo(document, not);
        return not;
    }

    public static BBOX bbox() {
        return f.bbox((Expression)f.property("the_geom"), 5.0, 5.0, 100.0, 100.0, "epsg:4326");
    }

    public static Beyond beyond() {
        return f.beyond((Expression)f.property("the_geom"), (Expression)f.literal((Object)FilterMockData.geometry()), 1.0, "m");
    }

    public static DWithin dwithin() {
        return f.dwithin((Expression)f.property("the_geom"), (Expression)f.literal((Object)FilterMockData.geometry()), 1.0, "m");
    }

    public static Element beyond(Document document, Node parent) {
        return FilterMockData.distanceBufferOperator(document, parent, OGC.Beyond);
    }

    public static Element dwithin(Document document, Node parent) {
        return FilterMockData.distanceBufferOperator(document, parent, OGC.DWithin);
    }

    public static Element distanceBufferOperator(Document document, Node parent, QName name) {
        Element doperator = FilterMockData.binarySpatialOperator(document, parent, name);
        Element distance = FilterMockData.element(document, doperator, new QName("http://www.opengis.net/ogc", "Distance"));
        distance.appendChild(document.createTextNode("1.0"));
        distance.setAttribute("units", "m");
        return doperator;
    }

    public static Element contains(Document document, Node parent) {
        return FilterMockData.binarySpatialOperator(document, parent, OGC.Contains);
    }

    public static Contains contains() {
        return f.contains((Expression)f.property("the_geom"), (Expression)f.literal((Object)FilterMockData.geometry()));
    }

    public static Element crosses(Document document, Node parent) {
        return FilterMockData.binarySpatialOperator(document, parent, OGC.Crosses);
    }

    public static Crosses crosses() {
        return f.crosses((Expression)f.property("the_geom"), (Expression)f.literal((Object)FilterMockData.geometry()));
    }

    public static Element disjoint(Document document, Node parent) {
        return FilterMockData.binarySpatialOperator(document, parent, OGC.Disjoint);
    }

    public static Disjoint disjoint() {
        return f.disjoint((Expression)f.property("the_geom"), (Expression)f.literal((Object)FilterMockData.geometry()));
    }

    public static Element equals(Document document, Node parent) {
        return FilterMockData.binarySpatialOperator(document, parent, OGC.Equals);
    }

    public static Equals equals() {
        return f.equal((Expression)f.property("the_geom"), (Expression)f.literal((Object)FilterMockData.geometry()));
    }

    public static Element intersects(Document document, Node parent) {
        return FilterMockData.binarySpatialOperator(document, parent, OGC.Intersects);
    }

    public static Intersects intersects() {
        return f.intersects((Expression)f.property("the_geom"), (Expression)f.literal((Object)FilterMockData.geometry()));
    }

    public static Element overlaps(Document document, Node parent) {
        return FilterMockData.binarySpatialOperator(document, parent, OGC.Overlaps);
    }

    public static Overlaps overlaps() {
        return f.overlaps((Expression)f.property("the_geom"), (Expression)f.literal((Object)FilterMockData.geometry()));
    }

    public static Element touches(Document document, Node parent) {
        return FilterMockData.binarySpatialOperator(document, parent, OGC.Touches);
    }

    public static Touches touches() {
        return f.touches((Expression)f.property("the_geom"), (Expression)f.literal((Object)FilterMockData.geometry()));
    }

    public static Element within(Document document, Node parent) {
        return FilterMockData.binarySpatialOperator(document, parent, OGC.Within);
    }

    public static Within within() {
        return f.within((Expression)f.property("the_geom"), (Expression)f.literal((Object)FilterMockData.geometry()));
    }

    public static Element binarySpatialOperator(Document document, Node parent, QName name) {
        Element spatial = FilterMockData.element(document, parent, name);
        FilterMockData.propertyName(document, spatial);
        FilterMockData.geometry(document, spatial);
        return spatial;
    }

    public static Geometry geometry() {
        return new GeometryFactory().createPoint(new Coordinate(1.0, 1.0));
    }

    public static Element geometry(Document document, Node parent) {
        Element geometry = FilterMockData.element(document, parent, GML.Point);
        Element pos = FilterMockData.element(document, geometry, GML.pos);
        pos.appendChild(document.createTextNode("1 1"));
        return geometry;
    }

    public static Element envelope(Document document, Node parent) {
        Element envelope = FilterMockData.element(document, parent, GML.Envelope);
        Element lower = FilterMockData.element(document, envelope, new QName("http://www.opengis.net/gml", "lowerCorner"));
        lower.appendChild(document.createTextNode("0 0"));
        Element upper = FilterMockData.element(document, envelope, new QName("http://www.opengis.net/gml", "upperCorner"));
        upper.appendChild(document.createTextNode("1 1"));
        return envelope;
    }

    public static Element add(Document document, Node parent) {
        return FilterMockData.binaryExpression(document, parent, OGC.Add);
    }

    public static Add add() {
        return f.add((Expression)f.literal(1), (Expression)f.literal(2));
    }

    public static Element sub(Document document, Node parent) {
        return FilterMockData.binaryExpression(document, parent, OGC.Sub);
    }

    public static Subtract sub() {
        return f.subtract((Expression)f.literal(1), (Expression)f.literal(2));
    }

    public static Element mul(Document document, Node parent) {
        return FilterMockData.binaryExpression(document, parent, OGC.Mul);
    }

    public static Multiply mul() {
        return f.multiply((Expression)f.literal(1), (Expression)f.literal(2));
    }

    public static Element div(Document document, Node parent) {
        return FilterMockData.binaryExpression(document, parent, OGC.Div);
    }

    public static Divide div() {
        return f.divide((Expression)f.literal(1), (Expression)f.literal(2));
    }

    public static Element binaryExpression(Document document, Node parent, QName name) {
        Element binaryExpression = FilterMockData.element(document, parent, name);
        FilterMockData.literal(document, binaryExpression);
        FilterMockData.literal(document, binaryExpression);
        return binaryExpression;
    }

    public static Element gmlObjectId(Document document, Node parent) {
        Element gmlObjectId = FilterMockData.element(document, parent, OGC.GmlObjectId);
        gmlObjectId.setAttributeNS("http://www.opengis.net/gml", "id", "foo");
        return gmlObjectId;
    }

    public static GmlObjectId gmlObjectId() {
        return f.gmlObjectId("foo");
    }

    public static Element sortBy(Document document, Node parent) {
        Element sortBy = FilterMockData.element(document, parent, OGC.SortBy);
        FilterMockData.sortProperty(document, sortBy);
        FilterMockData.sortProperty(document, sortBy);
        return sortBy;
    }

    public static SortBy[] sortBy() {
        return new SortBy[]{FilterMockData.sortProperty(), FilterMockData.sortProperty()};
    }

    public static Element sortProperty(Document document, Node parent) {
        Element sortProperty = FilterMockData.element(document, parent, new QName("http://www.opengis.net/ogc", "SortProperty"));
        FilterMockData.propertyName(document, sortProperty);
        FilterMockData.sortOrder(document, sortProperty);
        return sortProperty;
    }

    public static SortBy sortProperty() {
        return f.sort("foo", SortOrder.ASCENDING);
    }

    public static Element sortOrder(Document document, Node parent) {
        Element sortOrder = FilterMockData.element(document, parent, new QName("http://www.opengis.net/ogc", "SortOrder"));
        sortOrder.appendChild(document.createTextNode("ASC"));
        return sortOrder;
    }

    public static Element element(Document document, Node parent, QName name) {
        Element element = document.createElementNS(name.getNamespaceURI(), name.getLocalPart());
        if (parent != null) {
            parent.appendChild(element);
        }
        return element;
    }
}

