/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.v1_0;

import org.geotools.filter.v1_0.FilterMockData;
import org.geotools.filter.v1_0.FilterTestSupport;
import org.geotools.filter.v1_0.OGC;
import org.opengis.filter.And;
import org.opengis.filter.BinaryLogicOperator;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BinaryLogicOpTypeBindingTest
extends FilterTestSupport {
    public void testBinaryLogicOpType() {
        BinaryLogicOpTypeBindingTest.assertEquals(BinaryLogicOperator.class, (Object)this.binding(OGC.BinaryLogicOpType).getType());
    }

    public void testAndType() {
        BinaryLogicOpTypeBindingTest.assertEquals(And.class, (Object)this.binding(OGC.And).getType());
    }

    public void testAndExecutionMode() {
        BinaryLogicOpTypeBindingTest.assertEquals((int)0, (int)this.binding(OGC.And).getExecutionMode());
    }

    public void testAndParse() throws Exception {
        FilterMockData.and(this.document, this.document);
        And and = (And)this.parse();
        BinaryLogicOpTypeBindingTest.assertEquals((int)2, (int)and.getChildren().size());
    }

    public void testAndEncode() throws Exception {
        Document dom = this.encode(FilterMockData.and(), OGC.And);
        BinaryLogicOpTypeBindingTest.assertEquals((int)1, (int)dom.getElementsByTagNameNS("http://www.opengis.net/ogc", OGC.PropertyIsEqualTo.getLocalPart()).getLength());
        BinaryLogicOpTypeBindingTest.assertEquals((int)1, (int)dom.getElementsByTagNameNS("http://www.opengis.net/ogc", OGC.PropertyIsNotEqualTo.getLocalPart()).getLength());
    }

    public void testOrType() {
        BinaryLogicOpTypeBindingTest.assertEquals(Or.class, (Object)this.binding(OGC.Or).getType());
    }

    public void testOrExecutionMode() {
        BinaryLogicOpTypeBindingTest.assertEquals((int)0, (int)this.binding(OGC.Or).getExecutionMode());
    }

    public void testOrParse() throws Exception {
        FilterMockData.or(this.document, this.document);
        Or or = (Or)this.parse();
        BinaryLogicOpTypeBindingTest.assertEquals((int)2, (int)or.getChildren().size());
    }

    public void testOrEncode() throws Exception {
        Document dom = this.encode(FilterMockData.or(), OGC.Or);
        BinaryLogicOpTypeBindingTest.assertEquals((int)1, (int)dom.getElementsByTagNameNS("http://www.opengis.net/ogc", OGC.PropertyIsEqualTo.getLocalPart()).getLength());
        BinaryLogicOpTypeBindingTest.assertEquals((int)1, (int)dom.getElementsByTagNameNS("http://www.opengis.net/ogc", OGC.PropertyIsNotEqualTo.getLocalPart()).getLength());
    }

    public void testAndWithLikeParse() throws Exception {
        Element e = FilterMockData.and(this.document, this.document, true);
        FilterMockData.propertyIsLike(this.document, e);
        FilterMockData.propertyIsLike(this.document, e);
        And and = (And)this.parse();
        BinaryLogicOpTypeBindingTest.assertEquals((int)2, (int)and.getChildren().size());
        BinaryLogicOpTypeBindingTest.assertTrue((boolean)(and.getChildren().get(0) instanceof PropertyIsLike));
        BinaryLogicOpTypeBindingTest.assertTrue((boolean)(and.getChildren().get(1) instanceof PropertyIsLike));
    }

    public void testAndWithLikeEncode() throws Exception {
        FilterFactory2 f = FilterMockData.f;
        And and = f.and((Filter)FilterMockData.propertyIsLike(), (Filter)FilterMockData.propertyIsLike());
        Document dom = this.encode(and, OGC.And);
        BinaryLogicOpTypeBindingTest.assertEquals((int)2, (int)this.getElementsByQName(dom, OGC.PropertyIsLike).getLength());
    }

    public void testAndWithNullParse() throws Exception {
        Element e = FilterMockData.and(this.document, this.document, true);
        FilterMockData.propertyisNull(this.document, e);
        FilterMockData.propertyisNull(this.document, e);
        And and = (And)this.parse();
        BinaryLogicOpTypeBindingTest.assertEquals((int)2, (int)and.getChildren().size());
        BinaryLogicOpTypeBindingTest.assertTrue((boolean)(and.getChildren().get(0) instanceof PropertyIsNull));
        BinaryLogicOpTypeBindingTest.assertTrue((boolean)(and.getChildren().get(1) instanceof PropertyIsNull));
    }

    public void testAndWithNullEncode() throws Exception {
        FilterFactory2 f = FilterMockData.f;
        And and = f.and((Filter)FilterMockData.propertyIsNull(), (Filter)FilterMockData.propertyIsNull());
        Document dom = this.encode(and, OGC.And);
        BinaryLogicOpTypeBindingTest.assertEquals((int)2, (int)this.getElementsByQName(dom, OGC.PropertyIsNull).getLength());
    }

    public void testAndWithBetweenParse() throws Exception {
        Element e = FilterMockData.and(this.document, this.document, true);
        FilterMockData.propertyIsBetween(this.document, e);
        FilterMockData.propertyIsBetween(this.document, e);
        And and = (And)this.parse();
        BinaryLogicOpTypeBindingTest.assertEquals((int)2, (int)and.getChildren().size());
        BinaryLogicOpTypeBindingTest.assertTrue((boolean)(and.getChildren().get(0) instanceof PropertyIsBetween));
        BinaryLogicOpTypeBindingTest.assertTrue((boolean)(and.getChildren().get(1) instanceof PropertyIsBetween));
    }

    public void testAndWithBetweenEncode() throws Exception {
        FilterFactory2 f = FilterMockData.f;
        And and = f.and((Filter)FilterMockData.propertyIsBetween(), (Filter)FilterMockData.propertyIsBetween());
        Document dom = this.encode(and, OGC.And);
        BinaryLogicOpTypeBindingTest.assertEquals((int)2, (int)this.getElementsByQName(dom, OGC.PropertyIsBetween).getLength());
    }
}

