/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.v1_0;

import org.geotools.filter.v1_0.FilterMockData;
import org.geotools.filter.v1_0.FilterTestSupport;
import org.geotools.filter.v1_0.OGC;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.gml2.GML;
import org.geotools.referencing.CRS;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BBOX;
import org.opengis.geometry.BoundingBox;
import org.w3c.dom.Document;

public class OGCBBoxTypeBindingTest
extends FilterTestSupport {
    public void testType() {
        OGCBBoxTypeBindingTest.assertEquals(BBOX.class, (Object)this.binding(OGC.BBOXType).getType());
    }

    public void testExecutionMode() {
        OGCBBoxTypeBindingTest.assertEquals((int)2, (int)this.binding(OGC.BBOXType).getExecutionMode());
    }

    public void testParse() throws Exception {
        FilterMockData.bbox(this.document, this.document);
        BBOX box = (BBOX)this.parse();
        OGCBBoxTypeBindingTest.assertEquals((String)"foo", (String)((PropertyName)box.getExpression1()).getPropertyName());
        OGCBBoxTypeBindingTest.assertTrue((boolean)JTS.equals((BoundingBox)new ReferencedEnvelope(0.0, 1.0, 0.0, 1.0, CRS.decode((String)"EPSG:4326")), (BoundingBox)box.getBounds(), (double)1.0E-6));
    }

    public void testEncode() throws Exception {
        Document doc = this.encode(FilterMockData.bbox(), OGC.BBOX);
        OGCBBoxTypeBindingTest.assertEquals((int)1, (int)doc.getElementsByTagNameNS("http://www.opengis.net/ogc", OGC.PropertyName.getLocalPart()).getLength());
        OGCBBoxTypeBindingTest.assertEquals((int)1, (int)doc.getElementsByTagNameNS("http://www.opengis.net/gml", GML.Box.getLocalPart()).getLength());
    }
}

