/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.v1_0;

import org.geotools.filter.v1_0.FilterMockData;
import org.geotools.filter.v1_0.FilterTestSupport;
import org.geotools.filter.v1_0.OGC;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.spatial.Intersects;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OGCFilterTypeBindingTest
extends FilterTestSupport {
    public void testType() {
        OGCFilterTypeBindingTest.assertEquals(Filter.class, (Object)this.binding(OGC.FilterType).getType());
    }

    public void testExecutionMode() {
        OGCFilterTypeBindingTest.assertEquals((int)2, (int)this.binding(OGC.FilterType).getExecutionMode());
    }

    public void testParseSpatial() throws Exception {
        Element filterElement = FilterMockData.element(this.document, this.document, OGC.Filter);
        FilterMockData.intersects(this.document, filterElement);
        Filter filter = (Filter)this.parse();
        OGCFilterTypeBindingTest.assertTrue((boolean)(filter instanceof Intersects));
    }

    public void testEncodeSpatial() throws Exception {
        Document doc = this.encode(FilterMockData.intersects(), OGC.Filter);
        OGCFilterTypeBindingTest.assertEquals((String)"ogc:Filter", (String)doc.getDocumentElement().getNodeName());
        OGCFilterTypeBindingTest.assertEquals((int)1, (int)doc.getElementsByTagNameNS("http://www.opengis.net/ogc", "Intersects").getLength());
    }

    public void testParseComparison() throws Exception {
        Element filterElement = FilterMockData.element(this.document, this.document, OGC.Filter);
        FilterMockData.propertyIsEqualTo(this.document, filterElement);
        Filter filter = (Filter)this.parse();
        OGCFilterTypeBindingTest.assertTrue((boolean)(filter instanceof PropertyIsEqualTo));
    }

    public void testEncodeComparison() throws Exception {
        Document doc = this.encode(FilterMockData.propertyIsEqualTo(), OGC.Filter);
        OGCFilterTypeBindingTest.assertEquals((String)"ogc:Filter", (String)doc.getDocumentElement().getNodeName());
        OGCFilterTypeBindingTest.assertEquals((int)1, (int)doc.getElementsByTagNameNS("http://www.opengis.net/ogc", "PropertyIsEqualTo").getLength());
    }

    public void testParseLogical() throws Exception {
        Element filterElement = FilterMockData.element(this.document, this.document, OGC.Filter);
        FilterMockData.and(this.document, filterElement);
        Filter filter = (Filter)this.parse();
        OGCFilterTypeBindingTest.assertTrue((boolean)(filter instanceof And));
    }

    public void testEncodeLogical() throws Exception {
        Document doc = this.encode(FilterMockData.and(), OGC.Filter);
        OGCFilterTypeBindingTest.assertEquals((String)"ogc:Filter", (String)doc.getDocumentElement().getNodeName());
        OGCFilterTypeBindingTest.assertEquals((int)1, (int)doc.getElementsByTagNameNS("http://www.opengis.net/ogc", "And").getLength());
        doc = this.encode(FilterMockData.not(), OGC.Filter);
        OGCFilterTypeBindingTest.assertEquals((String)"ogc:Filter", (String)doc.getDocumentElement().getNodeName());
        OGCFilterTypeBindingTest.assertEquals((int)1, (int)doc.getElementsByTagNameNS("http://www.opengis.net/ogc", "Not").getLength());
    }
}

