/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.v1_1;

import org.geotools.filter.v1_1.FilterMockData;
import org.geotools.filter.v1_1.FilterTestSupport;
import org.geotools.filter.v1_1.OGC;
import org.geotools.gml3.GML;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.DistanceBufferOperator;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;
import org.w3c.dom.Document;

public class BinarySpatialOpTypeBindingTest
extends FilterTestSupport {
    public void testDistanceBufferType() {
        BinarySpatialOpTypeBindingTest.assertEquals(DistanceBufferOperator.class, (Object)this.binding(OGC.DistanceBufferType).getType());
    }

    public void testBeyondType() {
        BinarySpatialOpTypeBindingTest.assertEquals(Beyond.class, (Object)this.binding(OGC.Beyond).getType());
    }

    public void testBeyondParse() throws Exception {
        FilterMockData.beyond(this.document, this.document);
        Beyond beyond = (Beyond)this.parse();
        BinarySpatialOpTypeBindingTest.assertNotNull((Object)beyond.getExpression1());
        BinarySpatialOpTypeBindingTest.assertNotNull((Object)beyond.getExpression2());
        BinarySpatialOpTypeBindingTest.assertEquals((double)1.0, (double)beyond.getDistance(), (double)0.1);
        BinarySpatialOpTypeBindingTest.assertEquals((String)"m", (String)beyond.getDistanceUnits());
    }

    public void testBeyondEncode() throws Exception {
        Document dom = this.encode(FilterMockData.beyond(), OGC.Beyond);
        BinarySpatialOpTypeBindingTest.assertEquals((int)1, (int)dom.getElementsByTagNameNS("http://www.opengis.net/ogc", OGC.PropertyName.getLocalPart()).getLength());
        BinarySpatialOpTypeBindingTest.assertEquals((int)1, (int)dom.getElementsByTagNameNS("http://www.opengis.net/gml", GML.Point.getLocalPart()).getLength());
        BinarySpatialOpTypeBindingTest.assertEquals((int)1, (int)dom.getElementsByTagNameNS("http://www.opengis.net/ogc", "Distance").getLength());
        BinarySpatialOpTypeBindingTest.assertEquals((String)"1.0", (String)dom.getElementsByTagNameNS("http://www.opengis.net/ogc", "Distance").item(0).getFirstChild().getNodeValue());
    }

    public void testDWithinType() {
        BinarySpatialOpTypeBindingTest.assertEquals(DWithin.class, (Object)this.binding(OGC.DWithin).getType());
    }

    public void testDWithinParse() throws Exception {
        FilterMockData.dwithin(this.document, this.document);
        DWithin dwithin = (DWithin)this.parse();
        BinarySpatialOpTypeBindingTest.assertNotNull((Object)dwithin.getExpression1());
        BinarySpatialOpTypeBindingTest.assertNotNull((Object)dwithin.getExpression2());
        BinarySpatialOpTypeBindingTest.assertEquals((double)1.0, (double)dwithin.getDistance(), (double)0.1);
        BinarySpatialOpTypeBindingTest.assertEquals((String)"m", (String)dwithin.getDistanceUnits());
    }

    public void testDWithinEncode() throws Exception {
        Document dom = this.encode(FilterMockData.beyond(), OGC.DWithin);
        BinarySpatialOpTypeBindingTest.assertEquals((int)1, (int)dom.getElementsByTagNameNS("http://www.opengis.net/ogc", OGC.PropertyName.getLocalPart()).getLength());
        BinarySpatialOpTypeBindingTest.assertEquals((int)1, (int)dom.getElementsByTagNameNS("http://www.opengis.net/gml", GML.Point.getLocalPart()).getLength());
        BinarySpatialOpTypeBindingTest.assertEquals((int)1, (int)dom.getElementsByTagNameNS("http://www.opengis.net/ogc", "Distance").getLength());
        BinarySpatialOpTypeBindingTest.assertEquals((String)"1.0", (String)dom.getElementsByTagNameNS("http://www.opengis.net/ogc", "Distance").item(0).getFirstChild().getNodeValue());
    }

    public void testBinarySpatialOpType() {
        BinarySpatialOpTypeBindingTest.assertEquals(BinarySpatialOperator.class, (Object)this.binding(OGC.BinarySpatialOpType).getType());
    }

    public void testContainsType() {
        BinarySpatialOpTypeBindingTest.assertEquals(Contains.class, (Object)this.binding(OGC.Contains).getType());
    }

    public void testContainsParse() throws Exception {
        FilterMockData.contains(this.document, this.document);
        Contains contains = (Contains)this.parse();
        BinarySpatialOpTypeBindingTest.assertNotNull((Object)contains.getExpression1());
        BinarySpatialOpTypeBindingTest.assertNotNull((Object)contains.getExpression2());
    }

    public void testContainsEncode() throws Exception {
        Document dom = this.encode(FilterMockData.contains(), OGC.Contains);
        BinarySpatialOpTypeBindingTest.assertEquals((int)1, (int)dom.getElementsByTagNameNS("http://www.opengis.net/ogc", OGC.PropertyName.getLocalPart()).getLength());
        BinarySpatialOpTypeBindingTest.assertEquals((int)1, (int)dom.getElementsByTagNameNS("http://www.opengis.net/gml", GML.Point.getLocalPart()).getLength());
    }

    public void testCrossesType() {
        BinarySpatialOpTypeBindingTest.assertEquals(Crosses.class, (Object)this.binding(OGC.Crosses).getType());
    }

    public void testCrossesParse() throws Exception {
        FilterMockData.crosses(this.document, this.document);
        Crosses crosses = (Crosses)this.parse();
        BinarySpatialOpTypeBindingTest.assertNotNull((Object)crosses.getExpression1());
        BinarySpatialOpTypeBindingTest.assertNotNull((Object)crosses.getExpression2());
    }

    public void testCrossesEncode() throws Exception {
        Document dom = this.encode(FilterMockData.crosses(), OGC.Crosses);
        BinarySpatialOpTypeBindingTest.assertEquals((int)1, (int)dom.getElementsByTagNameNS("http://www.opengis.net/ogc", OGC.PropertyName.getLocalPart()).getLength());
        BinarySpatialOpTypeBindingTest.assertEquals((int)1, (int)dom.getElementsByTagNameNS("http://www.opengis.net/gml", GML.Point.getLocalPart()).getLength());
    }

    public void testDisjointType() {
        BinarySpatialOpTypeBindingTest.assertEquals(Disjoint.class, (Object)this.binding(OGC.Disjoint).getType());
    }

    public void testDisjointParse() throws Exception {
        FilterMockData.disjoint(this.document, this.document);
        Disjoint disjoint = (Disjoint)this.parse();
        BinarySpatialOpTypeBindingTest.assertNotNull((Object)disjoint.getExpression1());
        BinarySpatialOpTypeBindingTest.assertNotNull((Object)disjoint.getExpression2());
    }

    public void testDisjointEncode() throws Exception {
        Document dom = this.encode(FilterMockData.disjoint(), OGC.Disjoint);
        BinarySpatialOpTypeBindingTest.assertEquals((int)1, (int)dom.getElementsByTagNameNS("http://www.opengis.net/ogc", OGC.PropertyName.getLocalPart()).getLength());
        BinarySpatialOpTypeBindingTest.assertEquals((int)1, (int)dom.getElementsByTagNameNS("http://www.opengis.net/gml", GML.Point.getLocalPart()).getLength());
    }

    public void testEqualsType() {
        BinarySpatialOpTypeBindingTest.assertEquals(Equals.class, (Object)this.binding(OGC.Equals).getType());
    }

    public void testEqualsParse() throws Exception {
        FilterMockData.equals(this.document, this.document);
        Equals equals = (Equals)this.parse();
        BinarySpatialOpTypeBindingTest.assertNotNull((Object)equals.getExpression1());
        BinarySpatialOpTypeBindingTest.assertNotNull((Object)equals.getExpression2());
    }

    public void testEqualsEncode() throws Exception {
        Document dom = this.encode(FilterMockData.equals(), OGC.Equals);
        BinarySpatialOpTypeBindingTest.assertEquals((int)1, (int)dom.getElementsByTagNameNS("http://www.opengis.net/ogc", OGC.PropertyName.getLocalPart()).getLength());
        BinarySpatialOpTypeBindingTest.assertEquals((int)1, (int)dom.getElementsByTagNameNS("http://www.opengis.net/gml", GML.Point.getLocalPart()).getLength());
    }

    public void testIntersectsType() {
        BinarySpatialOpTypeBindingTest.assertEquals(Intersects.class, (Object)this.binding(OGC.Intersects).getType());
    }

    public void testIntersectsParse() throws Exception {
        FilterMockData.intersects(this.document, this.document);
        Intersects intersects = (Intersects)this.parse();
        BinarySpatialOpTypeBindingTest.assertNotNull((Object)intersects.getExpression1());
        BinarySpatialOpTypeBindingTest.assertNotNull((Object)intersects.getExpression2());
    }

    public void testIntersectsEncode() throws Exception {
        Document dom = this.encode(FilterMockData.intersects(), OGC.Intersects);
        BinarySpatialOpTypeBindingTest.assertEquals((int)1, (int)dom.getElementsByTagNameNS("http://www.opengis.net/ogc", OGC.PropertyName.getLocalPart()).getLength());
        BinarySpatialOpTypeBindingTest.assertEquals((int)1, (int)dom.getElementsByTagNameNS("http://www.opengis.net/gml", GML.Point.getLocalPart()).getLength());
    }

    public void testOverlapsType() {
        BinarySpatialOpTypeBindingTest.assertEquals(Overlaps.class, (Object)this.binding(OGC.Overlaps).getType());
    }

    public void testOverlapsParse() throws Exception {
        FilterMockData.overlaps(this.document, this.document);
        Overlaps overlaps = (Overlaps)this.parse();
        BinarySpatialOpTypeBindingTest.assertNotNull((Object)overlaps.getExpression1());
        BinarySpatialOpTypeBindingTest.assertNotNull((Object)overlaps.getExpression2());
    }

    public void testOverlapsEncode() throws Exception {
        Document dom = this.encode(FilterMockData.overlaps(), OGC.Overlaps);
        BinarySpatialOpTypeBindingTest.assertEquals((int)1, (int)dom.getElementsByTagNameNS("http://www.opengis.net/ogc", OGC.PropertyName.getLocalPart()).getLength());
        BinarySpatialOpTypeBindingTest.assertEquals((int)1, (int)dom.getElementsByTagNameNS("http://www.opengis.net/gml", GML.Point.getLocalPart()).getLength());
    }

    public void testTouchesType() {
        BinarySpatialOpTypeBindingTest.assertEquals(Touches.class, (Object)this.binding(OGC.Touches).getType());
    }

    public void testTouchesParse() throws Exception {
        FilterMockData.touches(this.document, this.document);
        Touches touches = (Touches)this.parse();
        BinarySpatialOpTypeBindingTest.assertNotNull((Object)touches.getExpression1());
        BinarySpatialOpTypeBindingTest.assertNotNull((Object)touches.getExpression2());
    }

    public void testTouchesEncode() throws Exception {
        Document dom = this.encode(FilterMockData.touches(), OGC.Touches);
        BinarySpatialOpTypeBindingTest.assertEquals((int)1, (int)dom.getElementsByTagNameNS("http://www.opengis.net/ogc", OGC.PropertyName.getLocalPart()).getLength());
        BinarySpatialOpTypeBindingTest.assertEquals((int)1, (int)dom.getElementsByTagNameNS("http://www.opengis.net/gml", GML.Point.getLocalPart()).getLength());
    }

    public void testWithinType() {
        BinarySpatialOpTypeBindingTest.assertEquals(Within.class, (Object)this.binding(OGC.Within).getType());
    }

    public void testWithinParse() throws Exception {
        FilterMockData.within(this.document, this.document);
        Within within = (Within)this.parse();
        BinarySpatialOpTypeBindingTest.assertNotNull((Object)within.getExpression1());
        BinarySpatialOpTypeBindingTest.assertNotNull((Object)within.getExpression2());
    }

    public void testWithinEncode() throws Exception {
        Document dom = this.encode(FilterMockData.within(), OGC.Within);
        BinarySpatialOpTypeBindingTest.assertEquals((int)1, (int)dom.getElementsByTagNameNS("http://www.opengis.net/ogc", OGC.PropertyName.getLocalPart()).getLength());
        BinarySpatialOpTypeBindingTest.assertEquals((int)1, (int)dom.getElementsByTagNameNS("http://www.opengis.net/gml", GML.Point.getLocalPart()).getLength());
    }
}

