/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml2.bindings;

import java.net.URI;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.geotools.gml2.GML;
import org.geotools.gml2.bindings.GML2EncodingUtils;
import org.geotools.referencing.CRS;
import org.geotools.xsd.AbstractComplexBinding;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.Node;
import org.locationtech.jts.geom.Geometry;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GMLAbstractGeometryTypeBinding
extends AbstractComplexBinding {
    Logger logger;

    public GMLAbstractGeometryTypeBinding(Logger logger) {
        this.logger = logger;
    }

    public QName getTarget() {
        return GML.AbstractGeometryType;
    }

    public int getExecutionMode() {
        return 2;
    }

    public Class getType() {
        return Geometry.class;
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        if (value instanceof Geometry) {
            Geometry geometry = (Geometry)value;
            if (node.hasAttribute("srsName")) {
                URI srs = (URI)node.getAttributeValue("srsName");
                CoordinateReferenceSystem crs = CRS.decode((String)srs.toString());
                if (crs != null) {
                    geometry.setUserData((Object)crs);
                } else {
                    this.logger.warning("Could not create Coordinate Reference System for " + srs);
                }
            }
        }
        return value;
    }

    public Object getProperty(Object object, QName name) throws Exception {
        Geometry geometry;
        if ("srsName".equals(name.getLocalPart()) && (geometry = (Geometry)object).getUserData() instanceof CoordinateReferenceSystem) {
            return GML2EncodingUtils.toURI((CoordinateReferenceSystem)geometry.getUserData());
        }
        return null;
    }
}

