/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import org.geotools.gml3.GML;
import org.geotools.gml3.GML3TestSupport;
import org.geotools.gml3.bindings.GML3MockData;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineString;
import org.w3c.dom.Document;

public class LineStringTypeBindingTest
extends GML3TestSupport {
    public void testPos() throws Exception {
        this.document.appendChild(GML3MockData.lineStringWithPos(this.document, null));
        LineString line = (LineString)this.parse();
        LineStringTypeBindingTest.assertNotNull((Object)line);
        LineStringTypeBindingTest.assertEquals((Object)new Coordinate(1.0, 2.0), (Object)line.getPointN(0).getCoordinate());
        LineStringTypeBindingTest.assertEquals((Object)new Coordinate(3.0, 4.0), (Object)line.getPointN(1).getCoordinate());
    }

    public void testPos3D() throws Exception {
        this.document.appendChild(GML3MockData.lineStringWithPos3D(this.document, null));
        LineString line = (LineString)this.parse();
        LineStringTypeBindingTest.assertNotNull((Object)line);
        LineStringTypeBindingTest.assertTrue((boolean)new Coordinate(1.0, 2.0, 10.0).equals3D(line.getPointN(0).getCoordinate()));
        LineStringTypeBindingTest.assertTrue((boolean)new Coordinate(3.0, 4.0, 20.0).equals3D(line.getPointN(1).getCoordinate()));
    }

    public void testPosList() throws Exception {
        this.document.appendChild(GML3MockData.lineStringWithPosList(this.document, null));
        LineString line = (LineString)this.parse();
        LineStringTypeBindingTest.assertNotNull((Object)line);
        LineStringTypeBindingTest.assertEquals((Object)new Coordinate(1.0, 2.0), (Object)line.getPointN(0).getCoordinate());
        LineStringTypeBindingTest.assertEquals((Object)new Coordinate(3.0, 4.0), (Object)line.getPointN(1).getCoordinate());
    }

    public void testPosList3D() throws Exception {
        this.document.appendChild(GML3MockData.lineStringWithPosList3D(this.document, null));
        LineString line = (LineString)this.parse();
        LineStringTypeBindingTest.assertNotNull((Object)line);
        LineStringTypeBindingTest.assertTrue((boolean)new Coordinate(1.0, 2.0, 10.0).equals3D(line.getPointN(0).getCoordinate()));
        LineStringTypeBindingTest.assertTrue((boolean)new Coordinate(3.0, 4.0, 20.0).equals3D(line.getPointN(1).getCoordinate()));
    }

    public void testEncodeLineString() throws Exception {
        LineString line = GML3MockData.lineString();
        Document doc = this.encode(line, GML.LineString);
        this.checkDimension(doc, GML.LineString.getLocalPart(), 2);
        this.checkPosListOrdinates(doc, 2 * line.getNumPoints());
    }

    public void testEncodeLite2D() throws Exception {
        LineString line = GML3MockData.lineStringLite2D();
        Document doc = this.encode(line, GML.LineString);
        this.checkDimension(doc, GML.LineString.getLocalPart(), 2);
        this.checkPosListOrdinates(doc, 2 * line.getNumPoints());
    }

    public void testEncodeLite3D() throws Exception {
        LineString line = GML3MockData.lineStringLite3D();
        Document doc = this.encode(line, GML.LineString);
        this.checkDimension(doc, GML.LineString.getLocalPart(), 3);
        this.checkPosListOrdinates(doc, 3 * line.getNumPoints());
    }

    public void testEncode2DLong() throws Exception {
        LineString line = GML3MockData.lineStringLite2D(10);
        Document doc = this.encode(line, GML.LineString);
        this.checkDimension(doc, GML.LineString.getLocalPart(), 2);
        this.checkPosListOrdinates(doc, 2 * line.getNumPoints());
    }
}

