/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Calendar;
import java.util.TimeZone;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import junit.framework.TestCase;
import org.geotools.geometry.jts.coordinatesequence.CoordinateSequences;
import org.geotools.gml3.GMLConfiguration;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Parser;
import org.geotools.xsd.StreamingParser;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.WKTReader;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.temporal.Period;
import org.w3c.dom.Document;

public class GML3ParsingTest
extends TestCase {
    public void testWithoutSchema() throws Exception {
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("states.xml");
        GMLConfiguration gml = new GMLConfiguration();
        StreamingParser parser = new StreamingParser((Configuration)gml, in, SimpleFeature.class);
        int nfeatures = 0;
        SimpleFeature f = null;
        while ((f = (SimpleFeature)parser.parse()) != null) {
            ++nfeatures;
            GML3ParsingTest.assertNotNull((Object)f.getAttribute("STATE_NAME"));
            GML3ParsingTest.assertNotNull((Object)f.getAttribute("STATE_ABBR"));
            GML3ParsingTest.assertTrue((boolean)(f.getAttribute("SAMP_POP") instanceof String));
        }
        GML3ParsingTest.assertEquals((int)49, (int)nfeatures);
    }

    public void testWithSchema() throws Exception {
        DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        File xsd = new File("target/states.xsd");
        Document schema = db.parse(((Object)((Object)this)).getClass().getResourceAsStream("states.xsd"));
        Transformer tx = TransformerFactory.newInstance().newTransformer();
        tx.transform(new DOMSource(schema), new StreamResult(xsd));
        Document instance = db.parse(((Object)((Object)this)).getClass().getResourceAsStream("states.xml"));
        instance.getDocumentElement().setAttribute("schemaLocation", "http://www.openplans.org/topp target/states.xsd");
        File xml = new File("target/states.xml");
        tx.transform(new DOMSource(instance), new StreamResult(xml));
        FileInputStream in = new FileInputStream(xml);
        GMLConfiguration gml = new GMLConfiguration();
        StreamingParser parser = new StreamingParser((Configuration)gml, (InputStream)in, SimpleFeature.class);
        int nfeatures = 0;
        SimpleFeature f = null;
        while ((f = (SimpleFeature)parser.parse()) != null) {
            ++nfeatures;
            GML3ParsingTest.assertNotNull((Object)f.getAttribute("STATE_NAME"));
            GML3ParsingTest.assertNotNull((Object)f.getAttribute("STATE_ABBR"));
            GML3ParsingTest.assertTrue((boolean)(f.getAttribute("SAMP_POP") instanceof Double));
        }
        GML3ParsingTest.assertEquals((int)49, (int)nfeatures);
    }

    public void testParse3D() throws Exception {
        Parser p = new Parser((Configuration)new GMLConfiguration());
        Object g = p.parse(GML3ParsingTest.class.getResourceAsStream("polygon3d.xml"));
        Assert.assertThat((Object)g, (Matcher)CoreMatchers.instanceOf(Polygon.class));
        Polygon polygon = (Polygon)g;
        GML3ParsingTest.assertEquals((int)3, (int)CoordinateSequences.coordinateDimension((Geometry)polygon));
        Geometry expected = new WKTReader().read("POLYGON((94000 471000 10, 94001 471000 11, 94001 471001 12, 94000 471001 13, 94000 471000 10))");
        GML3ParsingTest.assertTrue((boolean)CoordinateSequences.equalsND((Geometry)expected, (Geometry)polygon));
    }

    public void testParseTimePeriodByPosition() throws Exception {
        Parser p = new Parser((Configuration)new GMLConfiguration());
        Object g = p.parse(GML3ParsingTest.class.getResourceAsStream("timePeriodByPosition.xml"));
        Assert.assertThat((Object)g, (Matcher)CoreMatchers.instanceOf(Period.class));
        Period period = (Period)g;
        TimeZone gmt = TimeZone.getTimeZone("GMT");
        Calendar calendar = Calendar.getInstance(gmt);
        calendar.clear();
        calendar.set(2006, 5, 28, 4, 8, 0);
        GML3ParsingTest.assertEquals((Object)calendar.getTime(), (Object)period.getBeginning().getPosition().getDate());
        calendar.set(2009, 5, 28, 6, 8, 0);
        GML3ParsingTest.assertEquals((Object)calendar.getTime(), (Object)period.getEnding().getPosition().getDate());
    }
}

