/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import org.geotools.gml3.GML;
import org.geotools.gml3.GML3TestSupport;
import org.geotools.gml3.bindings.GML3MockData;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Polygon;
import org.w3c.dom.Document;

public class PolygonTypeBindingTest
extends GML3TestSupport {
    @Override
    protected boolean enableExtendedArcSurfaceSupport() {
        return true;
    }

    public void testNoInterior() throws Exception {
        GML3MockData.polygon(this.document, this.document);
        Polygon polygon = (Polygon)this.parse();
        PolygonTypeBindingTest.assertNotNull((Object)polygon);
    }

    public void testPolygon3D() throws Exception {
        GML3MockData.polygon3D(this.document, this.document, true);
        Polygon polygon = (Polygon)this.parse();
        PolygonTypeBindingTest.assertNotNull((Object)polygon);
        LineString exterior = polygon.getExteriorRing();
        PolygonTypeBindingTest.assertTrue((boolean)new Coordinate(1.0, 2.0, 10.0).equals3D(exterior.getCoordinateN(0)));
        LineString interior = polygon.getInteriorRingN(0);
        PolygonTypeBindingTest.assertTrue((boolean)new Coordinate(1.0, 2.0, 10.0).equals3D(interior.getCoordinateN(0)));
    }

    public void testPolygonPosList3D() throws Exception {
        GML3MockData.polygonWithPosList3D(this.document, this.document, true);
        Polygon polygon = (Polygon)this.parse();
        PolygonTypeBindingTest.assertNotNull((Object)polygon);
        LineString exterior = polygon.getExteriorRing();
        PolygonTypeBindingTest.assertTrue((boolean)new Coordinate(1.0, 2.0, 10.0).equals3D(exterior.getCoordinateN(0)));
        LineString interior = polygon.getInteriorRingN(0);
        PolygonTypeBindingTest.assertTrue((boolean)new Coordinate(1.0, 2.0, 10.0).equals3D(interior.getCoordinateN(0)));
    }

    public void testEncode3D() throws Exception {
        Polygon poly = GML3MockData.polygonLite3D();
        Document doc = this.encode(poly, GML.Polygon);
        this.checkDimension(doc, GML.Polygon.getLocalPart(), 3);
        this.checkPosListOrdinates(doc, 3 * poly.getNumPoints());
    }

    public void testEncode2D() throws Exception {
        Polygon poly = GML3MockData.polygonLite2D();
        Document doc = this.encode(poly, GML.Polygon);
        this.checkDimension(doc, GML.Polygon.getLocalPart(), 2);
        this.checkPosListOrdinates(doc, 2 * poly.getNumPoints());
    }

    public void testEncodeCurved() throws Exception {
        Polygon poly = GML3MockData.curvePolygon();
        Document doc = this.encode(poly, GML.Polygon);
    }
}

