/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import org.geotools.data.DataTestCase;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.gml3.bindings.DelayedSchemaFeatureCollection;
import org.junit.Test;

public class DelayedSchemaFeatureCollectionTest
extends DataTestCase {
    public DelayedSchemaFeatureCollectionTest() {
        super(DelayedSchemaFeatureCollectionTest.class.getSimpleName());
    }

    @Test
    public void testEmpty() {
        DelayedSchemaFeatureCollection fc = new DelayedSchemaFeatureCollection();
        DelayedSchemaFeatureCollectionTest.assertEquals((Object)DelayedSchemaFeatureCollection.PLACEHOLDER, (Object)fc.getSchema());
        DelayedSchemaFeatureCollectionTest.assertTrue((boolean)fc.getBounds().isEmpty());
        fc.add(this.riverFeatures[0]);
        DelayedSchemaFeatureCollectionTest.assertFalse((boolean)fc.getBounds().isEmpty());
        DelayedSchemaFeatureCollectionTest.assertEquals((Object)this.riverType, (Object)fc.getSchema());
    }

    @Test
    public void testTwoTypes() {
        DelayedSchemaFeatureCollection fc = new DelayedSchemaFeatureCollection();
        fc.add(this.riverFeatures[0]);
        fc.add(this.lakeFeatures[0]);
        DelayedSchemaFeatureCollectionTest.assertEquals((Object)this.riverType, (Object)fc.getSchema());
        try (SimpleFeatureIterator it = fc.features();){
            DelayedSchemaFeatureCollectionTest.assertEquals((Object)this.riverFeatures[0], (Object)it.next());
            DelayedSchemaFeatureCollectionTest.assertEquals((Object)this.lakeFeatures[0], (Object)it.next());
            DelayedSchemaFeatureCollectionTest.assertFalse((boolean)it.hasNext());
        }
    }
}

