/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import java.util.Arrays;
import java.util.Date;
import javax.xml.namespace.QName;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.CurvedGeometryFactory;
import org.geotools.geometry.jts.LiteCoordinateSequence;
import org.geotools.geometry.jts.LiteCoordinateSequenceFactory;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.gml3.GML;
import org.geotools.gml3.bindings.TEST;
import org.geotools.referencing.CRS;
import org.geotools.xsd.XSD;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class GML3MockData {
    static CurvedGeometryFactory gf = new CurvedGeometryFactory(0.1);
    static LiteCoordinateSequenceFactory liteCSF = new LiteCoordinateSequenceFactory();
    static GeometryFactory liteGF = new GeometryFactory((CoordinateSequenceFactory)liteCSF);
    static XSD gml = GML.getInstance();

    public static void setGML(XSD gml) {
        if (gml == null) {
            gml = GML.getInstance();
        }
        GML3MockData.gml = gml;
    }

    public static Element point(Document document, Node parent) {
        Element point = GML3MockData.element(GML3MockData.qName("Point"), document, parent);
        point.setAttribute("srsName", "urn:x-ogc:def:crs:EPSG:6.11.2:4326");
        Element pos = GML3MockData.element(GML3MockData.qName("pos"), document, point);
        pos.appendChild(document.createTextNode("1.0 2.0 "));
        return point;
    }

    public static Element point3D(Document document, Node parent) {
        return GML3MockData.point3D(document, parent, true);
    }

    public static Element point3D(Document document, Node parent, boolean addDimension) {
        Element point = GML3MockData.element(GML.Point, document, parent);
        point.setAttribute("srsName", "urn:x-ogc:def:crs:EPSG:6.11.2:4326");
        if (addDimension) {
            point.setAttribute("srsDimension", "3");
        }
        Element pos = GML3MockData.element(GML3MockData.qName("pos"), document, point);
        pos.appendChild(document.createTextNode("1.0 2.0 10.0"));
        return point;
    }

    public static CoordinateReferenceSystem crs() {
        try {
            return CRS.decode((String)"urn:x-ogc:def:crs:EPSG:6.11.2:4326");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Envelope bounds() {
        return new ReferencedEnvelope(0.0, 10.0, 0.0, 10.0, GML3MockData.crs());
    }

    public static Point point() {
        Point p = gf.createPoint(new Coordinate(1.0, 2.0));
        p.setUserData((Object)GML3MockData.crs());
        return p;
    }

    public static Point pointLite2D() {
        return liteGF.createPoint((CoordinateSequence)new LiteCoordinateSequence(new double[]{1.0, 2.0}, 2));
    }

    public static Point pointLite3D() {
        return liteGF.createPoint((CoordinateSequence)new LiteCoordinateSequence(new double[]{1.0, 2.0, 100.0}, 3));
    }

    public static LineString lineString() {
        return gf.createLineString(new Coordinate[]{new Coordinate(1.0, 2.0), new Coordinate(3.0, 4.0)});
    }

    public static LineString lineStringLite2D() {
        return liteGF.createLineString(new Coordinate[]{new Coordinate(1.0, 2.0), new Coordinate(3.0, 4.0)});
    }

    public static LineString lineStringLite2D(int size) {
        Coordinate[] coords = new Coordinate[size];
        for (int i = 0; i < size; ++i) {
            coords[i] = new Coordinate((double)i, (double)(i + 1));
        }
        return liteGF.createLineString(coords);
    }

    public static LineString lineStringLite3D() {
        return liteGF.createLineString(liteCSF.create(new double[]{1.0, 2.0, 100.0, 3.0, 4.0, 200.0}, 3));
    }

    public static Element lineString(Document document, Node parent) {
        return GML3MockData.lineStringWithPos(document, parent);
    }

    public static Element lineStringProperty(Document document, Node parent) {
        Element property = GML3MockData.element(GML3MockData.qName("lineStringProperty"), document, parent);
        GML3MockData.lineString(document, property);
        return property;
    }

    public static Element lineStringWithPos(Document document, Node parent) {
        Element lineString = GML3MockData.element(GML3MockData.qName("LineString"), document, parent);
        Element pos = GML3MockData.element(GML3MockData.qName("pos"), document, lineString);
        pos.appendChild(document.createTextNode("1.0 2.0"));
        pos = GML3MockData.element(GML3MockData.qName("pos"), document, lineString);
        pos.appendChild(document.createTextNode("3.0 4.0"));
        return lineString;
    }

    public static Element lineStringWithPos3D(Document document, Node parent) {
        Element lineString = GML3MockData.element(GML3MockData.qName("LineString"), document, parent);
        lineString.setAttribute("srsDimension", "3");
        Element pos = GML3MockData.element(GML3MockData.qName("pos"), document, lineString);
        pos.appendChild(document.createTextNode("1.0 2.0 10.0"));
        pos = GML3MockData.element(GML3MockData.qName("pos"), document, lineString);
        pos.appendChild(document.createTextNode("3.0 4.0 20.0"));
        return lineString;
    }

    public static Element lineStringWithPosList(Document document, Node parent) {
        Element lineString = GML3MockData.element(GML3MockData.qName("LineString"), document, parent);
        Element posList = GML3MockData.element(GML3MockData.qName("posList"), document, lineString);
        posList.appendChild(document.createTextNode("1.0 2.0 3.0 4.0"));
        return lineString;
    }

    public static Element lineStringWithPosList3D(Document document, Node parent) {
        return GML3MockData.lineStringWithPosList3D(document, parent, true);
    }

    public static Element lineStringWithPosList3D(Document document, Node parent, boolean addSrsDimension) {
        Element lineString = GML3MockData.element(GML3MockData.qName("LineString"), document, parent);
        if (addSrsDimension) {
            lineString.setAttribute("srsDimension", "3");
        }
        Element posList = GML3MockData.element(GML3MockData.qName("posList"), document, lineString);
        posList.appendChild(document.createTextNode("1.0 2.0 10.0 3.0 4.0 20.0"));
        return lineString;
    }

    public static Element arcWithPosList(Document document, Node parent) {
        Element arc = GML3MockData.element(GML3MockData.qName("Arc"), document, parent);
        Element posList = GML3MockData.element(GML3MockData.qName("posList"), document, arc);
        posList.appendChild(document.createTextNode("1.0 1.0 2.0 2.0 3.0 1.0"));
        return arc;
    }

    public static Element arcStringWithPosList(Document document, Node parent) {
        Element arc = GML3MockData.element(GML3MockData.qName("ArcString"), document, parent);
        Element posList = GML3MockData.element(GML3MockData.qName("posList"), document, arc);
        posList.appendChild(document.createTextNode("1.0 1.0 2.0 2.0 3.0 1.0 5 5 7 3"));
        return arc;
    }

    public static Element circleWithPosList(Document document, Node parent) {
        Element circle = GML3MockData.element(GML3MockData.qName("Circle"), document, parent);
        Element posList = GML3MockData.element(GML3MockData.qName("posList"), document, circle);
        posList.appendChild(document.createTextNode("1.0 1.0 2.0 2.0 3.0 1.0"));
        return circle;
    }

    public static LinearRing linearRing() {
        return gf.createLinearRing(new Coordinate[]{new Coordinate(1.0, 1.0), new Coordinate(2.0, 2.0), new Coordinate(3.0, 3.0), new Coordinate(1.0, 1.0)});
    }

    public static Element linearRing(Document document, Node parent) {
        return GML3MockData.linearRingWithPos(document, parent);
    }

    public static Element linearRingWithPos(Document document, Node parent) {
        Element linearRing = GML3MockData.element(GML3MockData.qName("LinearRing"), document, parent);
        Element pos = GML3MockData.element(GML3MockData.qName("pos"), document, linearRing);
        pos.appendChild(document.createTextNode("1.0 2.0"));
        pos = GML3MockData.element(GML3MockData.qName("pos"), document, linearRing);
        pos.appendChild(document.createTextNode("3.0 4.0"));
        pos = GML3MockData.element(GML3MockData.qName("pos"), document, linearRing);
        pos.appendChild(document.createTextNode("5.0 6.0"));
        pos = GML3MockData.element(GML3MockData.qName("pos"), document, linearRing);
        pos.appendChild(document.createTextNode("1.0 2.0"));
        return linearRing;
    }

    public static Element linearRingWithPos3D(Document document, Node parent, boolean addSrsDimension) {
        Element linearRing = GML3MockData.element(GML3MockData.qName("LinearRing"), document, parent);
        if (addSrsDimension) {
            linearRing.setAttribute("srsDimension", "3");
        }
        Element pos = GML3MockData.element(GML3MockData.qName("pos"), document, linearRing);
        pos.appendChild(document.createTextNode("1.0 2.0 10.0"));
        pos = GML3MockData.element(GML3MockData.qName("pos"), document, linearRing);
        pos.appendChild(document.createTextNode("3.0 4.0 20.0"));
        pos = GML3MockData.element(GML3MockData.qName("pos"), document, linearRing);
        pos.appendChild(document.createTextNode("5.0 6.0 30.0"));
        pos = GML3MockData.element(GML3MockData.qName("pos"), document, linearRing);
        pos.appendChild(document.createTextNode("1.0 2.0 10.0"));
        return linearRing;
    }

    public static Element linearRingWithPosList(Document document, Node parent) {
        Element linearRing = GML3MockData.element(GML3MockData.qName("LinearRing"), document, parent);
        Element posList = GML3MockData.element(GML3MockData.qName("posList"), document, linearRing);
        linearRing.appendChild(posList);
        posList.appendChild(document.createTextNode("1.0 2.0 3.0 4.0 5.0 6.0 1.0 2.0"));
        return linearRing;
    }

    public static Element linearRingWithPosList3D(Document document, Node parent, boolean addSrsDimension) {
        Element linearRing = GML3MockData.element(GML3MockData.qName("LinearRing"), document, parent);
        if (addSrsDimension) {
            linearRing.setAttribute("srsDimension", "3");
        }
        Element posList = GML3MockData.element(GML3MockData.qName("posList"), document, linearRing);
        linearRing.appendChild(posList);
        posList.appendChild(document.createTextNode("1.0 2.0 10.0 3.0 4.0 20.0 5.0 6.0 30.0 1.0 2.0 10.0"));
        return linearRing;
    }

    public static Polygon polygon() {
        return gf.createPolygon(GML3MockData.linearRing(), null);
    }

    public static Polygon polygonLite2D() {
        return liteGF.createPolygon(liteGF.createLinearRing(liteCSF.create(new double[]{1.0, 1.0, 2.0, 1.0, 2.0, 2.0, 1.0, 2.0, 1.0, 1.0}, 2)), null);
    }

    public static Polygon polygonLite3D() {
        return liteGF.createPolygon(liteGF.createLinearRing(liteCSF.create(new double[]{1.0, 1.0, 100.0, 2.0, 1.0, 99.0, 2.0, 2.0, 98.0, 1.0, 2.0, 97.0, 1.0, 1.0, 100.0}, 3)), null);
    }

    public static Element polygon(Document document, Node parent) {
        return GML3MockData.polygon(document, parent, GML3MockData.qName("Polygon"), false);
    }

    public static Element polygonWithPosList(Document document, Node parent) {
        return GML3MockData.polygonWithPosList(document, parent, GML3MockData.qName("Polygon"), false);
    }

    public static Element polygonWithPosList3D(Document document, Node parent) {
        return GML3MockData.polygonWithPosList3D(document, parent, GML3MockData.qName("Polygon"), false);
    }

    public static Element polygon(Document document, Node parent, QName name, boolean withInterior) {
        Element polygon = GML3MockData.element(name, document, parent);
        Element exterior = GML3MockData.element(GML3MockData.qName("exterior"), document, polygon);
        GML3MockData.linearRing(document, exterior);
        if (withInterior) {
            Element interior = GML3MockData.element(GML3MockData.qName("interior"), document, polygon);
            GML3MockData.linearRing(document, interior);
        }
        return polygon;
    }

    public static Element polygon3D(Document document, Node parent, boolean addSrsDimension) {
        return GML3MockData.polygonWithPos3D(document, parent, GML3MockData.qName("Polygon"), true);
    }

    public static Element polygonWithPos3D(Document document, Node parent, QName name, boolean addSrsDimension) {
        Element polygon = GML3MockData.element(name, document, parent);
        if (addSrsDimension) {
            polygon.setAttribute("srsDimension", "3");
        }
        Element exterior = GML3MockData.element(GML3MockData.qName("exterior"), document, polygon);
        GML3MockData.linearRingWithPos3D(document, exterior, false);
        Element interior = GML3MockData.element(GML3MockData.qName("interior"), document, polygon);
        GML3MockData.linearRingWithPos3D(document, interior, false);
        return polygon;
    }

    public static Element polygonWithPosList(Document document, Node parent, QName name, boolean withInterior) {
        Element polygon = GML3MockData.element(name, document, parent);
        Element exterior = GML3MockData.element(GML3MockData.qName("exterior"), document, polygon);
        GML3MockData.linearRingWithPosList(document, exterior);
        if (withInterior) {
            Element interior = GML3MockData.element(GML3MockData.qName("interior"), document, polygon);
            GML3MockData.linearRingWithPosList(document, interior);
        }
        return polygon;
    }

    public static Element polygonWithPosList3D(Document document, Node parent, boolean addSrsDimension) {
        return GML3MockData.polygonWithPosList3D(document, parent, GML3MockData.qName("Polygon"), true);
    }

    public static Element polygonWithPosList3D(Document document, Node parent, QName name, boolean addSrsDimension) {
        Element polygon = GML3MockData.element(name, document, parent);
        if (addSrsDimension) {
            polygon.setAttribute("srsDimension", "3");
        }
        Element exterior = GML3MockData.element(GML3MockData.qName("exterior"), document, polygon);
        GML3MockData.linearRingWithPosList3D(document, exterior, false);
        Element interior = GML3MockData.element(GML3MockData.qName("interior"), document, polygon);
        GML3MockData.linearRingWithPosList3D(document, interior, false);
        return polygon;
    }

    public static MultiPoint multiPoint() {
        return gf.createMultiPoint((CoordinateSequence)new CoordinateArraySequence(new Coordinate[]{new Coordinate(1.0, 1.0), new Coordinate(2.0, 2.0)}));
    }

    public static Element multiPoint(Document document, Node parent) {
        Element multiPoint = GML3MockData.element(GML3MockData.qName("MultiPoint"), document, parent);
        Element pointMember = GML3MockData.element(GML3MockData.qName("pointMember"), document, multiPoint);
        GML3MockData.point(document, pointMember);
        pointMember = GML3MockData.element(GML3MockData.qName("pointMember"), document, multiPoint);
        GML3MockData.point(document, pointMember);
        Element pointMembers = GML3MockData.element(GML3MockData.qName("pointMembers"), document, multiPoint);
        GML3MockData.point(document, pointMembers);
        GML3MockData.point(document, pointMembers);
        return multiPoint;
    }

    public static Element multiPoint3D(Document document, Node parent) {
        Element multiPoint = GML3MockData.element(GML3MockData.qName("MultiPoint"), document, parent);
        multiPoint.setAttribute("srsDimensions", "3");
        Element pointMember = GML3MockData.element(GML3MockData.qName("pointMember"), document, multiPoint);
        GML3MockData.point3D(document, pointMember, false);
        pointMember = GML3MockData.element(GML3MockData.qName("pointMember"), document, multiPoint);
        GML3MockData.point3D(document, pointMember, false);
        Element pointMembers = GML3MockData.element(GML3MockData.qName("pointMembers"), document, multiPoint);
        GML3MockData.point3D(document, pointMembers, false);
        GML3MockData.point3D(document, pointMembers, false);
        return multiPoint;
    }

    public static MultiLineString multiLineString() {
        return gf.createMultiLineString(new LineString[]{GML3MockData.lineString(), GML3MockData.lineString()});
    }

    public static LineString compoundCurve() {
        CurvedGeometryFactory factory = new CurvedGeometryFactory(0.1);
        LineString curve = factory.createCurvedGeometry((CoordinateSequence)new LiteCoordinateSequence(new double[]{1.0, 1.0, 2.0, 2.0, 3.0, 1.0, 5.0, 5.0, 7.0, 3.0}));
        LineString straight = factory.createLineString((CoordinateSequence)new LiteCoordinateSequence(new double[]{7.0, 3.0, 10.0, 15.0}));
        LineString compound = factory.createCurvedGeometry(new LineString[]{curve, straight});
        return compound;
    }

    public static Element multiLineString(Document document, Node parent) {
        Element multiLineString = GML3MockData.element(GML3MockData.qName("MultiLineString"), document, parent);
        Element lineStringMember = GML3MockData.element(GML3MockData.qName("lineStringMember"), document, multiLineString);
        GML3MockData.lineString(document, lineStringMember);
        lineStringMember = GML3MockData.element(GML3MockData.qName("lineStringMember"), document, multiLineString);
        GML3MockData.lineString(document, lineStringMember);
        return multiLineString;
    }

    public static Element multiLineString3D(Document document, Node parent) {
        Element multiLineString = GML3MockData.element(GML3MockData.qName("MultiLineString"), document, parent);
        multiLineString.setAttribute("srsDimension", "3");
        Element lineStringMember = GML3MockData.element(GML3MockData.qName("lineStringMember"), document, multiLineString);
        GML3MockData.lineStringWithPosList3D(document, lineStringMember, false);
        lineStringMember = GML3MockData.element(GML3MockData.qName("lineStringMember"), document, multiLineString);
        GML3MockData.lineStringWithPosList3D(document, lineStringMember, false);
        return multiLineString;
    }

    public static Element multiCurve(Document document, Node parent) {
        return GML3MockData.multiCurve(document, parent, true);
    }

    public static Element multiCurve(Document document, Node parent, boolean useCurveMember) {
        Element multiCurve = GML3MockData.element(GML3MockData.qName("MultiCurve"), document, parent);
        if (useCurveMember) {
            Element curveMember = GML3MockData.element(GML3MockData.qName("curveMember"), document, multiCurve);
            GML3MockData.lineString(document, curveMember);
            curveMember = GML3MockData.element(GML3MockData.qName("curveMember"), document, multiCurve);
            GML3MockData.lineString(document, curveMember);
        } else {
            Element curveMembers = GML3MockData.element(GML3MockData.qName("curveMembers"), document, multiCurve);
            GML3MockData.lineString(document, curveMembers);
            GML3MockData.lineString(document, curveMembers);
        }
        return multiCurve;
    }

    public static MultiPolygon multiPolygon() {
        return gf.createMultiPolygon(new Polygon[]{GML3MockData.polygon(), GML3MockData.polygon()});
    }

    public static Polygon curvePolygon() {
        LineString curve1 = gf.createCurvedGeometry(2, new double[]{0.0, 0.0, 2.0, 0.0, 2.0, 1.0, 2.0, 3.0, 4.0, 3.0});
        LineString line1 = gf.createLineString((CoordinateSequence)new LiteCoordinateSequence(new double[]{4.0, 3.0, 4.0, 5.0, 1.0, 4.0, 0.0, 0.0}));
        LinearRing shell = (LinearRing)gf.createCurvedGeometry(Arrays.asList(curve1, line1));
        LinearRing hole = (LinearRing)gf.createCurvedGeometry(2, new double[]{1.7, 1.0, 1.4, 0.4, 1.6, 0.4, 1.6, 0.5, 1.7, 1.0});
        return gf.createPolygon(shell, new LinearRing[]{hole});
    }

    public static Element multiPolygon(Document document, Node parent) {
        Element multiPolygon = GML3MockData.element(GML3MockData.qName("MultiPolygon"), document, parent);
        Element polygonMember = GML3MockData.element(GML3MockData.qName("polygonMember"), document, multiPolygon);
        GML3MockData.polygon(document, polygonMember);
        polygonMember = GML3MockData.element(GML3MockData.qName("polygonMember"), document, multiPolygon);
        GML3MockData.polygon(document, polygonMember);
        return multiPolygon;
    }

    public static Element multiPolygon3D(Document document, Node parent) {
        Element multiPolygon = GML3MockData.element(GML3MockData.qName("MultiPolygon"), document, parent);
        multiPolygon.setAttribute("srsDimension", "3");
        Element polygonMember = GML3MockData.element(GML3MockData.qName("polygonMember"), document, multiPolygon);
        GML3MockData.polygon3D(document, polygonMember, false);
        polygonMember = GML3MockData.element(GML3MockData.qName("polygonMember"), document, multiPolygon);
        GML3MockData.polygon3D(document, polygonMember, false);
        return multiPolygon;
    }

    public static Element multiSurface(Document document, Node parent) {
        return GML3MockData.multiSurface(document, parent, true);
    }

    public static Element multiSurface(Document document, Node parent, boolean useSurfaceMember) {
        Element multiSurface = GML3MockData.element(GML3MockData.qName("MultiSurface"), document, parent);
        if (useSurfaceMember) {
            Element surfaceMember = GML3MockData.element(GML3MockData.qName("surfaceMember"), document, multiSurface);
            GML3MockData.polygon(document, surfaceMember);
            surfaceMember = GML3MockData.element(GML3MockData.qName("surfaceMember"), document, multiSurface);
            GML3MockData.polygon(document, surfaceMember);
        } else {
            Element surfaceMembers = GML3MockData.element(GML3MockData.qName("surfaceMembers"), document, multiSurface);
            GML3MockData.polygon(document, surfaceMembers);
            GML3MockData.polygon(document, surfaceMembers);
        }
        return multiSurface;
    }

    public static GeometryCollection multiGeometry() {
        return gf.createGeometryCollection(new Geometry[]{GML3MockData.point(), GML3MockData.lineString(), GML3MockData.polygon()});
    }

    public static Element multiGeometry(Document document, Node parent) {
        Element multiGeometry = GML3MockData.element(GML3MockData.qName("MultiGeometry"), document, parent);
        Element geometryMember = GML3MockData.element(GML3MockData.qName("geometryMember"), document, multiGeometry);
        GML3MockData.point(document, geometryMember);
        geometryMember = GML3MockData.element(GML3MockData.qName("geometryMember"), document, multiGeometry);
        GML3MockData.lineString(document, geometryMember);
        geometryMember = GML3MockData.element(GML3MockData.qName("geometryMember"), document, multiGeometry);
        GML3MockData.polygon(document, geometryMember);
        return multiGeometry;
    }

    public static Element surface(Document document, Node parent) {
        Element surface = GML3MockData.element(GML3MockData.qName("Surface"), document, parent);
        Element patches = GML3MockData.element(GML3MockData.qName("patches"), document, surface);
        GML3MockData.polygon(document, patches, GML3MockData.qName("PolygonPatch"), true);
        return surface;
    }

    public static Element feature(Document document, Node parent) {
        Element feature = GML3MockData.element(TEST.TestFeature, document, parent);
        Element geom = GML3MockData.element(new QName(TEST.NAMESPACE, "geom"), document, feature);
        GML3MockData.point(document, geom);
        Element count = GML3MockData.element(new QName(TEST.NAMESPACE, "count"), document, feature);
        count.appendChild(document.createTextNode("1"));
        return feature;
    }

    public static SimpleFeature feature() throws Exception {
        SimpleFeatureTypeBuilder typeBuilder = new SimpleFeatureTypeBuilder();
        typeBuilder.setName(TEST.TestFeature.getLocalPart());
        typeBuilder.setNamespaceURI(TEST.TestFeature.getNamespaceURI());
        typeBuilder.add("name", String.class);
        typeBuilder.add("description", String.class);
        typeBuilder.add("geom", Point.class);
        typeBuilder.add("count", Integer.class);
        typeBuilder.add("date", Date.class);
        SimpleFeatureType type = typeBuilder.buildFeatureType();
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(type);
        builder.add((Object)"theName");
        builder.add((Object)"theDescription");
        builder.add((Object)GML3MockData.point());
        builder.add((Object)1);
        builder.add((Object)new Date());
        return builder.buildFeature("fid.1");
    }

    public static Element featureMember(Document document, Node parent) {
        Element featureMember = GML3MockData.element(GML3MockData.qName("featureMember"), document, parent);
        GML3MockData.feature(document, featureMember);
        return featureMember;
    }

    public static Element element(QName name, Document document, Node parent) {
        Element element = document.createElementNS(name.getNamespaceURI(), name.getLocalPart());
        if (parent != null) {
            parent.appendChild(element);
        }
        return element;
    }

    public static QName qName(String local) {
        return gml.qName(local);
    }
}

